/* *##% 
 * EUGene - plugin maven
 * Copyright (C) 2006 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/
package org.nuiton.eugene.plugin;

import java.io.IOException;
import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.plugin.PluginIOContext;
import org.nuiton.plugin.PluginHelper;

/**
 * Extract zipped XMI files from zargo archive.
 * 
 * @author ruchaud
 * @version $Revision: 692 $
 *
 * Last update: $Date: 2009-11-04 18:41:32 +0100 (mer. 04 nov. 2009) $
 * by : $Author: fdesbois $
 * 
 * @goal zargo2xmi
 */
public class Zargo2Xmi extends EugeneAbstractMojo {

    public static final String[] ZARGO_FILE_FILTER = new String[]{"**/*.zargo", "**/*.zuml"};
    public static final String[] XMI_FILE_FILTER = new String[]{"*.xmi", "**/*.xmi"};
    /**
     * Les entrées-sorties du plugin.
     *
     * <p/>
     * 
     * En entrée on demande des répertoires où chercher les fichiers zargo a convertir.
     * <p/>
     * En sortie on demande le répertoire ou extraire les xmi et copier les resources.
     * <p/>
     * Par défaut on a les valeurs suivantes :
     * </p>
     * <pre>
     * &lt;zargoResources&gt;
     * </p>
     *   &lt;input&gt;src/main/xmi&lt;/input&gt;
     * </p>
     *   &lt;output&gt;target/generated-sources/xmi&lt;/ouput&gt;
     * </p>
     * &lt;/zargoResources&gt;
     * </pre>
     * </p>
     *
     * Note: si {@link #testPhase} est activée, les valeurs par défaut sont :
     * </p>
     * <pre>
     * &lt;zargoResources&gt;
     * </p>
     *   &lt;input&gt;src/test/xmi&lt;/input&gt;
     * </p>
     *   &lt;output&gt;target/generated-sources/test-xmi&lt;/ouput&gt;
     * </p>
     * &lt;zargoResources&gt;
     * </pre>
     *
     * @parameter
     * @since 1.0.0-rc-8
     */
    protected PluginIOContext zargoResources;

    @Override
    public void doAction() throws MojoExecutionException, MojoFailureException {
        getLog().info("Extract zipped XMI files from zargo archive and copy resources");

        getLog().info("Extract zipped XMI files");
        try {
            PluginHelper.expandFiles(zargoResources, ZARGO_FILE_FILTER, null, XMI_FILE_FILTER, overwrite);
        } catch (IOException ex) {
            throw new MojoExecutionException("could not expand files for reason " + ex.getMessage(), ex);
        }

        getLog().info("Copy resources");
        try {
            PluginHelper.copyFiles(zargoResources, null, ZARGO_FILE_FILTER, overwrite);
        } catch (IOException ex) {
            throw new MojoExecutionException("could not copy some files for reason " + ex.getMessage(), ex);
        }

    }

    @Override
    protected PluginIOContext getResources() {
        return zargoResources;
    }

    @Override
    protected PluginIOContext initResources() {

        File defaultIn = getFileFromBasedir("src", "main", "xmi");
        File defaultOut = getFileFromBasedir("target", "generated-sources", "xmi");

        File defaultTestIn = getFileFromBasedir("src", "test", "xmi");
        File defaultTestOut = getFileFromBasedir("target", "generated-sources", "test-xmi");

        zargoResources = initResources(defaultIn, defaultOut, defaultTestIn, defaultTestOut);

        return zargoResources;
    }
}
