/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.storemigration;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Properties;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.CurrentDatabase;
import org.neo4j.kernel.impl.storemigration.DatabaseFiles;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.validation.DatabaseLocationMustBeSpecifiedRule;
import org.neo4j.server.configuration.validation.Validator;
import org.neo4j.server.logging.Logger;

public class PreStartupStoreUpgrader {
    private final Logger logger = Logger.getLogger(PreStartupStoreUpgrader.class);
    private Properties systemProperties;
    private PrintStream out;

    public static void main(String[] args) throws IOException {
        PreStartupStoreUpgrader preStartupStoreUpgrader = new PreStartupStoreUpgrader(System.getProperties(), System.out);
        int exit = preStartupStoreUpgrader.run();
        if (exit != 0) {
            System.exit(exit);
        }
    }

    public PreStartupStoreUpgrader(Properties systemProperties, PrintStream out) {
        this.systemProperties = systemProperties;
        this.out = out;
    }

    public int run() {
        try {
            Configurator configurator = this.getConfigurator();
            HashMap<String, String> config = new HashMap<String, String>(configurator.getDatabaseTuningProperties());
            String dbLocation = new File(configurator.configuration().getString("org.neo4j.server.database.location")).getAbsolutePath();
            if (new CurrentDatabase().storeFilesAtCurrentVersion(new File(dbLocation))) {
                return 0;
            }
            String separator = System.getProperty("file.separator");
            String store = dbLocation + separator + "neostore";
            config.put("store_dir", dbLocation);
            config.put("neo_store", store);
            if (!new UpgradableDatabase().storeFilesUpgradeable(new File(store))) {
                this.logger.info("Store files missing, or not in suitable state for upgrade. Leaving this problem for main server process to resolve.", new Object[0]);
                return 0;
            }
            DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
            Config conf = new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(config));
            StoreUpgrader storeUpgrader = new StoreUpgrader(conf, StringLogger.SYSTEM, (UpgradeConfiguration)new ConfigMapUpgradeConfiguration(conf), new UpgradableDatabase(), new StoreMigrator((MigrationProgressMonitor)new VisibleMigrationProgressMonitor(this.out)), new DatabaseFiles(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (FileSystemAbstraction)fileSystem);
            try {
                storeUpgrader.attemptUpgrade(store);
            }
            catch (UpgradeNotAllowedByConfigurationException e) {
                this.logger.info(e.getMessage(), new Object[0]);
                this.out.println(e.getMessage());
                return 1;
            }
            catch (StoreUpgrader.UnableToUpgradeException e) {
                this.logger.error(e);
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            this.logger.error(e);
            return 1;
        }
    }

    protected Configurator getConfigurator() {
        File configFile = new File(this.systemProperties.getProperty("org.neo4j.server.properties", Configurator.DEFAULT_CONFIG_DIR));
        return new PropertyFileConfigurator(new Validator(new DatabaseLocationMustBeSpecifiedRule()), configFile);
    }
}

