/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.statistic;

import org.neo4j.server.logging.Logger;
import org.neo4j.server.statistic.StatisticData;
import org.neo4j.server.statistic.StatisticRecord;

public class StatisticCollector {
    private static final Logger LOG = Logger.getLogger(StatisticCollector.class);
    private volatile long start = System.currentTimeMillis();
    private volatile long count = 0L;
    private volatile StatisticData currentSize = new StatisticData();
    private volatile StatisticData currentDuration = new StatisticData();
    private StatisticRecord snapshot = this.createSnapshot();

    public StatisticRecord currentSnapshot() {
        return this.snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatisticRecord createSnapshot() {
        long period;
        long timeStamp;
        long previousCount;
        StatisticData previousSize;
        StatisticData previousDuration;
        StatisticCollector statisticCollector = this;
        synchronized (statisticCollector) {
            previousDuration = this.currentDuration.copy();
            previousSize = this.currentSize.copy();
            previousCount = this.count;
            long previousStart = this.start;
            this.currentDuration = new StatisticData();
            this.currentSize = new StatisticData();
            this.start = System.currentTimeMillis();
            this.count = 0L;
            timeStamp = this.start;
            period = this.start - previousStart;
        }
        this.snapshot = new StatisticRecord(timeStamp, period, previousCount, previousDuration, previousSize);
        return this.snapshot;
    }

    public synchronized void update(double time, long size) {
        this.currentDuration.addValue(time);
        this.currentSize.addValue(size);
        ++this.count;
    }
}

