/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.server.rest.domain.GraphDatabaseName;

public class UriToDatabaseMatcher {
    private static ArrayList<Tuple> tuples = new ArrayList();

    public GraphDatabaseName lookup(URI requestUri) {
        for (int i = 0; i < tuples.size(); ++i) {
            Tuple t = tuples.get(i);
            Matcher matcher = t.pattern.matcher(requestUri.getPath());
            if (!matcher.matches()) continue;
            return t.graphDatabaseName;
        }
        return GraphDatabaseName.NO_NAME;
    }

    public void add(GraphDatabaseName databaseName) {
        tuples.add(new Tuple(Pattern.compile("^.*" + databaseName.getName() + ".*$"), databaseName));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = tuples.size() - 1; i >= 0; --i) {
            Tuple t = tuples.get(i);
            sb.append(t);
        }
        return sb.toString();
    }

    private static class Tuple {
        public GraphDatabaseName graphDatabaseName;
        public Pattern pattern;

        public Tuple(Pattern pattern, GraphDatabaseName graphDatabaseName) {
            this.pattern = pattern;
            this.graphDatabaseName = graphDatabaseName;
        }

        public String toString() {
            return this.pattern.toString() + " => " + this.graphDatabaseName + System.getProperty("line.separator");
        }
    }
}

