/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Traverser;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.server.rest.domain.EvaluationException;
import org.neo4j.server.rest.domain.EvaluatorFactory;
import org.neo4j.server.rest.domain.RelationshipDirection;

public class TraversalDescriptionBuilder {
    public static TraversalDescription from(Map<String, Object> description) {
        try {
            TraversalDescription result = Traversal.description();
            result = TraversalDescriptionBuilder.describeOrder(result, description);
            result = TraversalDescriptionBuilder.describeUniqueness(result, description);
            result = TraversalDescriptionBuilder.describeRelationships(result, description);
            result = TraversalDescriptionBuilder.describePruneEvaluator(result, description);
            result = TraversalDescriptionBuilder.describeReturnFilter(result, description);
            return result;
        }
        catch (NoClassDefFoundError e) {
            throw new EvaluationException(e);
        }
    }

    private static TraversalDescription describeReturnFilter(TraversalDescription result, Map<String, Object> description) {
        Object returnDescription = description.get("return_filter");
        if (returnDescription != null) {
            Evaluator filter = EvaluatorFactory.returnFilter((Map)returnDescription);
            if (filter != null) {
                result = result.evaluator(filter);
            }
        } else {
            result = result.evaluator(Evaluators.excludeStartPosition());
        }
        return result;
    }

    private static TraversalDescription describePruneEvaluator(TraversalDescription result, Map<String, Object> description) {
        Object maxDepth;
        Evaluator pruner;
        Object pruneDescription = description.get("prune_evaluator");
        if (pruneDescription != null && (pruner = EvaluatorFactory.pruneEvaluator((Map)pruneDescription)) != null) {
            result = result.evaluator(pruner);
        }
        Object object = maxDepth = (maxDepth = description.get("max_depth")) != null || pruneDescription != null ? maxDepth : Integer.valueOf(1);
        if (maxDepth != null) {
            result = result.evaluator(Evaluators.toDepth((int)((Number)maxDepth).intValue()));
        }
        return result;
    }

    private static TraversalDescription describeRelationships(TraversalDescription result, Map<String, Object> description) {
        Object relationshipsDescription = description.get("relationships");
        if (relationshipsDescription != null) {
            List<Object> pairDescriptions = relationshipsDescription instanceof Collection ? (List<Object>)relationshipsDescription : Arrays.asList(relationshipsDescription);
            Expander expander = Traversal.emptyExpander();
            for (Object e : pairDescriptions) {
                Map map = (Map)e;
                String name = (String)map.get("type");
                DynamicRelationshipType type = DynamicRelationshipType.withName((String)name);
                String directionName = (String)map.get("direction");
                expander = directionName == null ? expander.add((RelationshipType)type) : expander.add((RelationshipType)type, TraversalDescriptionBuilder.stringToEnum((String)directionName, RelationshipDirection.class, (boolean)true).internal);
            }
            result = result.expand((RelationshipExpander)expander);
        }
        return result;
    }

    private static TraversalDescription describeUniqueness(TraversalDescription result, Map<String, Object> description) {
        Object uniquenessDescription = description.get("uniqueness");
        if (uniquenessDescription != null) {
            String name = null;
            Object value = null;
            if (uniquenessDescription instanceof Map) {
                Map map = (Map)uniquenessDescription;
                name = (String)map.get("name");
                value = map.get("value");
            } else {
                name = (String)uniquenessDescription;
            }
            Uniqueness uniqueness = TraversalDescriptionBuilder.stringToEnum(TraversalDescriptionBuilder.enumifyName(name), Uniqueness.class, true);
            result = value == null ? result.uniqueness((UniquenessFactory)uniqueness) : result.uniqueness((UniquenessFactory)uniqueness, value);
        }
        return result;
    }

    private static TraversalDescription describeOrder(TraversalDescription result, Map<String, Object> description) {
        String orderDescription = (String)description.get("order");
        if (orderDescription != null) {
            Traverser.Order order = TraversalDescriptionBuilder.stringToEnum(TraversalDescriptionBuilder.enumifyName(orderDescription), Traverser.Order.class, true);
            switch (order) {
                case BREADTH_FIRST: {
                    result = result.breadthFirst();
                    break;
                }
                case DEPTH_FIRST: {
                    result = result.depthFirst();
                }
            }
        }
        return result;
    }

    private static <T extends Enum<T>> T stringToEnum(String name, Class<T> enumClass, boolean fuzzyMatch) {
        if (name == null) {
            return null;
        }
        for (Enum candidate : (Enum[])enumClass.getEnumConstants()) {
            if (!candidate.name().equals(name)) continue;
            return (T)candidate;
        }
        if (fuzzyMatch) {
            for (Enum candidate : (Enum[])enumClass.getEnumConstants()) {
                if (!candidate.name().startsWith(name)) continue;
                return (T)candidate;
            }
        }
        throw new RuntimeException("Unregognized " + enumClass.getSimpleName() + " '" + name + "'");
    }

    private static String enumifyName(String name) {
        return name.replaceAll(" ", "_").toUpperCase();
    }
}

