/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration.validation;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.configuration.Configuration;
import org.neo4j.server.configuration.validation.RuleFailedException;
import org.neo4j.server.configuration.validation.ValidationRule;

public class WebadminConfigurationRule
implements ValidationRule {
    @Override
    public void validate(Configuration configuration) throws RuleFailedException {
        String managementApi = this.validateConfigurationContainsKey(configuration, "org.neo4j.server.webadmin.management.uri");
        String restApi = this.validateConfigurationContainsKey(configuration, "org.neo4j.server.webadmin.data.uri");
        URI managementUri = this.validateAndNormalizeUri(managementApi, "org.neo4j.server.webadmin.management.uri");
        URI restUri = this.validateAndNormalizeUri(restApi, "org.neo4j.server.webadmin.data.uri");
        configuration.clearProperty("org.neo4j.server.webadmin.management.uri");
        configuration.addProperty("org.neo4j.server.webadmin.management.uri", (Object)managementUri.toString());
        configuration.clearProperty("org.neo4j.server.webadmin.data.uri");
        configuration.addProperty("org.neo4j.server.webadmin.data.uri", (Object)restUri.toString());
    }

    private String trimTrailingSlash(String uri) {
        if (!uri.endsWith("/")) {
            return uri;
        }
        return uri.substring(0, uri.length() - 1);
    }

    private URI validateAndNormalizeUri(String uri, String property) {
        URI result = null;
        try {
            result = new URI(uri).normalize();
            String resultStr = result.toString();
            if (resultStr.endsWith("/")) {
                result = new URI(this.trimTrailingSlash(resultStr));
            }
        }
        catch (URISyntaxException e) {
            new RuleFailedException("The specified URI [%s] for the property [%s] is invalid. Please correct the neo4j-server.properties file.", uri, property);
        }
        return result;
    }

    private String validateConfigurationContainsKey(Configuration configuration, String key) throws RuleFailedException {
        if (!configuration.containsKey(key)) {
            throw new RuleFailedException("Webadmin configuration not found. Check that the neo4j-server.properties file contains the [%s] property.", key);
        }
        return (String)configuration.getProperty(key);
    }
}

