/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.server.HttpConnection;

public class HttpInput
extends ServletInputStream {
    protected final HttpConnection _connection;
    protected final HttpParser _parser;

    public HttpInput(HttpConnection connection) {
        this._connection = connection;
        this._parser = (HttpParser)connection.getParser();
    }

    @Override
    public int read() throws IOException {
        int c = -1;
        Buffer content = this._parser.blockForContent(this._connection.getMaxIdleTime());
        if (content != null) {
            c = 0xFF & content.get();
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = -1;
        Buffer content = this._parser.blockForContent(this._connection.getMaxIdleTime());
        if (content != null) {
            l = content.get(b, off, len);
        }
        return l;
    }

    @Override
    public int available() throws IOException {
        return this._parser.available();
    }
}

