/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import javax.transaction.UserTransaction;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.plus.jndi.Transaction;
import org.eclipse.jetty.plus.webapp.Configuration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.StatisticsServlet;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.TagLibConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlConfiguration;

public class Runner {
    public static final String[] __plusConfigurationClasses = new String[]{WebInfConfiguration.class.getCanonicalName(), WebXmlConfiguration.class.getCanonicalName(), MetaInfConfiguration.class.getCanonicalName(), FragmentConfiguration.class.getCanonicalName(), EnvConfiguration.class.getCanonicalName(), Configuration.class.getCanonicalName(), JettyWebXmlConfiguration.class.getCanonicalName(), TagLibConfiguration.class.getCanonicalName()};
    protected Server _server;
    protected URLClassLoader _classLoader;
    protected List<URL> _classpath = new ArrayList<URL>();
    protected ContextHandlerCollection _contexts;
    protected RequestLogHandler _logHandler;
    protected String _logFile;
    protected String _configFile;
    protected UserTransaction _ut;
    protected String _utId;
    protected String _txMgrPropertiesFile;
    protected Random _random = new Random();
    protected boolean _isTxServiceAvailable = false;
    protected boolean _enableStatsGathering = false;
    protected String _statsPropFile;
    protected boolean _clusteredSessions = true;

    public void usage(String error) {
        if (error != null) {
            System.err.println("ERROR: " + error);
        }
        System.err.println("Usage: java [-DDEBUG] [-Djetty.home=dir] -jar jetty-runner.jar [--help|--version] [ server opts] [[ context opts] context ...] ");
        System.err.println("Server Options:");
        System.err.println(" --version                          - display version and exit");
        System.err.println(" --log file                         - request log filename (with optional 'yyyy_mm_dd' wildcard");
        System.err.println(" --out file                         - info/warn/debug log filename (with optional 'yyyy_mm_dd' wildcard");
        System.err.println(" --port n                           - port to listen on (default 8080)");
        System.err.println(" --jar file                         - a jar to be added to the classloader");
        System.err.println("--jdbc classname properties jndiname - classname of XADataSource or driver; properties string; name to register in jndi");
        System.err.println(" --lib dir                          - a directory of jars to be added to the classloader");
        System.err.println(" --classes dir                      - a directory of classes to be added to the classloader");
        System.err.println(" --txFile                           - override properties file for Atomikos");
        System.err.println(" --stats [unsecure|realm.properties] - enable stats gathering servlet context");
        System.err.println(" --config file                      - a jetty xml config file to use instead of command line options");
        System.err.println("Context Options:");
        System.err.println(" --path /path       - context path (default /)");
        System.err.println(" context            - WAR file, web app dir or context.xml file");
        System.exit(1);
    }

    public void configure(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if ("--version".equals(args[i])) {
                // empty if block
            }
            if ("--lib".equals(args[i])) {
                org.eclipse.jetty.util.resource.Resource lib;
                if (!(lib = org.eclipse.jetty.util.resource.Resource.newResource(args[++i])).exists() || !lib.isDirectory()) {
                    this.usage("No such lib directory " + lib);
                }
                this.expandJars(lib);
                continue;
            }
            if ("--jar".equals(args[i])) {
                org.eclipse.jetty.util.resource.Resource jar;
                if (!(jar = org.eclipse.jetty.util.resource.Resource.newResource(args[++i])).exists() || jar.isDirectory()) {
                    this.usage("No such jar " + jar);
                }
                this._classpath.add(jar.getURL());
                continue;
            }
            if ("--classes".equals(args[i])) {
                org.eclipse.jetty.util.resource.Resource classes;
                if (!(classes = org.eclipse.jetty.util.resource.Resource.newResource(args[++i])).exists() || !classes.isDirectory()) {
                    this.usage("No such classes directory " + classes);
                }
                this._classpath.add(classes.getURL());
                continue;
            }
            if (!args[i].startsWith("--")) continue;
            ++i;
        }
        this.initClassLoader();
        try {
            if (Thread.currentThread().getContextClassLoader().loadClass("com.atomikos.jdbc.SimpleDataSourceBean") != null) {
                this._isTxServiceAvailable = true;
            }
        }
        catch (ClassNotFoundException e) {
            this._isTxServiceAvailable = false;
        }
        if (System.getProperties().containsKey("DEBUG")) {
            Log.getLog().setDebugEnabled(true);
        }
        Log.info("Runner");
        Log.debug("Runner classpath {}", this._classpath);
        String contextPath = "/";
        boolean contextPathSet = false;
        int port = 8080;
        boolean transactionManagerProcessed = false;
        boolean runnerServerInitialized = false;
        for (int i = 0; i < args.length; ++i) {
            org.eclipse.jetty.util.resource.Resource ctx;
            if ("--port".equals(args[i])) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("--log".equals(args[i])) {
                this._logFile = args[++i];
                continue;
            }
            if ("--out".equals(args[i])) {
                String outFile = args[++i];
                PrintStream out = new PrintStream(new RolloverFileOutputStream(outFile, true, -1));
                Log.info("Redirecting stderr/stdout to " + outFile);
                System.setErr(out);
                System.setOut(out);
                continue;
            }
            if ("--path".equals(args[i])) {
                contextPath = args[++i];
                contextPathSet = true;
                continue;
            }
            if ("--config".equals(args[i])) {
                this._configFile = args[++i];
                continue;
            }
            if ("--lib".equals(args[i])) {
                ++i;
                continue;
            }
            if ("--jar".equals(args[i])) {
                ++i;
                continue;
            }
            if ("--classes".equals(args[i])) {
                ++i;
                continue;
            }
            if ("--stats".equals(args[i])) {
                this._enableStatsGathering = true;
                this._statsPropFile = args[++i];
                this._statsPropFile = "unsecure".equalsIgnoreCase(this._statsPropFile) ? null : this._statsPropFile;
                continue;
            }
            if ("--txFile".equals(args[i])) {
                this._txMgrPropertiesFile = args[++i];
                continue;
            }
            if ("--jdbc".equals(args[i])) {
                i = this.configJDBC(args, i);
                continue;
            }
            if (!transactionManagerProcessed) {
                this.processTransactionManagement();
                transactionManagerProcessed = true;
            }
            if (!runnerServerInitialized) {
                Connector[] connectors;
                HandlerCollection handlers;
                if (this._server == null) {
                    this._server = new Server();
                }
                if (this._configFile != null) {
                    XmlConfiguration xmlConfiguration = new XmlConfiguration(org.eclipse.jetty.util.resource.Resource.newResource(this._configFile).getURL());
                    xmlConfiguration.configure(this._server);
                }
                if ((handlers = (HandlerCollection)this._server.getChildHandlerByClass(HandlerCollection.class)) == null) {
                    handlers = new HandlerCollection();
                    this._server.setHandler(handlers);
                }
                this._contexts = (ContextHandlerCollection)handlers.getChildHandlerByClass(ContextHandlerCollection.class);
                if (this._contexts == null) {
                    this._contexts = new ContextHandlerCollection();
                }
                if (this._enableStatsGathering) {
                    StatisticsHandler statsHandler = new StatisticsHandler();
                    handlers.setHandlers(new Handler[]{statsHandler, this._contexts, new DefaultHandler()});
                    ServletContextHandler statsContext = new ServletContextHandler(this._contexts, "/stats");
                    statsContext.addServlet(new ServletHolder(new StatisticsServlet()), "/");
                    statsContext.setSessionHandler(new SessionHandler());
                    if (this._statsPropFile != null) {
                        HashLoginService loginService = new HashLoginService("StatsRealm", this._statsPropFile);
                        Constraint constraint = new Constraint();
                        constraint.setName("Admin Only");
                        constraint.setRoles(new String[]{"admin"});
                        constraint.setAuthenticate(true);
                        ConstraintMapping cm = new ConstraintMapping();
                        cm.setConstraint(constraint);
                        cm.setPathSpec("/*");
                        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
                        securityHandler.setLoginService(loginService);
                        securityHandler.setConstraintMappings(new ConstraintMapping[]{cm});
                        securityHandler.setAuthenticator(new BasicAuthenticator());
                        statsContext.setSecurityHandler(securityHandler);
                    }
                } else {
                    handlers.setHandlers(new Handler[]{this._contexts, new DefaultHandler()});
                }
                this._logHandler = (RequestLogHandler)handlers.getChildHandlerByClass(RequestLogHandler.class);
                if (this._logHandler == null) {
                    this._logHandler = new RequestLogHandler();
                    handlers.addHandler(this._logHandler);
                }
                if ((connectors = this._server.getConnectors()) == null || connectors.length == 0) {
                    SelectChannelConnector connector = new SelectChannelConnector();
                    connector.setPort(port);
                    this._server.addConnector(connector);
                    if (this._enableStatsGathering) {
                        connector.setStatsOn(true);
                    }
                } else if (this._enableStatsGathering) {
                    for (int j = 0; j < connectors.length; ++j) {
                        connectors[j].setStatsOn(true);
                    }
                }
                runnerServerInitialized = true;
            }
            if (!(ctx = org.eclipse.jetty.util.resource.Resource.newResource(args[i])).exists()) {
                this.usage("Context '" + ctx + "' does not exist");
            }
            if (!ctx.isDirectory() && ctx.toString().toLowerCase().endsWith(".xml")) {
                XmlConfiguration xmlConfiguration = new XmlConfiguration(ctx.getURL());
                HashMap<String, Server> properties = new HashMap<String, Server>();
                properties.put("Server", this._server);
                xmlConfiguration.setProperties(properties);
                ContextHandler handler = (ContextHandler)xmlConfiguration.configure();
                this._contexts.addHandler(handler);
                if (!contextPathSet) continue;
                handler.setContextPath(contextPath);
                continue;
            }
            if (contextPathSet && !contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            Log.info("Deploying " + ctx.toString() + " @ " + contextPath);
            WebAppContext webapp = new WebAppContext((HandlerContainer)this._contexts, ctx.toString(), contextPath);
            webapp.setConfigurationClasses(__plusConfigurationClasses);
            System.err.println(Arrays.asList(this._contexts.getHandlers()));
        }
        if (this._server == null) {
            this.usage("No Contexts defined");
        }
        this._server.setStopAtShutdown(true);
        this._server.setSendServerVersion(true);
        if (this._logFile != null) {
            NCSARequestLog requestLog = new NCSARequestLog(this._logFile);
            requestLog.setExtended(false);
            this._logHandler.setRequestLog(requestLog);
        }
    }

    protected int configJDBC(String[] args, int i) throws Exception {
        String jdbcClass = null;
        String jdbcProperties = null;
        String jdbcJndiName = null;
        if (!this._isTxServiceAvailable) {
            Log.warn("JDBC TX support not found on classpath");
            i += 3;
        } else {
            jdbcClass = args[++i];
            jdbcProperties = args[++i];
            jdbcJndiName = args[++i];
            if (jdbcClass != null) {
                if (this.isXADataSource(jdbcClass)) {
                    Class<?> simpleDataSourceBeanClass = Thread.currentThread().getContextClassLoader().loadClass("com.atomikos.jdbc.SimpleDataSourceBean");
                    Object o = simpleDataSourceBeanClass.newInstance();
                    simpleDataSourceBeanClass.getMethod("setXaDataSourceClassName", String.class).invoke(o, jdbcClass);
                    simpleDataSourceBeanClass.getMethod("setXaDataSourceProperties", String.class).invoke(o, jdbcProperties);
                    simpleDataSourceBeanClass.getMethod("setUniqueResourceName", String.class).invoke(o, jdbcJndiName);
                    Resource jdbcResource = new Resource(jdbcJndiName, o);
                } else {
                    String[] props = jdbcProperties.split(";");
                    String user = null;
                    String password = null;
                    String url = null;
                    for (int j = 0; props != null && j < props.length; ++j) {
                        String[] pair = props[j].split("=");
                        if (pair != null && pair[0].equalsIgnoreCase("user")) {
                            user = pair[1];
                            continue;
                        }
                        if (pair != null && pair[0].equalsIgnoreCase("password")) {
                            password = pair[1];
                            continue;
                        }
                        if (pair == null || !pair[0].equalsIgnoreCase("url")) continue;
                        url = pair[1];
                    }
                    Class<?> nonXADataSourceBeanClass = Thread.currentThread().getContextClassLoader().loadClass("com.atomikos.jdbc.nonxa.NonXADataSourceBean");
                    Object o = nonXADataSourceBeanClass.newInstance();
                    nonXADataSourceBeanClass.getMethod("setDriverClassName", String.class).invoke(o, jdbcClass);
                    nonXADataSourceBeanClass.getMethod("setUniqueResourceName", String.class).invoke(o, jdbcJndiName);
                    nonXADataSourceBeanClass.getMethod("setUrl", String.class).invoke(o, url);
                    nonXADataSourceBeanClass.getMethod("setUser", String.class).invoke(o, user);
                    nonXADataSourceBeanClass.getMethod("setPassword", String.class).invoke(o, password);
                    Resource jdbcResource = new Resource(jdbcJndiName, o);
                }
            }
        }
        return i;
    }

    public void run() throws Exception {
        this._server.start();
        this._server.join();
    }

    protected void expandJars(org.eclipse.jetty.util.resource.Resource lib) throws IOException {
        String[] list = lib.list();
        if (list == null) {
            return;
        }
        for (String path : list) {
            if (".".equals(path) || "..".equals(path)) continue;
            org.eclipse.jetty.util.resource.Resource item = lib.addPath(path);
            if (item.isDirectory()) {
                this.expandJars(item);
                continue;
            }
            if (!path.toLowerCase().endsWith(".jar") && !path.toLowerCase().endsWith(".zip")) continue;
            URL url = item.getURL();
            this._classpath.add(url);
        }
    }

    protected void initClassLoader() {
        if (this._classLoader == null && this._classpath != null && this._classpath.size() > 0) {
            ClassLoader context = Thread.currentThread().getContextClassLoader();
            this._classLoader = context == null ? new URLClassLoader(this._classpath.toArray(new URL[this._classpath.size()])) : new URLClassLoader(this._classpath.toArray(new URL[this._classpath.size()]), context);
            Thread.currentThread().setContextClassLoader(this._classLoader);
        }
    }

    protected boolean isXADataSource(String classname) throws Exception {
        boolean isXA = false;
        for (Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(classname); !isXA && clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; interfaces != null && !isXA && i < interfaces.length; ++i) {
                if (!interfaces[i].getCanonicalName().equals("javax.sql.XADataSource")) continue;
                isXA = true;
            }
        }
        Log.debug(isXA ? "XA" : "!XA");
        return isXA;
    }

    private void processTransactionManagement() throws Exception {
        if (!this._isTxServiceAvailable) {
            Log.warn("No tx manager found");
        } else {
            this._utId = Integer.toHexString(this._random.nextInt());
            if (this._txMgrPropertiesFile == null) {
                System.setProperty("com.atomikos.icatch.no_file", "true");
                System.setProperty("com.atomikos.icatch.service", "com.atomikos.icatch.standalone.UserTransactionServiceFactory");
            } else {
                System.setProperty("com.atomikos.icatch.file", this._txMgrPropertiesFile);
            }
            Properties txprops = new Properties();
            if (this._txMgrPropertiesFile == null) {
                File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                tmpDir = new File(tmpDir, this._utId);
                tmpDir.mkdir();
                Log.debug("Made " + tmpDir.getAbsolutePath());
                txprops.put("com.atomikos.icatch.service", "com.atomikos.icatch.standalone.UserTransactionServiceFactory");
                Class<?> infoClass = Thread.currentThread().getContextClassLoader().loadClass("com.atomikos.icatch.config.TSInitInfo");
                txprops.put(infoClass.getField("LOG_BASE_DIR_PROPERTY_NAME").get(null).toString(), tmpDir.getCanonicalPath());
                txprops.put(infoClass.getField("CONSOLE_FILE_NAME_PROPERTY_NAME").get(null).toString(), "tm-debug.log");
                txprops.put(infoClass.getField("OUTPUT_DIR_PROPERTY_NAME").get(null).toString(), "tm-tx-log");
                txprops.put(infoClass.getField("OUTPUT_DIR_PROPERTY_NAME").get(null).toString(), tmpDir.getCanonicalPath());
                txprops.put(infoClass.getField("TM_UNIQUE_NAME_PROPERTY_NAME").get(null).toString(), this._utId);
            } else {
                txprops.load(new FileInputStream(this._txMgrPropertiesFile));
            }
            Class<?> utsClass = Thread.currentThread().getContextClassLoader().loadClass("com.atomikos.icatch.config.UserTransactionServiceImp");
            Class<?> tsInitInfoClass = Thread.currentThread().getContextClassLoader().loadClass("com.atomikos.icatch.config.TSInitInfo");
            Object uts = utsClass.getConstructor(Properties.class).newInstance(txprops);
            Object tsInfo = utsClass.getMethod("createTSInitInfo", new Class[0]).invoke(uts, new Object[0]);
            utsClass.getMethod("init", tsInitInfoClass).invoke(uts, tsInfo);
            this._ut = (UserTransaction)utsClass.getMethod("getUserTransaction", new Class[0]).invoke(uts, new Object[0]);
            Transaction txMgrResource = new Transaction(this._ut);
        }
    }

    public static void main(String[] args) {
        Runner runner = new Runner();
        try {
            if (args.length > 0 && args[0].equalsIgnoreCase("--help")) {
                runner.usage(null);
            } else if (args.length > 0 && args[0].equalsIgnoreCase("--version")) {
                System.err.println("org.mortbay.jetty.Runner: " + Server.getVersion());
                System.exit(1);
            }
            runner.configure(args);
            runner.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            runner.usage(null);
        }
    }
}

