/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.Gem;

public abstract class RepeatableAnnotations<SINGULAR extends Gem, MULTIPLE extends Gem, OPTIONS> {
    private static final String JAVA_LANG_ANNOTATION_PGK = "java.lang.annotation";
    private static final String ORG_MAPSTRUCT_PKG = "org.mapstruct";
    private ElementUtils elementUtils;
    private final String singularFqn;
    private final String multipleFqn;

    protected RepeatableAnnotations(ElementUtils elementUtils, String singularFqn, String multipleFqn) {
        this.elementUtils = elementUtils;
        this.singularFqn = singularFqn;
        this.multipleFqn = multipleFqn;
    }

    protected abstract SINGULAR singularInstanceOn(Element var1);

    protected abstract MULTIPLE multipleInstanceOn(Element var1);

    protected abstract void addInstance(SINGULAR var1, Element var2, Set<OPTIONS> var3);

    protected abstract void addInstances(MULTIPLE var1, Element var2, Set<OPTIONS> var3);

    public Set<OPTIONS> getProcessedAnnotations(Element source) {
        return this.getMappings(source, source, new LinkedHashSet(), new HashSet<Element>());
    }

    private Set<OPTIONS> getMappings(Element source, Element element, LinkedHashSet<OPTIONS> mappingOptions, Set<Element> handledElements) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Element lElement = annotationMirror.getAnnotationType().asElement();
            if (this.isAnnotation(lElement, this.singularFqn)) {
                SINGULAR mapping = this.singularInstanceOn(element);
                this.addInstance(mapping, source, mappingOptions);
                continue;
            }
            if (this.isAnnotation(lElement, this.multipleFqn)) {
                MULTIPLE mappings = this.multipleInstanceOn(element);
                this.addInstances(mappings, source, mappingOptions);
                continue;
            }
            if (this.isAnnotationInPackage(lElement, JAVA_LANG_ANNOTATION_PGK) || this.isAnnotationInPackage(lElement, ORG_MAPSTRUCT_PKG) || handledElements.contains(lElement)) continue;
            handledElements.add(lElement);
            this.getMappings(source, lElement, mappingOptions, handledElements);
        }
        return mappingOptions;
    }

    private boolean isAnnotationInPackage(Element element, String packageFQN) {
        if (ElementKind.ANNOTATION_TYPE == element.getKind()) {
            return packageFQN.equals(this.elementUtils.getPackageOf(element).getQualifiedName().toString());
        }
        return false;
    }

    private boolean isAnnotation(Element element, String annotationFQN) {
        if (ElementKind.ANNOTATION_TYPE == element.getKind()) {
            return annotationFQN.equals(((TypeElement)element).getQualifiedName().toString());
        }
        return false;
    }
}

