/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.util.Iterator;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;
import org.hibernate.cfg.Configuration;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;

public class SequenceSnapshotGenerator
extends HibernateSnapshotGenerator {
    public SequenceSnapshotGenerator() {
        super(Sequence.class, new Class[]{Schema.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Sequence.class)) {
            return;
        }
        if (foundObject instanceof Schema) {
            Schema schema = (Schema)foundObject;
            HibernateDatabase database = (HibernateDatabase)snapshot.getDatabase();
            Configuration cfg = database.getConfiguration();
            Iterator classMappings = cfg.getClassMappings();
            while (classMappings.hasNext()) {
                SequenceGenerator sequenceGenerator;
                PersistentClass persistentClass = (PersistentClass)classMappings.next();
                if (persistentClass.isInherited()) continue;
                IdentifierGenerator ig = persistentClass.getIdentifier().createIdentifierGenerator((IdentifierGeneratorFactory)cfg.getIdentifierGeneratorFactory(), database.getDialect(), null, null, (RootClass)persistentClass);
                if (ig instanceof SequenceGenerator) {
                    sequenceGenerator = (SequenceGenerator)ig;
                    this.createSequence(sequenceGenerator.getSequenceName(), schema);
                    continue;
                }
                if (!(ig instanceof SequenceStyleGenerator)) continue;
                sequenceGenerator = (SequenceStyleGenerator)ig;
                this.createSequence((String)sequenceGenerator.generatorKey(), schema);
            }
        }
    }

    private void createSequence(String sequenceName, Schema schema) {
        Sequence sequence = new Sequence();
        sequence.setName(sequenceName);
        sequence.setSchema(schema);
        schema.addDatabaseObject((DatabaseObject)sequence);
    }
}

