/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2022 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.remixicon;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum RemixiconAL implements Ikon {
    ACCOUNT_BOX_FILL("remixal-account-box-fill", '\uea06'),
    ACCOUNT_BOX_LINE("remixal-account-box-line", '\uea07'),
    ACCOUNT_CIRCLE_FILL("remixal-account-circle-fill", '\uea08'),
    ACCOUNT_CIRCLE_LINE("remixal-account-circle-line", '\uea09'),
    ACCOUNT_PIN_BOX_FILL("remixal-account-pin-box-fill", '\uea0a'),
    ACCOUNT_PIN_BOX_LINE("remixal-account-pin-box-line", '\uea0b'),
    ACCOUNT_PIN_CIRCLE_FILL("remixal-account-pin-circle-fill", '\uea0c'),
    ACCOUNT_PIN_CIRCLE_LINE("remixal-account-pin-circle-line", '\uea0d'),
    ADD_BOX_FILL("remixal-add-box-fill", '\uea0e'),
    ADD_BOX_LINE("remixal-add-box-line", '\uea0f'),
    ADD_CIRCLE_FILL("remixal-add-circle-fill", '\uea10'),
    ADD_CIRCLE_LINE("remixal-add-circle-line", '\uea11'),
    ADD_FILL("remixal-add-fill", '\uea12'),
    ADD_LINE("remixal-add-line", '\uea13'),
    ADMIN_FILL("remixal-admin-fill", '\uea14'),
    ADMIN_LINE("remixal-admin-line", '\uea15'),
    ADVERTISEMENT_FILL("remixal-advertisement-fill", '\uea16'),
    ADVERTISEMENT_LINE("remixal-advertisement-line", '\uea17'),
    AIRPLAY_FILL("remixal-airplay-fill", '\uea18'),
    AIRPLAY_LINE("remixal-airplay-line", '\uea19'),
    ALARM_FILL("remixal-alarm-fill", '\uea1a'),
    ALARM_LINE("remixal-alarm-line", '\uea1b'),
    ALARM_WARNING_FILL("remixal-alarm-warning-fill", '\uea1c'),
    ALARM_WARNING_LINE("remixal-alarm-warning-line", '\uea1d'),
    ALBUM_FILL("remixal-album-fill", '\uea1e'),
    ALBUM_LINE("remixal-album-line", '\uea1f'),
    ALERT_FILL("remixal-alert-fill", '\uea20'),
    ALERT_LINE("remixal-alert-line", '\uea21'),
    ALIENS_FILL("remixal-aliens-fill", '\uea22'),
    ALIENS_LINE("remixal-aliens-line", '\uea23'),
    ALIGN_BOTTOM("remixal-align-bottom", '\uea24'),
    ALIGN_CENTER("remixal-align-center", '\uea25'),
    ALIGN_JUSTIFY("remixal-align-justify", '\uea26'),
    ALIGN_LEFT("remixal-align-left", '\uea27'),
    ALIGN_RIGHT("remixal-align-right", '\uea28'),
    ALIGN_TOP("remixal-align-top", '\uea29'),
    ALIGN_VERTICALLY("remixal-align-vertically", '\uea2a'),
    ALIPAY_FILL("remixal-alipay-fill", '\uea2b'),
    ALIPAY_LINE("remixal-alipay-line", '\uea2c'),
    AMAZON_FILL("remixal-amazon-fill", '\uea2d'),
    AMAZON_LINE("remixal-amazon-line", '\uea2e'),
    ANCHOR_FILL("remixal-anchor-fill", '\uea2f'),
    ANCHOR_LINE("remixal-anchor-line", '\uea30'),
    ANCIENT_GATE_FILL("remixal-ancient-gate-fill", '\uea31'),
    ANCIENT_GATE_LINE("remixal-ancient-gate-line", '\uea32'),
    ANCIENT_PAVILION_FILL("remixal-ancient-pavilion-fill", '\uea33'),
    ANCIENT_PAVILION_LINE("remixal-ancient-pavilion-line", '\uea34'),
    ANDROID_FILL("remixal-android-fill", '\uea35'),
    ANDROID_LINE("remixal-android-line", '\uea36'),
    ANGULARJS_FILL("remixal-angularjs-fill", '\uea37'),
    ANGULARJS_LINE("remixal-angularjs-line", '\uea38'),
    ANTICLOCKWISE_2_FILL("remixal-anticlockwise-2-fill", '\uea39'),
    ANTICLOCKWISE_2_LINE("remixal-anticlockwise-2-line", '\uea3a'),
    ANTICLOCKWISE_FILL("remixal-anticlockwise-fill", '\uea3b'),
    ANTICLOCKWISE_LINE("remixal-anticlockwise-line", '\uea3c'),
    APPLE_FILL("remixal-apple-fill", '\uea3f'),
    APPLE_LINE("remixal-apple-line", '\uea40'),
    APPS_2_FILL("remixal-apps-2-fill", '\uea41'),
    APPS_2_LINE("remixal-apps-2-line", '\uea42'),
    APPS_FILL("remixal-apps-fill", '\uea43'),
    APPS_LINE("remixal-apps-line", '\uea44'),
    APP_STORE_FILL("remixal-app-store-fill", '\uea3d'),
    APP_STORE_LINE("remixal-app-store-line", '\uea3e'),
    ARCHIVE_DRAWER_FILL("remixal-archive-drawer-fill", '\uea45'),
    ARCHIVE_DRAWER_LINE("remixal-archive-drawer-line", '\uea46'),
    ARCHIVE_FILL("remixal-archive-fill", '\uea47'),
    ARCHIVE_LINE("remixal-archive-line", '\uea48'),
    ARROW_DOWN_CIRCLE_FILL("remixal-arrow-down-circle-fill", '\uea49'),
    ARROW_DOWN_CIRCLE_LINE("remixal-arrow-down-circle-line", '\uea4a'),
    ARROW_DOWN_FILL("remixal-arrow-down-fill", '\uea4b'),
    ARROW_DOWN_LINE("remixal-arrow-down-line", '\uea4c'),
    ARROW_DOWN_S_FILL("remixal-arrow-down-s-fill", '\uea4d'),
    ARROW_DOWN_S_LINE("remixal-arrow-down-s-line", '\uea4e'),
    ARROW_DROP_DOWN_FILL("remixal-arrow-drop-down-fill", '\uea4f'),
    ARROW_DROP_DOWN_LINE("remixal-arrow-drop-down-line", '\uea50'),
    ARROW_DROP_LEFT_FILL("remixal-arrow-drop-left-fill", '\uea51'),
    ARROW_DROP_LEFT_LINE("remixal-arrow-drop-left-line", '\uea52'),
    ARROW_DROP_RIGHT_FILL("remixal-arrow-drop-right-fill", '\uea53'),
    ARROW_DROP_RIGHT_LINE("remixal-arrow-drop-right-line", '\uea54'),
    ARROW_DROP_UP_FILL("remixal-arrow-drop-up-fill", '\uea55'),
    ARROW_DROP_UP_LINE("remixal-arrow-drop-up-line", '\uea56'),
    ARROW_GO_BACK_FILL("remixal-arrow-go-back-fill", '\uea57'),
    ARROW_GO_BACK_LINE("remixal-arrow-go-back-line", '\uea58'),
    ARROW_GO_FORWARD_FILL("remixal-arrow-go-forward-fill", '\uea59'),
    ARROW_GO_FORWARD_LINE("remixal-arrow-go-forward-line", '\uea5a'),
    ARROW_LEFT_CIRCLE_FILL("remixal-arrow-left-circle-fill", '\uea5b'),
    ARROW_LEFT_CIRCLE_LINE("remixal-arrow-left-circle-line", '\uea5c'),
    ARROW_LEFT_DOWN_FILL("remixal-arrow-left-down-fill", '\uea5d'),
    ARROW_LEFT_DOWN_LINE("remixal-arrow-left-down-line", '\uea5e'),
    ARROW_LEFT_FILL("remixal-arrow-left-fill", '\uea5f'),
    ARROW_LEFT_LINE("remixal-arrow-left-line", '\uea60'),
    ARROW_LEFT_RIGHT_FILL("remixal-arrow-left-right-fill", '\uea61'),
    ARROW_LEFT_RIGHT_LINE("remixal-arrow-left-right-line", '\uea62'),
    ARROW_LEFT_S_FILL("remixal-arrow-left-s-fill", '\uea63'),
    ARROW_LEFT_S_LINE("remixal-arrow-left-s-line", '\uea64'),
    ARROW_LEFT_UP_FILL("remixal-arrow-left-up-fill", '\uea65'),
    ARROW_LEFT_UP_LINE("remixal-arrow-left-up-line", '\uea66'),
    ARROW_RIGHT_CIRCLE_FILL("remixal-arrow-right-circle-fill", '\uea67'),
    ARROW_RIGHT_CIRCLE_LINE("remixal-arrow-right-circle-line", '\uea68'),
    ARROW_RIGHT_DOWN_FILL("remixal-arrow-right-down-fill", '\uea69'),
    ARROW_RIGHT_DOWN_LINE("remixal-arrow-right-down-line", '\uea6a'),
    ARROW_RIGHT_FILL("remixal-arrow-right-fill", '\uea6b'),
    ARROW_RIGHT_LINE("remixal-arrow-right-line", '\uea6c'),
    ARROW_RIGHT_S_FILL("remixal-arrow-right-s-fill", '\uea6d'),
    ARROW_RIGHT_S_LINE("remixal-arrow-right-s-line", '\uea6e'),
    ARROW_RIGHT_UP_FILL("remixal-arrow-right-up-fill", '\uea6f'),
    ARROW_RIGHT_UP_LINE("remixal-arrow-right-up-line", '\uea70'),
    ARROW_UP_CIRCLE_FILL("remixal-arrow-up-circle-fill", '\uea71'),
    ARROW_UP_CIRCLE_LINE("remixal-arrow-up-circle-line", '\uea72'),
    ARROW_UP_DOWN_FILL("remixal-arrow-up-down-fill", '\uea73'),
    ARROW_UP_DOWN_LINE("remixal-arrow-up-down-line", '\uea74'),
    ARROW_UP_FILL("remixal-arrow-up-fill", '\uea75'),
    ARROW_UP_LINE("remixal-arrow-up-line", '\uea76'),
    ARROW_UP_S_FILL("remixal-arrow-up-s-fill", '\uea77'),
    ARROW_UP_S_LINE("remixal-arrow-up-s-line", '\uea78'),
    ARTBOARD_2_FILL("remixal-artboard-2-fill", '\uea79'),
    ARTBOARD_2_LINE("remixal-artboard-2-line", '\uea7a'),
    ARTBOARD_FILL("remixal-artboard-fill", '\uea7b'),
    ARTBOARD_LINE("remixal-artboard-line", '\uea7c'),
    ARTICLE_FILL("remixal-article-fill", '\uea7d'),
    ARTICLE_LINE("remixal-article-line", '\uea7e'),
    ASPECT_RATIO_FILL("remixal-aspect-ratio-fill", '\uea7f'),
    ASPECT_RATIO_LINE("remixal-aspect-ratio-line", '\uea80'),
    ASTERISK("remixal-asterisk", '\uea81'),
    ATTACHMENT_2("remixal-attachment-2", '\uea84'),
    ATTACHMENT_FILL("remixal-attachment-fill", '\uea85'),
    ATTACHMENT_LINE("remixal-attachment-line", '\uea86'),
    AT_FILL("remixal-at-fill", '\uea82'),
    AT_LINE("remixal-at-line", '\uea83'),
    AUCTION_FILL("remixal-auction-fill", '\uea87'),
    AUCTION_LINE("remixal-auction-line", '\uea88'),
    AWARD_FILL("remixal-award-fill", '\uea89'),
    AWARD_LINE("remixal-award-line", '\uea8a'),
    A_B("remixal-a-b", '\uea05'),
    BAIDU_FILL("remixal-baidu-fill", '\uea8b'),
    BAIDU_LINE("remixal-baidu-line", '\uea8c'),
    BALL_PEN_FILL("remixal-ball-pen-fill", '\uea8d'),
    BALL_PEN_LINE("remixal-ball-pen-line", '\uea8e'),
    BANK_CARD_2_FILL("remixal-bank-card-2-fill", '\uea8f'),
    BANK_CARD_2_LINE("remixal-bank-card-2-line", '\uea90'),
    BANK_CARD_FILL("remixal-bank-card-fill", '\uea91'),
    BANK_CARD_LINE("remixal-bank-card-line", '\uea92'),
    BANK_FILL("remixal-bank-fill", '\uea93'),
    BANK_LINE("remixal-bank-line", '\uea94'),
    BARCODE_BOX_FILL("remixal-barcode-box-fill", '\uea9f'),
    BARCODE_BOX_LINE("remixal-barcode-box-line", '\ueaa0'),
    BARCODE_FILL("remixal-barcode-fill", '\ueaa1'),
    BARCODE_LINE("remixal-barcode-line", '\ueaa2'),
    BARRICADE_FILL("remixal-barricade-fill", '\ueaa3'),
    BARRICADE_LINE("remixal-barricade-line", '\ueaa4'),
    BAR_CHART_2_FILL("remixal-bar-chart-2-fill", '\uea95'),
    BAR_CHART_2_LINE("remixal-bar-chart-2-line", '\uea96'),
    BAR_CHART_BOX_FILL("remixal-bar-chart-box-fill", '\uea97'),
    BAR_CHART_BOX_LINE("remixal-bar-chart-box-line", '\uea98'),
    BAR_CHART_FILL("remixal-bar-chart-fill", '\uea99'),
    BAR_CHART_GROUPED_FILL("remixal-bar-chart-grouped-fill", '\uea9a'),
    BAR_CHART_GROUPED_LINE("remixal-bar-chart-grouped-line", '\uea9b'),
    BAR_CHART_HORIZONTAL_FILL("remixal-bar-chart-horizontal-fill", '\uea9c'),
    BAR_CHART_HORIZONTAL_LINE("remixal-bar-chart-horizontal-line", '\uea9d'),
    BAR_CHART_LINE("remixal-bar-chart-line", '\uea9e'),
    BASE_STATION_FILL("remixal-base-station-fill", '\ueaa5'),
    BASE_STATION_LINE("remixal-base-station-line", '\ueaa6'),
    BASKETBALL_FILL("remixal-basketball-fill", '\ueaa7'),
    BASKETBALL_LINE("remixal-basketball-line", '\ueaa8'),
    BATTERY_2_CHARGE_FILL("remixal-battery-2-charge-fill", '\ueaa9'),
    BATTERY_2_CHARGE_LINE("remixal-battery-2-charge-line", '\ueaaa'),
    BATTERY_2_FILL("remixal-battery-2-fill", '\ueaab'),
    BATTERY_2_LINE("remixal-battery-2-line", '\ueaac'),
    BATTERY_CHARGE_FILL("remixal-battery-charge-fill", '\ueaad'),
    BATTERY_CHARGE_LINE("remixal-battery-charge-line", '\ueaae'),
    BATTERY_FILL("remixal-battery-fill", '\ueaaf'),
    BATTERY_LINE("remixal-battery-line", '\ueab0'),
    BATTERY_LOW_FILL("remixal-battery-low-fill", '\ueab1'),
    BATTERY_LOW_LINE("remixal-battery-low-line", '\ueab2'),
    BATTERY_SAVER_FILL("remixal-battery-saver-fill", '\ueab3'),
    BATTERY_SAVER_LINE("remixal-battery-saver-line", '\ueab4'),
    BATTERY_SHARE_FILL("remixal-battery-share-fill", '\ueab5'),
    BATTERY_SHARE_LINE("remixal-battery-share-line", '\ueab6'),
    BEAR_SMILE_FILL("remixal-bear-smile-fill", '\ueab7'),
    BEAR_SMILE_LINE("remixal-bear-smile-line", '\ueab8'),
    BEHANCE_FILL("remixal-behance-fill", '\ueab9'),
    BEHANCE_LINE("remixal-behance-line", '\ueaba'),
    BELL_FILL("remixal-bell-fill", '\ueabb'),
    BELL_LINE("remixal-bell-line", '\ueabc'),
    BIKE_FILL("remixal-bike-fill", '\ueabd'),
    BIKE_LINE("remixal-bike-line", '\ueabe'),
    BILIBILI_FILL("remixal-bilibili-fill", '\ueabf'),
    BILIBILI_LINE("remixal-bilibili-line", '\ueac0'),
    BILLIARDS_FILL("remixal-billiards-fill", '\ueac3'),
    BILLIARDS_LINE("remixal-billiards-line", '\ueac4'),
    BILL_FILL("remixal-bill-fill", '\ueac1'),
    BILL_LINE("remixal-bill-line", '\ueac2'),
    BIT_COIN_FILL("remixal-bit-coin-fill", '\ueac5'),
    BIT_COIN_LINE("remixal-bit-coin-line", '\ueac6'),
    BLAZE_FILL("remixal-blaze-fill", '\ueac7'),
    BLAZE_LINE("remixal-blaze-line", '\ueac8'),
    BLUETOOTH_CONNECT_FILL("remixal-bluetooth-connect-fill", '\ueac9'),
    BLUETOOTH_CONNECT_LINE("remixal-bluetooth-connect-line", '\ueaca'),
    BLUETOOTH_FILL("remixal-bluetooth-fill", '\ueacb'),
    BLUETOOTH_LINE("remixal-bluetooth-line", '\ueacc'),
    BLUR_OFF_FILL("remixal-blur-off-fill", '\ueacd'),
    BLUR_OFF_LINE("remixal-blur-off-line", '\ueace'),
    BODY_SCAN_FILL("remixal-body-scan-fill", '\ueacf'),
    BODY_SCAN_LINE("remixal-body-scan-line", '\uead0'),
    BOLD("remixal-bold", '\uead1'),
    BOOKLET_FILL("remixal-booklet-fill", '\ueade'),
    BOOKLET_LINE("remixal-booklet-line", '\ueadf'),
    BOOKMARK_2_FILL("remixal-bookmark-2-fill", '\ueae0'),
    BOOKMARK_2_LINE("remixal-bookmark-2-line", '\ueae1'),
    BOOKMARK_3_FILL("remixal-bookmark-3-fill", '\ueae2'),
    BOOKMARK_3_LINE("remixal-bookmark-3-line", '\ueae3'),
    BOOKMARK_FILL("remixal-bookmark-fill", '\ueae4'),
    BOOKMARK_LINE("remixal-bookmark-line", '\ueae5'),
    BOOK_2_FILL("remixal-book-2-fill", '\uead2'),
    BOOK_2_LINE("remixal-book-2-line", '\uead3'),
    BOOK_3_FILL("remixal-book-3-fill", '\uead4'),
    BOOK_3_LINE("remixal-book-3-line", '\uead5'),
    BOOK_FILL("remixal-book-fill", '\uead6'),
    BOOK_LINE("remixal-book-line", '\uead7'),
    BOOK_MARK_FILL("remixal-book-mark-fill", '\uead8'),
    BOOK_MARK_LINE("remixal-book-mark-line", '\uead9'),
    BOOK_OPEN_FILL("remixal-book-open-fill", '\ueada'),
    BOOK_OPEN_LINE("remixal-book-open-line", '\ueadb'),
    BOOK_READ_FILL("remixal-book-read-fill", '\ueadc'),
    BOOK_READ_LINE("remixal-book-read-line", '\ueadd'),
    BOXING_FILL("remixal-boxing-fill", '\ueae6'),
    BOXING_LINE("remixal-boxing-line", '\ueae7'),
    BRACES_FILL("remixal-braces-fill", '\ueae8'),
    BRACES_LINE("remixal-braces-line", '\ueae9'),
    BRACKETS_FILL("remixal-brackets-fill", '\ueaea'),
    BRACKETS_LINE("remixal-brackets-line", '\ueaeb'),
    BRIEFCASE_2_FILL("remixal-briefcase-2-fill", '\ueaec'),
    BRIEFCASE_2_LINE("remixal-briefcase-2-line", '\ueaed'),
    BRIEFCASE_3_FILL("remixal-briefcase-3-fill", '\ueaee'),
    BRIEFCASE_3_LINE("remixal-briefcase-3-line", '\ueaef'),
    BRIEFCASE_4_FILL("remixal-briefcase-4-fill", '\ueaf0'),
    BRIEFCASE_4_LINE("remixal-briefcase-4-line", '\ueaf1'),
    BRIEFCASE_5_FILL("remixal-briefcase-5-fill", '\ueaf2'),
    BRIEFCASE_5_LINE("remixal-briefcase-5-line", '\ueaf3'),
    BRIEFCASE_FILL("remixal-briefcase-fill", '\ueaf4'),
    BRIEFCASE_LINE("remixal-briefcase-line", '\ueaf5'),
    BRING_FORWARD("remixal-bring-forward", '\ueaf6'),
    BRING_TO_FRONT("remixal-bring-to-front", '\ueaf7'),
    BROADCAST_FILL("remixal-broadcast-fill", '\ueaf8'),
    BROADCAST_LINE("remixal-broadcast-line", '\ueaf9'),
    BRUSH_2_FILL("remixal-brush-2-fill", '\ueafa'),
    BRUSH_2_LINE("remixal-brush-2-line", '\ueafb'),
    BRUSH_3_FILL("remixal-brush-3-fill", '\ueafc'),
    BRUSH_3_LINE("remixal-brush-3-line", '\ueafd'),
    BRUSH_4_FILL("remixal-brush-4-fill", '\ueafe'),
    BRUSH_4_LINE("remixal-brush-4-line", '\ueaff'),
    BRUSH_FILL("remixal-brush-fill", '\ueb00'),
    BRUSH_LINE("remixal-brush-line", '\ueb01'),
    BUBBLE_CHART_FILL("remixal-bubble-chart-fill", '\ueb02'),
    BUBBLE_CHART_LINE("remixal-bubble-chart-line", '\ueb03'),
    BUG_2_FILL("remixal-bug-2-fill", '\ueb04'),
    BUG_2_LINE("remixal-bug-2-line", '\ueb05'),
    BUG_FILL("remixal-bug-fill", '\ueb06'),
    BUG_LINE("remixal-bug-line", '\ueb07'),
    BUILDING_2_FILL("remixal-building-2-fill", '\ueb08'),
    BUILDING_2_LINE("remixal-building-2-line", '\ueb09'),
    BUILDING_3_FILL("remixal-building-3-fill", '\ueb0a'),
    BUILDING_3_LINE("remixal-building-3-line", '\ueb0b'),
    BUILDING_4_FILL("remixal-building-4-fill", '\ueb0c'),
    BUILDING_4_LINE("remixal-building-4-line", '\ueb0d'),
    BUILDING_FILL("remixal-building-fill", '\ueb0e'),
    BUILDING_LINE("remixal-building-line", '\ueb0f'),
    BUS_2_FILL("remixal-bus-2-fill", '\ueb10'),
    BUS_2_LINE("remixal-bus-2-line", '\ueb11'),
    BUS_FILL("remixal-bus-fill", '\ueb12'),
    BUS_LINE("remixal-bus-line", '\ueb13'),
    BUS_WIFI_FILL("remixal-bus-wifi-fill", '\ueb14'),
    BUS_WIFI_LINE("remixal-bus-wifi-line", '\ueb15'),
    CACTUS_FILL("remixal-cactus-fill", '\ueb16'),
    CACTUS_LINE("remixal-cactus-line", '\ueb17'),
    CAKE_2_FILL("remixal-cake-2-fill", '\ueb18'),
    CAKE_2_LINE("remixal-cake-2-line", '\ueb19'),
    CAKE_3_FILL("remixal-cake-3-fill", '\ueb1a'),
    CAKE_3_LINE("remixal-cake-3-line", '\ueb1b'),
    CAKE_FILL("remixal-cake-fill", '\ueb1c'),
    CAKE_LINE("remixal-cake-line", '\ueb1d'),
    CALCULATOR_FILL("remixal-calculator-fill", '\ueb1e'),
    CALCULATOR_LINE("remixal-calculator-line", '\ueb1f'),
    CALENDAR_2_FILL("remixal-calendar-2-fill", '\ueb20'),
    CALENDAR_2_LINE("remixal-calendar-2-line", '\ueb21'),
    CALENDAR_CHECK_FILL("remixal-calendar-check-fill", '\ueb22'),
    CALENDAR_CHECK_LINE("remixal-calendar-check-line", '\ueb23'),
    CALENDAR_EVENT_FILL("remixal-calendar-event-fill", '\ueb24'),
    CALENDAR_EVENT_LINE("remixal-calendar-event-line", '\ueb25'),
    CALENDAR_FILL("remixal-calendar-fill", '\ueb26'),
    CALENDAR_LINE("remixal-calendar-line", '\ueb27'),
    CALENDAR_TODO_FILL("remixal-calendar-todo-fill", '\ueb28'),
    CALENDAR_TODO_LINE("remixal-calendar-todo-line", '\ueb29'),
    CAMERA_2_FILL("remixal-camera-2-fill", '\ueb2a'),
    CAMERA_2_LINE("remixal-camera-2-line", '\ueb2b'),
    CAMERA_3_FILL("remixal-camera-3-fill", '\ueb2c'),
    CAMERA_3_LINE("remixal-camera-3-line", '\ueb2d'),
    CAMERA_FILL("remixal-camera-fill", '\ueb2e'),
    CAMERA_LENS_FILL("remixal-camera-lens-fill", '\ueb2f'),
    CAMERA_LENS_LINE("remixal-camera-lens-line", '\ueb30'),
    CAMERA_LINE("remixal-camera-line", '\ueb31'),
    CAMERA_OFF_FILL("remixal-camera-off-fill", '\ueb32'),
    CAMERA_OFF_LINE("remixal-camera-off-line", '\ueb33'),
    CAMERA_SWITCH_FILL("remixal-camera-switch-fill", '\ueb34'),
    CAMERA_SWITCH_LINE("remixal-camera-switch-line", '\ueb35'),
    CAPSULE_FILL("remixal-capsule-fill", '\ueb36'),
    CAPSULE_LINE("remixal-capsule-line", '\ueb37'),
    CARAVAN_FILL("remixal-caravan-fill", '\ueb3c'),
    CARAVAN_LINE("remixal-caravan-line", '\ueb3d'),
    CAR_FILL("remixal-car-fill", '\ueb38'),
    CAR_LINE("remixal-car-line", '\ueb39'),
    CAR_WASHING_FILL("remixal-car-washing-fill", '\ueb3a'),
    CAR_WASHING_LINE("remixal-car-washing-line", '\ueb3b'),
    CAST_FILL("remixal-cast-fill", '\ueb3e'),
    CAST_LINE("remixal-cast-line", '\ueb3f'),
    CELLPHONE_FILL("remixal-cellphone-fill", '\ueb40'),
    CELLPHONE_LINE("remixal-cellphone-line", '\ueb41'),
    CELSIUS_FILL("remixal-celsius-fill", '\ueb42'),
    CELSIUS_LINE("remixal-celsius-line", '\ueb43'),
    CENTOS_FILL("remixal-centos-fill", '\ueb44'),
    CENTOS_LINE("remixal-centos-line", '\ueb45'),
    CHARACTER_RECOGNITION_FILL("remixal-character-recognition-fill", '\ueb46'),
    CHARACTER_RECOGNITION_LINE("remixal-character-recognition-line", '\ueb47'),
    CHARGING_PILE_2_FILL("remixal-charging-pile-2-fill", '\ueb48'),
    CHARGING_PILE_2_LINE("remixal-charging-pile-2-line", '\ueb49'),
    CHARGING_PILE_FILL("remixal-charging-pile-fill", '\ueb4a'),
    CHARGING_PILE_LINE("remixal-charging-pile-line", '\ueb4b'),
    CHAT_1_FILL("remixal-chat-1-fill", '\ueb4c'),
    CHAT_1_LINE("remixal-chat-1-line", '\ueb4d'),
    CHAT_2_FILL("remixal-chat-2-fill", '\ueb4e'),
    CHAT_2_LINE("remixal-chat-2-line", '\ueb4f'),
    CHAT_3_FILL("remixal-chat-3-fill", '\ueb50'),
    CHAT_3_LINE("remixal-chat-3-line", '\ueb51'),
    CHAT_4_FILL("remixal-chat-4-fill", '\ueb52'),
    CHAT_4_LINE("remixal-chat-4-line", '\ueb53'),
    CHAT_CHECK_FILL("remixal-chat-check-fill", '\ueb54'),
    CHAT_CHECK_LINE("remixal-chat-check-line", '\ueb55'),
    CHAT_DELETE_FILL("remixal-chat-delete-fill", '\ueb56'),
    CHAT_DELETE_LINE("remixal-chat-delete-line", '\ueb57'),
    CHAT_DOWNLOAD_FILL("remixal-chat-download-fill", '\ueb58'),
    CHAT_DOWNLOAD_LINE("remixal-chat-download-line", '\ueb59'),
    CHAT_FOLLOW_UP_FILL("remixal-chat-follow-up-fill", '\ueb5a'),
    CHAT_FOLLOW_UP_LINE("remixal-chat-follow-up-line", '\ueb5b'),
    CHAT_FORWARD_FILL("remixal-chat-forward-fill", '\ueb5c'),
    CHAT_FORWARD_LINE("remixal-chat-forward-line", '\ueb5d'),
    CHAT_HEART_FILL("remixal-chat-heart-fill", '\ueb5e'),
    CHAT_HEART_LINE("remixal-chat-heart-line", '\ueb5f'),
    CHAT_HISTORY_FILL("remixal-chat-history-fill", '\ueb60'),
    CHAT_HISTORY_LINE("remixal-chat-history-line", '\ueb61'),
    CHAT_NEW_FILL("remixal-chat-new-fill", '\ueb62'),
    CHAT_NEW_LINE("remixal-chat-new-line", '\ueb63'),
    CHAT_OFF_FILL("remixal-chat-off-fill", '\ueb64'),
    CHAT_OFF_LINE("remixal-chat-off-line", '\ueb65'),
    CHAT_POLL_FILL("remixal-chat-poll-fill", '\ueb66'),
    CHAT_POLL_LINE("remixal-chat-poll-line", '\ueb67'),
    CHAT_PRIVATE_FILL("remixal-chat-private-fill", '\ueb68'),
    CHAT_PRIVATE_LINE("remixal-chat-private-line", '\ueb69'),
    CHAT_QUOTE_FILL("remixal-chat-quote-fill", '\ueb6a'),
    CHAT_QUOTE_LINE("remixal-chat-quote-line", '\ueb6b'),
    CHAT_SETTINGS_FILL("remixal-chat-settings-fill", '\ueb6c'),
    CHAT_SETTINGS_LINE("remixal-chat-settings-line", '\ueb6d'),
    CHAT_SMILE_2_FILL("remixal-chat-smile-2-fill", '\ueb6e'),
    CHAT_SMILE_2_LINE("remixal-chat-smile-2-line", '\ueb6f'),
    CHAT_SMILE_3_FILL("remixal-chat-smile-3-fill", '\ueb70'),
    CHAT_SMILE_3_LINE("remixal-chat-smile-3-line", '\ueb71'),
    CHAT_SMILE_FILL("remixal-chat-smile-fill", '\ueb72'),
    CHAT_SMILE_LINE("remixal-chat-smile-line", '\ueb73'),
    CHAT_UPLOAD_FILL("remixal-chat-upload-fill", '\ueb74'),
    CHAT_UPLOAD_LINE("remixal-chat-upload-line", '\ueb75'),
    CHAT_VOICE_FILL("remixal-chat-voice-fill", '\ueb76'),
    CHAT_VOICE_LINE("remixal-chat-voice-line", '\ueb77'),
    CHECKBOX_BLANK_CIRCLE_FILL("remixal-checkbox-blank-circle-fill", '\ueb7c'),
    CHECKBOX_BLANK_CIRCLE_LINE("remixal-checkbox-blank-circle-line", '\ueb7d'),
    CHECKBOX_BLANK_FILL("remixal-checkbox-blank-fill", '\ueb7e'),
    CHECKBOX_BLANK_LINE("remixal-checkbox-blank-line", '\ueb7f'),
    CHECKBOX_CIRCLE_FILL("remixal-checkbox-circle-fill", '\ueb80'),
    CHECKBOX_CIRCLE_LINE("remixal-checkbox-circle-line", '\ueb81'),
    CHECKBOX_FILL("remixal-checkbox-fill", '\ueb82'),
    CHECKBOX_INDETERMINATE_FILL("remixal-checkbox-indeterminate-fill", '\ueb83'),
    CHECKBOX_INDETERMINATE_LINE("remixal-checkbox-indeterminate-line", '\ueb84'),
    CHECKBOX_LINE("remixal-checkbox-line", '\ueb85'),
    CHECKBOX_MULTIPLE_BLANK_FILL("remixal-checkbox-multiple-blank-fill", '\ueb86'),
    CHECKBOX_MULTIPLE_BLANK_LINE("remixal-checkbox-multiple-blank-line", '\ueb87'),
    CHECKBOX_MULTIPLE_FILL("remixal-checkbox-multiple-fill", '\ueb88'),
    CHECKBOX_MULTIPLE_LINE("remixal-checkbox-multiple-line", '\ueb89'),
    CHECK_DOUBLE_FILL("remixal-check-double-fill", '\ueb78'),
    CHECK_DOUBLE_LINE("remixal-check-double-line", '\ueb79'),
    CHECK_FILL("remixal-check-fill", '\ueb7a'),
    CHECK_LINE("remixal-check-line", '\ueb7b'),
    CHINA_RAILWAY_FILL("remixal-china-railway-fill", '\ueb8a'),
    CHINA_RAILWAY_LINE("remixal-china-railway-line", '\ueb8b'),
    CHROME_FILL("remixal-chrome-fill", '\ueb8c'),
    CHROME_LINE("remixal-chrome-line", '\ueb8d'),
    CLAPPERBOARD_FILL("remixal-clapperboard-fill", '\ueb8e'),
    CLAPPERBOARD_LINE("remixal-clapperboard-line", '\ueb8f'),
    CLIPBOARD_FILL("remixal-clipboard-fill", '\ueb90'),
    CLIPBOARD_LINE("remixal-clipboard-line", '\ueb91'),
    CLOCKWISE_2_FILL("remixal-clockwise-2-fill", '\ueb92'),
    CLOCKWISE_2_LINE("remixal-clockwise-2-line", '\ueb93'),
    CLOCKWISE_FILL("remixal-clockwise-fill", '\ueb94'),
    CLOCKWISE_LINE("remixal-clockwise-line", '\ueb95'),
    CLOSED_CAPTIONING_FILL("remixal-closed-captioning-fill", '\ueb9a'),
    CLOSED_CAPTIONING_LINE("remixal-closed-captioning-line", '\ueb9b'),
    CLOSE_CIRCLE_FILL("remixal-close-circle-fill", '\ueb96'),
    CLOSE_CIRCLE_LINE("remixal-close-circle-line", '\ueb97'),
    CLOSE_FILL("remixal-close-fill", '\ueb98'),
    CLOSE_LINE("remixal-close-line", '\ueb99'),
    CLOUDY_2_FILL("remixal-cloudy-2-fill", '\ueba2'),
    CLOUDY_2_LINE("remixal-cloudy-2-line", '\ueba3'),
    CLOUDY_FILL("remixal-cloudy-fill", '\ueba4'),
    CLOUDY_LINE("remixal-cloudy-line", '\ueba5'),
    CLOUD_FILL("remixal-cloud-fill", '\ueb9c'),
    CLOUD_LINE("remixal-cloud-line", '\ueb9d'),
    CLOUD_OFF_FILL("remixal-cloud-off-fill", '\ueb9e'),
    CLOUD_OFF_LINE("remixal-cloud-off-line", '\ueb9f'),
    CLOUD_WINDY_FILL("remixal-cloud-windy-fill", '\ueba0'),
    CLOUD_WINDY_LINE("remixal-cloud-windy-line", '\ueba1'),
    CODEPEN_FILL("remixal-codepen-fill", '\uebaf'),
    CODEPEN_LINE("remixal-codepen-line", '\uebb0'),
    CODE_BOX_FILL("remixal-code-box-fill", '\ueba6'),
    CODE_BOX_LINE("remixal-code-box-line", '\ueba7'),
    CODE_FILL("remixal-code-fill", '\ueba8'),
    CODE_LINE("remixal-code-line", '\ueba9'),
    CODE_S_FILL("remixal-code-s-fill", '\uebaa'),
    CODE_S_LINE("remixal-code-s-line", '\uebab'),
    CODE_S_SLASH_FILL("remixal-code-s-slash-fill", '\uebac'),
    CODE_S_SLASH_LINE("remixal-code-s-slash-line", '\uebad'),
    CODE_VIEW("remixal-code-view", '\uebae'),
    COINS_FILL("remixal-coins-fill", '\uebb3'),
    COINS_LINE("remixal-coins-line", '\uebb4'),
    COIN_FILL("remixal-coin-fill", '\uebb1'),
    COIN_LINE("remixal-coin-line", '\uebb2'),
    COLLAGE_FILL("remixal-collage-fill", '\uebb5'),
    COLLAGE_LINE("remixal-collage-line", '\uebb6'),
    COMMAND_FILL("remixal-command-fill", '\uebb7'),
    COMMAND_LINE("remixal-command-line", '\uebb8'),
    COMMUNITY_FILL("remixal-community-fill", '\uebb9'),
    COMMUNITY_LINE("remixal-community-line", '\uebba'),
    COMPASSES_2_FILL("remixal-compasses-2-fill", '\uebc5'),
    COMPASSES_2_LINE("remixal-compasses-2-line", '\uebc6'),
    COMPASSES_FILL("remixal-compasses-fill", '\uebc7'),
    COMPASSES_LINE("remixal-compasses-line", '\uebc8'),
    COMPASS_2_FILL("remixal-compass-2-fill", '\uebbb'),
    COMPASS_2_LINE("remixal-compass-2-line", '\uebbc'),
    COMPASS_3_FILL("remixal-compass-3-fill", '\uebbd'),
    COMPASS_3_LINE("remixal-compass-3-line", '\uebbe'),
    COMPASS_4_FILL("remixal-compass-4-fill", '\uebbf'),
    COMPASS_4_LINE("remixal-compass-4-line", '\uebc0'),
    COMPASS_DISCOVER_FILL("remixal-compass-discover-fill", '\uebc1'),
    COMPASS_DISCOVER_LINE("remixal-compass-discover-line", '\uebc2'),
    COMPASS_FILL("remixal-compass-fill", '\uebc3'),
    COMPASS_LINE("remixal-compass-line", '\uebc4'),
    COMPUTER_FILL("remixal-computer-fill", '\uebc9'),
    COMPUTER_LINE("remixal-computer-line", '\uebca'),
    CONTACTS_BOOK_2_FILL("remixal-contacts-book-2-fill", '\uebcb'),
    CONTACTS_BOOK_2_LINE("remixal-contacts-book-2-line", '\uebcc'),
    CONTACTS_BOOK_FILL("remixal-contacts-book-fill", '\uebcd'),
    CONTACTS_BOOK_LINE("remixal-contacts-book-line", '\uebce'),
    CONTACTS_BOOK_UPLOAD_FILL("remixal-contacts-book-upload-fill", '\uebcf'),
    CONTACTS_BOOK_UPLOAD_LINE("remixal-contacts-book-upload-line", '\uebd0'),
    CONTACTS_FILL("remixal-contacts-fill", '\uebd1'),
    CONTACTS_LINE("remixal-contacts-line", '\uebd2'),
    CONTRAST_2_FILL("remixal-contrast-2-fill", '\uebd3'),
    CONTRAST_2_LINE("remixal-contrast-2-line", '\uebd4'),
    CONTRAST_DROP_2_FILL("remixal-contrast-drop-2-fill", '\uebd5'),
    CONTRAST_DROP_2_LINE("remixal-contrast-drop-2-line", '\uebd6'),
    CONTRAST_DROP_FILL("remixal-contrast-drop-fill", '\uebd7'),
    CONTRAST_DROP_LINE("remixal-contrast-drop-line", '\uebd8'),
    CONTRAST_FILL("remixal-contrast-fill", '\uebd9'),
    CONTRAST_LINE("remixal-contrast-line", '\uebda'),
    COPPER_COIN_FILL("remixal-copper-coin-fill", '\uebdb'),
    COPPER_COIN_LINE("remixal-copper-coin-line", '\uebdc'),
    COPPER_DIAMOND_FILL("remixal-copper-diamond-fill", '\uebdd'),
    COPPER_DIAMOND_LINE("remixal-copper-diamond-line", '\uebde'),
    COPYLEFT_FILL("remixal-copyleft-fill", '\uebdf'),
    COPYLEFT_LINE("remixal-copyleft-line", '\uebe0'),
    COPYRIGHT_FILL("remixal-copyright-fill", '\uebe1'),
    COPYRIGHT_LINE("remixal-copyright-line", '\uebe2'),
    COREOS_FILL("remixal-coreos-fill", '\uebe3'),
    COREOS_LINE("remixal-coreos-line", '\uebe4'),
    COUPON_2_FILL("remixal-coupon-2-fill", '\uebe5'),
    COUPON_2_LINE("remixal-coupon-2-line", '\uebe6'),
    COUPON_3_FILL("remixal-coupon-3-fill", '\uebe7'),
    COUPON_3_LINE("remixal-coupon-3-line", '\uebe8'),
    COUPON_4_FILL("remixal-coupon-4-fill", '\uebe9'),
    COUPON_4_LINE("remixal-coupon-4-line", '\uebea'),
    COUPON_5_FILL("remixal-coupon-5-fill", '\uebeb'),
    COUPON_5_LINE("remixal-coupon-5-line", '\uebec'),
    COUPON_FILL("remixal-coupon-fill", '\uebed'),
    COUPON_LINE("remixal-coupon-line", '\uebee'),
    CPU_FILL("remixal-cpu-fill", '\uebef'),
    CPU_LINE("remixal-cpu-line", '\uebf0'),
    CREATIVE_COMMONS_BY_FILL("remixal-creative-commons-by-fill", '\uebf1'),
    CREATIVE_COMMONS_BY_LINE("remixal-creative-commons-by-line", '\uebf2'),
    CREATIVE_COMMONS_FILL("remixal-creative-commons-fill", '\uebf3'),
    CREATIVE_COMMONS_LINE("remixal-creative-commons-line", '\uebf4'),
    CREATIVE_COMMONS_NC_FILL("remixal-creative-commons-nc-fill", '\uebf5'),
    CREATIVE_COMMONS_NC_LINE("remixal-creative-commons-nc-line", '\uebf6'),
    CREATIVE_COMMONS_ND_FILL("remixal-creative-commons-nd-fill", '\uebf7'),
    CREATIVE_COMMONS_ND_LINE("remixal-creative-commons-nd-line", '\uebf8'),
    CREATIVE_COMMONS_SA_FILL("remixal-creative-commons-sa-fill", '\uebf9'),
    CREATIVE_COMMONS_SA_LINE("remixal-creative-commons-sa-line", '\uebfa'),
    CREATIVE_COMMONS_ZERO_FILL("remixal-creative-commons-zero-fill", '\uebfb'),
    CREATIVE_COMMONS_ZERO_LINE("remixal-creative-commons-zero-line", '\uebfc'),
    CRIMINAL_FILL("remixal-criminal-fill", '\uebfd'),
    CRIMINAL_LINE("remixal-criminal-line", '\uebfe'),
    CROP_2_FILL("remixal-crop-2-fill", '\uebff'),
    CROP_2_LINE("remixal-crop-2-line", '\uec00'),
    CROP_FILL("remixal-crop-fill", '\uec01'),
    CROP_LINE("remixal-crop-line", '\uec02'),
    CSS3_FILL("remixal-css3-fill", '\uec03'),
    CSS3_LINE("remixal-css3-line", '\uec04'),
    CUP_FILL("remixal-cup-fill", '\uec05'),
    CUP_LINE("remixal-cup-line", '\uec06'),
    CURRENCY_FILL("remixal-currency-fill", '\uec07'),
    CURRENCY_LINE("remixal-currency-line", '\uec08'),
    CURSOR_FILL("remixal-cursor-fill", '\uec09'),
    CURSOR_LINE("remixal-cursor-line", '\uec0a'),
    CUSTOMER_SERVICE_2_FILL("remixal-customer-service-2-fill", '\uec0b'),
    CUSTOMER_SERVICE_2_LINE("remixal-customer-service-2-line", '\uec0c'),
    CUSTOMER_SERVICE_FILL("remixal-customer-service-fill", '\uec0d'),
    CUSTOMER_SERVICE_LINE("remixal-customer-service-line", '\uec0e'),
    DASHBOARD_2_FILL("remixal-dashboard-2-fill", '\uec0f'),
    DASHBOARD_2_LINE("remixal-dashboard-2-line", '\uec10'),
    DASHBOARD_3_FILL("remixal-dashboard-3-fill", '\uec11'),
    DASHBOARD_3_LINE("remixal-dashboard-3-line", '\uec12'),
    DASHBOARD_FILL("remixal-dashboard-fill", '\uec13'),
    DASHBOARD_LINE("remixal-dashboard-line", '\uec14'),
    DATABASE_2_FILL("remixal-database-2-fill", '\uec15'),
    DATABASE_2_LINE("remixal-database-2-line", '\uec16'),
    DATABASE_FILL("remixal-database-fill", '\uec17'),
    DATABASE_LINE("remixal-database-line", '\uec18'),
    DELETE_BACK_2_FILL("remixal-delete-back-2-fill", '\uec19'),
    DELETE_BACK_2_LINE("remixal-delete-back-2-line", '\uec1a'),
    DELETE_BACK_FILL("remixal-delete-back-fill", '\uec1b'),
    DELETE_BACK_LINE("remixal-delete-back-line", '\uec1c'),
    DELETE_BIN_2_FILL("remixal-delete-bin-2-fill", '\uec1d'),
    DELETE_BIN_2_LINE("remixal-delete-bin-2-line", '\uec1e'),
    DELETE_BIN_3_FILL("remixal-delete-bin-3-fill", '\uec1f'),
    DELETE_BIN_3_LINE("remixal-delete-bin-3-line", '\uec20'),
    DELETE_BIN_4_FILL("remixal-delete-bin-4-fill", '\uec21'),
    DELETE_BIN_4_LINE("remixal-delete-bin-4-line", '\uec22'),
    DELETE_BIN_5_FILL("remixal-delete-bin-5-fill", '\uec23'),
    DELETE_BIN_5_LINE("remixal-delete-bin-5-line", '\uec24'),
    DELETE_BIN_6_FILL("remixal-delete-bin-6-fill", '\uec25'),
    DELETE_BIN_6_LINE("remixal-delete-bin-6-line", '\uec26'),
    DELETE_BIN_7_FILL("remixal-delete-bin-7-fill", '\uec27'),
    DELETE_BIN_7_LINE("remixal-delete-bin-7-line", '\uec28'),
    DELETE_BIN_FILL("remixal-delete-bin-fill", '\uec29'),
    DELETE_BIN_LINE("remixal-delete-bin-line", '\uec2a'),
    DELETE_COLUMN("remixal-delete-column", '\uec2b'),
    DELETE_ROW("remixal-delete-row", '\uec2c'),
    DEVICE_FILL("remixal-device-fill", '\uec2d'),
    DEVICE_LINE("remixal-device-line", '\uec2e'),
    DEVICE_RECOVER_FILL("remixal-device-recover-fill", '\uec2f'),
    DEVICE_RECOVER_LINE("remixal-device-recover-line", '\uec30'),
    DINGDING_FILL("remixal-dingding-fill", '\uec31'),
    DINGDING_LINE("remixal-dingding-line", '\uec32'),
    DIRECTION_FILL("remixal-direction-fill", '\uec33'),
    DIRECTION_LINE("remixal-direction-line", '\uec34'),
    DISCORD_FILL("remixal-discord-fill", '\uec37'),
    DISCORD_LINE("remixal-discord-line", '\uec38'),
    DISCUSS_FILL("remixal-discuss-fill", '\uec39'),
    DISCUSS_LINE("remixal-discuss-line", '\uec3a'),
    DISC_FILL("remixal-disc-fill", '\uec35'),
    DISC_LINE("remixal-disc-line", '\uec36'),
    DISLIKE_FILL("remixal-dislike-fill", '\uec3b'),
    DISLIKE_LINE("remixal-dislike-line", '\uec3c'),
    DISQUS_FILL("remixal-disqus-fill", '\uec3d'),
    DISQUS_LINE("remixal-disqus-line", '\uec3e'),
    DIVIDE_FILL("remixal-divide-fill", '\uec3f'),
    DIVIDE_LINE("remixal-divide-line", '\uec40'),
    DONUT_CHART_FILL("remixal-donut-chart-fill", '\uec41'),
    DONUT_CHART_LINE("remixal-donut-chart-line", '\uec42'),
    DOOR_CLOSED_FILL("remixal-door-closed-fill", '\uec43'),
    DOOR_CLOSED_LINE("remixal-door-closed-line", '\uec44'),
    DOOR_FILL("remixal-door-fill", '\uec45'),
    DOOR_LINE("remixal-door-line", '\uec46'),
    DOOR_LOCK_BOX_FILL("remixal-door-lock-box-fill", '\uec47'),
    DOOR_LOCK_BOX_LINE("remixal-door-lock-box-line", '\uec48'),
    DOOR_LOCK_FILL("remixal-door-lock-fill", '\uec49'),
    DOOR_LOCK_LINE("remixal-door-lock-line", '\uec4a'),
    DOOR_OPEN_FILL("remixal-door-open-fill", '\uec4b'),
    DOOR_OPEN_LINE("remixal-door-open-line", '\uec4c'),
    DOSSIER_FILL("remixal-dossier-fill", '\uec4d'),
    DOSSIER_LINE("remixal-dossier-line", '\uec4e'),
    DOUBAN_FILL("remixal-douban-fill", '\uec4f'),
    DOUBAN_LINE("remixal-douban-line", '\uec50'),
    DOUBLE_QUOTES_L("remixal-double-quotes-l", '\uec51'),
    DOUBLE_QUOTES_R("remixal-double-quotes-r", '\uec52'),
    DOWNLOAD_2_FILL("remixal-download-2-fill", '\uec53'),
    DOWNLOAD_2_LINE("remixal-download-2-line", '\uec54'),
    DOWNLOAD_CLOUD_2_FILL("remixal-download-cloud-2-fill", '\uec55'),
    DOWNLOAD_CLOUD_2_LINE("remixal-download-cloud-2-line", '\uec56'),
    DOWNLOAD_CLOUD_FILL("remixal-download-cloud-fill", '\uec57'),
    DOWNLOAD_CLOUD_LINE("remixal-download-cloud-line", '\uec58'),
    DOWNLOAD_FILL("remixal-download-fill", '\uec59'),
    DOWNLOAD_LINE("remixal-download-line", '\uec5a'),
    DRAFT_FILL("remixal-draft-fill", '\uec5b'),
    DRAFT_LINE("remixal-draft-line", '\uec5c'),
    DRAG_DROP_FILL("remixal-drag-drop-fill", '\uec5d'),
    DRAG_DROP_LINE("remixal-drag-drop-line", '\uec5e'),
    DRAG_MOVE_2_FILL("remixal-drag-move-2-fill", '\uec5f'),
    DRAG_MOVE_2_LINE("remixal-drag-move-2-line", '\uec60'),
    DRAG_MOVE_FILL("remixal-drag-move-fill", '\uec61'),
    DRAG_MOVE_LINE("remixal-drag-move-line", '\uec62'),
    DRIBBBLE_FILL("remixal-dribbble-fill", '\uec63'),
    DRIBBBLE_LINE("remixal-dribbble-line", '\uec64'),
    DRIVE_FILL("remixal-drive-fill", '\uec65'),
    DRIVE_LINE("remixal-drive-line", '\uec66'),
    DRIZZLE_FILL("remixal-drizzle-fill", '\uec67'),
    DRIZZLE_LINE("remixal-drizzle-line", '\uec68'),
    DROPBOX_FILL("remixal-dropbox-fill", '\uec6b'),
    DROPBOX_LINE("remixal-dropbox-line", '\uec6c'),
    DROP_FILL("remixal-drop-fill", '\uec69'),
    DROP_LINE("remixal-drop-line", '\uec6a'),
    DUAL_SIM_1_FILL("remixal-dual-sim-1-fill", '\uec6d'),
    DUAL_SIM_1_LINE("remixal-dual-sim-1-line", '\uec6e'),
    DUAL_SIM_2_FILL("remixal-dual-sim-2-fill", '\uec6f'),
    DUAL_SIM_2_LINE("remixal-dual-sim-2-line", '\uec70'),
    DVD_FILL("remixal-dvd-fill", '\uec73'),
    DVD_LINE("remixal-dvd-line", '\uec74'),
    DV_FILL("remixal-dv-fill", '\uec71'),
    DV_LINE("remixal-dv-line", '\uec72'),
    EARTHQUAKE_FILL("remixal-earthquake-fill", '\uec7b'),
    EARTHQUAKE_LINE("remixal-earthquake-line", '\uec7c'),
    EARTH_FILL("remixal-earth-fill", '\uec79'),
    EARTH_LINE("remixal-earth-line", '\uec7a'),
    EDGE_FILL("remixal-edge-fill", '\uec7d'),
    EDGE_LINE("remixal-edge-line", '\uec7e'),
    EDIT_2_FILL("remixal-edit-2-fill", '\uec7f'),
    EDIT_2_LINE("remixal-edit-2-line", '\uec80'),
    EDIT_BOX_FILL("remixal-edit-box-fill", '\uec81'),
    EDIT_BOX_LINE("remixal-edit-box-line", '\uec82'),
    EDIT_CIRCLE_FILL("remixal-edit-circle-fill", '\uec83'),
    EDIT_CIRCLE_LINE("remixal-edit-circle-line", '\uec84'),
    EDIT_FILL("remixal-edit-fill", '\uec85'),
    EDIT_LINE("remixal-edit-line", '\uec86'),
    EJECT_FILL("remixal-eject-fill", '\uec87'),
    EJECT_LINE("remixal-eject-line", '\uec88'),
    EMOTION_2_FILL("remixal-emotion-2-fill", '\uec89'),
    EMOTION_2_LINE("remixal-emotion-2-line", '\uec8a'),
    EMOTION_FILL("remixal-emotion-fill", '\uec8b'),
    EMOTION_HAPPY_FILL("remixal-emotion-happy-fill", '\uec8c'),
    EMOTION_HAPPY_LINE("remixal-emotion-happy-line", '\uec8d'),
    EMOTION_LAUGH_FILL("remixal-emotion-laugh-fill", '\uec8e'),
    EMOTION_LAUGH_LINE("remixal-emotion-laugh-line", '\uec8f'),
    EMOTION_LINE("remixal-emotion-line", '\uec90'),
    EMOTION_NORMAL_FILL("remixal-emotion-normal-fill", '\uec91'),
    EMOTION_NORMAL_LINE("remixal-emotion-normal-line", '\uec92'),
    EMOTION_SAD_FILL("remixal-emotion-sad-fill", '\uec93'),
    EMOTION_SAD_LINE("remixal-emotion-sad-line", '\uec94'),
    EMOTION_UNHAPPY_FILL("remixal-emotion-unhappy-fill", '\uec95'),
    EMOTION_UNHAPPY_LINE("remixal-emotion-unhappy-line", '\uec96'),
    EMPATHIZE_FILL("remixal-empathize-fill", '\uec97'),
    EMPATHIZE_LINE("remixal-empathize-line", '\uec98'),
    EMPHASIS("remixal-emphasis", '\uec9a'),
    EMPHASIS_CN("remixal-emphasis-cn", '\uec99'),
    ENGLISH_INPUT("remixal-english-input", '\uec9b'),
    EQUALIZER_FILL("remixal-equalizer-fill", '\uec9c'),
    EQUALIZER_LINE("remixal-equalizer-line", '\uec9d'),
    ERASER_FILL("remixal-eraser-fill", '\uec9e'),
    ERASER_LINE("remixal-eraser-line", '\uec9f'),
    ERROR_WARNING_FILL("remixal-error-warning-fill", '\ueca0'),
    ERROR_WARNING_LINE("remixal-error-warning-line", '\ueca1'),
    EVERNOTE_FILL("remixal-evernote-fill", '\ueca2'),
    EVERNOTE_LINE("remixal-evernote-line", '\ueca3'),
    EXCHANGE_BOX_FILL("remixal-exchange-box-fill", '\ueca4'),
    EXCHANGE_BOX_LINE("remixal-exchange-box-line", '\ueca5'),
    EXCHANGE_CNY_FILL("remixal-exchange-cny-fill", '\ueca6'),
    EXCHANGE_CNY_LINE("remixal-exchange-cny-line", '\ueca7'),
    EXCHANGE_DOLLAR_FILL("remixal-exchange-dollar-fill", '\ueca8'),
    EXCHANGE_DOLLAR_LINE("remixal-exchange-dollar-line", '\ueca9'),
    EXCHANGE_FILL("remixal-exchange-fill", '\uecaa'),
    EXCHANGE_FUNDS_FILL("remixal-exchange-funds-fill", '\uecab'),
    EXCHANGE_FUNDS_LINE("remixal-exchange-funds-line", '\uecac'),
    EXCHANGE_LINE("remixal-exchange-line", '\uecad'),
    EXTERNAL_LINK_FILL("remixal-external-link-fill", '\uecae'),
    EXTERNAL_LINK_LINE("remixal-external-link-line", '\uecaf'),
    EYE_2_FILL("remixal-eye-2-fill", '\uecb0'),
    EYE_2_LINE("remixal-eye-2-line", '\uecb1'),
    EYE_CLOSE_FILL("remixal-eye-close-fill", '\uecb2'),
    EYE_CLOSE_LINE("remixal-eye-close-line", '\uecb3'),
    EYE_FILL("remixal-eye-fill", '\uecb4'),
    EYE_LINE("remixal-eye-line", '\uecb5'),
    EYE_OFF_FILL("remixal-eye-off-fill", '\uecb6'),
    EYE_OFF_LINE("remixal-eye-off-line", '\uecb7'),
    E_BIKE_2_FILL("remixal-e-bike-2-fill", '\uec75'),
    E_BIKE_2_LINE("remixal-e-bike-2-line", '\uec76'),
    E_BIKE_FILL("remixal-e-bike-fill", '\uec77'),
    E_BIKE_LINE("remixal-e-bike-line", '\uec78'),
    FACEBOOK_BOX_FILL("remixal-facebook-box-fill", '\uecb8'),
    FACEBOOK_BOX_LINE("remixal-facebook-box-line", '\uecb9'),
    FACEBOOK_CIRCLE_FILL("remixal-facebook-circle-fill", '\uecba'),
    FACEBOOK_CIRCLE_LINE("remixal-facebook-circle-line", '\uecbb'),
    FACEBOOK_FILL("remixal-facebook-fill", '\uecbc'),
    FACEBOOK_LINE("remixal-facebook-line", '\uecbd'),
    FAHRENHEIT_FILL("remixal-fahrenheit-fill", '\uecbe'),
    FAHRENHEIT_LINE("remixal-fahrenheit-line", '\uecbf'),
    FEEDBACK_FILL("remixal-feedback-fill", '\uecc0'),
    FEEDBACK_LINE("remixal-feedback-line", '\uecc1'),
    FILE_2_FILL("remixal-file-2-fill", '\uecc2'),
    FILE_2_LINE("remixal-file-2-line", '\uecc3'),
    FILE_3_FILL("remixal-file-3-fill", '\uecc4'),
    FILE_3_LINE("remixal-file-3-line", '\uecc5'),
    FILE_4_FILL("remixal-file-4-fill", '\uecc6'),
    FILE_4_LINE("remixal-file-4-line", '\uecc7'),
    FILE_ADD_FILL("remixal-file-add-fill", '\uecc8'),
    FILE_ADD_LINE("remixal-file-add-line", '\uecc9'),
    FILE_CHART_2_FILL("remixal-file-chart-2-fill", '\uecca'),
    FILE_CHART_2_LINE("remixal-file-chart-2-line", '\ueccb'),
    FILE_CHART_FILL("remixal-file-chart-fill", '\ueccc'),
    FILE_CHART_LINE("remixal-file-chart-line", '\ueccd'),
    FILE_CLOUD_FILL("remixal-file-cloud-fill", '\uecce'),
    FILE_CLOUD_LINE("remixal-file-cloud-line", '\ueccf'),
    FILE_CODE_FILL("remixal-file-code-fill", '\uecd0'),
    FILE_CODE_LINE("remixal-file-code-line", '\uecd1'),
    FILE_COPY_2_FILL("remixal-file-copy-2-fill", '\uecd2'),
    FILE_COPY_2_LINE("remixal-file-copy-2-line", '\uecd3'),
    FILE_COPY_FILL("remixal-file-copy-fill", '\uecd4'),
    FILE_COPY_LINE("remixal-file-copy-line", '\uecd5'),
    FILE_DAMAGE_FILL("remixal-file-damage-fill", '\uecd6'),
    FILE_DAMAGE_LINE("remixal-file-damage-line", '\uecd7'),
    FILE_DOWNLOAD_FILL("remixal-file-download-fill", '\uecd8'),
    FILE_DOWNLOAD_LINE("remixal-file-download-line", '\uecd9'),
    FILE_EDIT_FILL("remixal-file-edit-fill", '\uecda'),
    FILE_EDIT_LINE("remixal-file-edit-line", '\uecdb'),
    FILE_EXCEL_2_FILL("remixal-file-excel-2-fill", '\uecdc'),
    FILE_EXCEL_2_LINE("remixal-file-excel-2-line", '\uecdd'),
    FILE_EXCEL_FILL("remixal-file-excel-fill", '\uecde'),
    FILE_EXCEL_LINE("remixal-file-excel-line", '\uecdf'),
    FILE_FILL("remixal-file-fill", '\uece0'),
    FILE_FORBID_FILL("remixal-file-forbid-fill", '\uece1'),
    FILE_FORBID_LINE("remixal-file-forbid-line", '\uece2'),
    FILE_GIF_FILL("remixal-file-gif-fill", '\uece3'),
    FILE_GIF_LINE("remixal-file-gif-line", '\uece4'),
    FILE_HISTORY_FILL("remixal-file-history-fill", '\uece5'),
    FILE_HISTORY_LINE("remixal-file-history-line", '\uece6'),
    FILE_HWP_FILL("remixal-file-hwp-fill", '\uece7'),
    FILE_HWP_LINE("remixal-file-hwp-line", '\uece8'),
    FILE_INFO_FILL("remixal-file-info-fill", '\uece9'),
    FILE_INFO_LINE("remixal-file-info-line", '\uecea'),
    FILE_LINE("remixal-file-line", '\ueceb'),
    FILE_LIST_2_FILL("remixal-file-list-2-fill", '\uecec'),
    FILE_LIST_2_LINE("remixal-file-list-2-line", '\ueced'),
    FILE_LIST_3_FILL("remixal-file-list-3-fill", '\uecee'),
    FILE_LIST_3_LINE("remixal-file-list-3-line", '\uecef'),
    FILE_LIST_FILL("remixal-file-list-fill", '\uecf0'),
    FILE_LIST_LINE("remixal-file-list-line", '\uecf1'),
    FILE_LOCK_FILL("remixal-file-lock-fill", '\uecf2'),
    FILE_LOCK_LINE("remixal-file-lock-line", '\uecf3'),
    FILE_MARK_FILL("remixal-file-mark-fill", '\uecf4'),
    FILE_MARK_LINE("remixal-file-mark-line", '\uecf5'),
    FILE_MUSIC_FILL("remixal-file-music-fill", '\uecf6'),
    FILE_MUSIC_LINE("remixal-file-music-line", '\uecf7'),
    FILE_PAPER_2_FILL("remixal-file-paper-2-fill", '\uecf8'),
    FILE_PAPER_2_LINE("remixal-file-paper-2-line", '\uecf9'),
    FILE_PAPER_FILL("remixal-file-paper-fill", '\uecfa'),
    FILE_PAPER_LINE("remixal-file-paper-line", '\uecfb'),
    FILE_PDF_FILL("remixal-file-pdf-fill", '\uecfc'),
    FILE_PDF_LINE("remixal-file-pdf-line", '\uecfd'),
    FILE_PPT_2_FILL("remixal-file-ppt-2-fill", '\uecfe'),
    FILE_PPT_2_LINE("remixal-file-ppt-2-line", '\uecff'),
    FILE_PPT_FILL("remixal-file-ppt-fill", '\ued00'),
    FILE_PPT_LINE("remixal-file-ppt-line", '\ued01'),
    FILE_REDUCE_FILL("remixal-file-reduce-fill", '\ued02'),
    FILE_REDUCE_LINE("remixal-file-reduce-line", '\ued03'),
    FILE_SEARCH_FILL("remixal-file-search-fill", '\ued04'),
    FILE_SEARCH_LINE("remixal-file-search-line", '\ued05'),
    FILE_SETTINGS_FILL("remixal-file-settings-fill", '\ued06'),
    FILE_SETTINGS_LINE("remixal-file-settings-line", '\ued07'),
    FILE_SHIELD_2_FILL("remixal-file-shield-2-fill", '\ued08'),
    FILE_SHIELD_2_LINE("remixal-file-shield-2-line", '\ued09'),
    FILE_SHIELD_FILL("remixal-file-shield-fill", '\ued0a'),
    FILE_SHIELD_LINE("remixal-file-shield-line", '\ued0b'),
    FILE_SHRED_FILL("remixal-file-shred-fill", '\ued0c'),
    FILE_SHRED_LINE("remixal-file-shred-line", '\ued0d'),
    FILE_TEXT_FILL("remixal-file-text-fill", '\ued0e'),
    FILE_TEXT_LINE("remixal-file-text-line", '\ued0f'),
    FILE_TRANSFER_FILL("remixal-file-transfer-fill", '\ued10'),
    FILE_TRANSFER_LINE("remixal-file-transfer-line", '\ued11'),
    FILE_UNKNOW_FILL("remixal-file-unknow-fill", '\ued12'),
    FILE_UNKNOW_LINE("remixal-file-unknow-line", '\ued13'),
    FILE_UPLOAD_FILL("remixal-file-upload-fill", '\ued14'),
    FILE_UPLOAD_LINE("remixal-file-upload-line", '\ued15'),
    FILE_USER_FILL("remixal-file-user-fill", '\ued16'),
    FILE_USER_LINE("remixal-file-user-line", '\ued17'),
    FILE_WARNING_FILL("remixal-file-warning-fill", '\ued18'),
    FILE_WARNING_LINE("remixal-file-warning-line", '\ued19'),
    FILE_WORD_2_FILL("remixal-file-word-2-fill", '\ued1a'),
    FILE_WORD_2_LINE("remixal-file-word-2-line", '\ued1b'),
    FILE_WORD_FILL("remixal-file-word-fill", '\ued1c'),
    FILE_WORD_LINE("remixal-file-word-line", '\ued1d'),
    FILE_ZIP_FILL("remixal-file-zip-fill", '\ued1e'),
    FILE_ZIP_LINE("remixal-file-zip-line", '\ued1f'),
    FILM_FILL("remixal-film-fill", '\ued20'),
    FILM_LINE("remixal-film-line", '\ued21'),
    FILTER_2_FILL("remixal-filter-2-fill", '\ued22'),
    FILTER_2_LINE("remixal-filter-2-line", '\ued23'),
    FILTER_3_FILL("remixal-filter-3-fill", '\ued24'),
    FILTER_3_LINE("remixal-filter-3-line", '\ued25'),
    FILTER_FILL("remixal-filter-fill", '\ued26'),
    FILTER_LINE("remixal-filter-line", '\ued27'),
    FILTER_OFF_FILL("remixal-filter-off-fill", '\ued28'),
    FILTER_OFF_LINE("remixal-filter-off-line", '\ued29'),
    FINDER_FILL("remixal-finder-fill", '\ued2c'),
    FINDER_LINE("remixal-finder-line", '\ued2d'),
    FIND_REPLACE_FILL("remixal-find-replace-fill", '\ued2a'),
    FIND_REPLACE_LINE("remixal-find-replace-line", '\ued2b'),
    FINGERPRINT_2_FILL("remixal-fingerprint-2-fill", '\ued2e'),
    FINGERPRINT_2_LINE("remixal-fingerprint-2-line", '\ued2f'),
    FINGERPRINT_FILL("remixal-fingerprint-fill", '\ued30'),
    FINGERPRINT_LINE("remixal-fingerprint-line", '\ued31'),
    FIREFOX_FILL("remixal-firefox-fill", '\ued34'),
    FIREFOX_LINE("remixal-firefox-line", '\ued35'),
    FIRE_FILL("remixal-fire-fill", '\ued32'),
    FIRE_LINE("remixal-fire-line", '\ued33'),
    FIRST_AID_KIT_FILL("remixal-first-aid-kit-fill", '\ued36'),
    FIRST_AID_KIT_LINE("remixal-first-aid-kit-line", '\ued37'),
    FLAG_2_FILL("remixal-flag-2-fill", '\ued38'),
    FLAG_2_LINE("remixal-flag-2-line", '\ued39'),
    FLAG_FILL("remixal-flag-fill", '\ued3a'),
    FLAG_LINE("remixal-flag-line", '\ued3b'),
    FLASHLIGHT_FILL("remixal-flashlight-fill", '\ued3c'),
    FLASHLIGHT_LINE("remixal-flashlight-line", '\ued3d'),
    FLASK_FILL("remixal-flask-fill", '\ued3e'),
    FLASK_LINE("remixal-flask-line", '\ued3f'),
    FLIGHT_LAND_FILL("remixal-flight-land-fill", '\ued40'),
    FLIGHT_LAND_LINE("remixal-flight-land-line", '\ued41'),
    FLIGHT_TAKEOFF_FILL("remixal-flight-takeoff-fill", '\ued42'),
    FLIGHT_TAKEOFF_LINE("remixal-flight-takeoff-line", '\ued43'),
    FLOOD_FILL("remixal-flood-fill", '\ued44'),
    FLOOD_LINE("remixal-flood-line", '\ued45'),
    FLOW_CHART("remixal-flow-chart", '\ued46'),
    FLUTTER_FILL("remixal-flutter-fill", '\ued47'),
    FLUTTER_LINE("remixal-flutter-line", '\ued48'),
    FOCUS_2_FILL("remixal-focus-2-fill", '\ued49'),
    FOCUS_2_LINE("remixal-focus-2-line", '\ued4a'),
    FOCUS_3_FILL("remixal-focus-3-fill", '\ued4b'),
    FOCUS_3_LINE("remixal-focus-3-line", '\ued4c'),
    FOCUS_FILL("remixal-focus-fill", '\ued4d'),
    FOCUS_LINE("remixal-focus-line", '\ued4e'),
    FOGGY_FILL("remixal-foggy-fill", '\ued4f'),
    FOGGY_LINE("remixal-foggy-line", '\ued50'),
    FOLDERS_FILL("remixal-folders-fill", '\ued89'),
    FOLDERS_LINE("remixal-folders-line", '\ued8a'),
    FOLDER_2_FILL("remixal-folder-2-fill", '\ued51'),
    FOLDER_2_LINE("remixal-folder-2-line", '\ued52'),
    FOLDER_3_FILL("remixal-folder-3-fill", '\ued53'),
    FOLDER_3_LINE("remixal-folder-3-line", '\ued54'),
    FOLDER_4_FILL("remixal-folder-4-fill", '\ued55'),
    FOLDER_4_LINE("remixal-folder-4-line", '\ued56'),
    FOLDER_5_FILL("remixal-folder-5-fill", '\ued57'),
    FOLDER_5_LINE("remixal-folder-5-line", '\ued58'),
    FOLDER_ADD_FILL("remixal-folder-add-fill", '\ued59'),
    FOLDER_ADD_LINE("remixal-folder-add-line", '\ued5a'),
    FOLDER_CHART_2_FILL("remixal-folder-chart-2-fill", '\ued5b'),
    FOLDER_CHART_2_LINE("remixal-folder-chart-2-line", '\ued5c'),
    FOLDER_CHART_FILL("remixal-folder-chart-fill", '\ued5d'),
    FOLDER_CHART_LINE("remixal-folder-chart-line", '\ued5e'),
    FOLDER_DOWNLOAD_FILL("remixal-folder-download-fill", '\ued5f'),
    FOLDER_DOWNLOAD_LINE("remixal-folder-download-line", '\ued60'),
    FOLDER_FILL("remixal-folder-fill", '\ued61'),
    FOLDER_FORBID_FILL("remixal-folder-forbid-fill", '\ued62'),
    FOLDER_FORBID_LINE("remixal-folder-forbid-line", '\ued63'),
    FOLDER_HISTORY_FILL("remixal-folder-history-fill", '\ued64'),
    FOLDER_HISTORY_LINE("remixal-folder-history-line", '\ued65'),
    FOLDER_INFO_FILL("remixal-folder-info-fill", '\ued66'),
    FOLDER_INFO_LINE("remixal-folder-info-line", '\ued67'),
    FOLDER_KEYHOLE_FILL("remixal-folder-keyhole-fill", '\ued68'),
    FOLDER_KEYHOLE_LINE("remixal-folder-keyhole-line", '\ued69'),
    FOLDER_LINE("remixal-folder-line", '\ued6a'),
    FOLDER_LOCK_FILL("remixal-folder-lock-fill", '\ued6b'),
    FOLDER_LOCK_LINE("remixal-folder-lock-line", '\ued6c'),
    FOLDER_MUSIC_FILL("remixal-folder-music-fill", '\ued6d'),
    FOLDER_MUSIC_LINE("remixal-folder-music-line", '\ued6e'),
    FOLDER_OPEN_FILL("remixal-folder-open-fill", '\ued6f'),
    FOLDER_OPEN_LINE("remixal-folder-open-line", '\ued70'),
    FOLDER_RECEIVED_FILL("remixal-folder-received-fill", '\ued71'),
    FOLDER_RECEIVED_LINE("remixal-folder-received-line", '\ued72'),
    FOLDER_REDUCE_FILL("remixal-folder-reduce-fill", '\ued73'),
    FOLDER_REDUCE_LINE("remixal-folder-reduce-line", '\ued74'),
    FOLDER_SETTINGS_FILL("remixal-folder-settings-fill", '\ued75'),
    FOLDER_SETTINGS_LINE("remixal-folder-settings-line", '\ued76'),
    FOLDER_SHARED_FILL("remixal-folder-shared-fill", '\ued77'),
    FOLDER_SHARED_LINE("remixal-folder-shared-line", '\ued78'),
    FOLDER_SHIELD_2_FILL("remixal-folder-shield-2-fill", '\ued79'),
    FOLDER_SHIELD_2_LINE("remixal-folder-shield-2-line", '\ued7a'),
    FOLDER_SHIELD_FILL("remixal-folder-shield-fill", '\ued7b'),
    FOLDER_SHIELD_LINE("remixal-folder-shield-line", '\ued7c'),
    FOLDER_TRANSFER_FILL("remixal-folder-transfer-fill", '\ued7d'),
    FOLDER_TRANSFER_LINE("remixal-folder-transfer-line", '\ued7e'),
    FOLDER_UNKNOW_FILL("remixal-folder-unknow-fill", '\ued7f'),
    FOLDER_UNKNOW_LINE("remixal-folder-unknow-line", '\ued80'),
    FOLDER_UPLOAD_FILL("remixal-folder-upload-fill", '\ued81'),
    FOLDER_UPLOAD_LINE("remixal-folder-upload-line", '\ued82'),
    FOLDER_USER_FILL("remixal-folder-user-fill", '\ued83'),
    FOLDER_USER_LINE("remixal-folder-user-line", '\ued84'),
    FOLDER_WARNING_FILL("remixal-folder-warning-fill", '\ued85'),
    FOLDER_WARNING_LINE("remixal-folder-warning-line", '\ued86'),
    FOLDER_ZIP_FILL("remixal-folder-zip-fill", '\ued87'),
    FOLDER_ZIP_LINE("remixal-folder-zip-line", '\ued88'),
    FONT_COLOR("remixal-font-color", '\ued8b'),
    FONT_SIZE("remixal-font-size", '\ued8d'),
    FONT_SIZE_2("remixal-font-size-2", '\ued8c'),
    FOOTBALL_FILL("remixal-football-fill", '\ued8e'),
    FOOTBALL_LINE("remixal-football-line", '\ued8f'),
    FOOTPRINT_FILL("remixal-footprint-fill", '\ued90'),
    FOOTPRINT_LINE("remixal-footprint-line", '\ued91'),
    FORBID_2_FILL("remixal-forbid-2-fill", '\ued92'),
    FORBID_2_LINE("remixal-forbid-2-line", '\ued93'),
    FORBID_FILL("remixal-forbid-fill", '\ued94'),
    FORBID_LINE("remixal-forbid-line", '\ued95'),
    FORMAT_CLEAR("remixal-format-clear", '\ued96'),
    FRIDGE_FILL("remixal-fridge-fill", '\ued97'),
    FRIDGE_LINE("remixal-fridge-line", '\ued98'),
    FULLSCREEN_EXIT_FILL("remixal-fullscreen-exit-fill", '\ued99'),
    FULLSCREEN_EXIT_LINE("remixal-fullscreen-exit-line", '\ued9a'),
    FULLSCREEN_FILL("remixal-fullscreen-fill", '\ued9b'),
    FULLSCREEN_LINE("remixal-fullscreen-line", '\ued9c'),
    FUNCTIONS("remixal-functions", '\ued9f'),
    FUNCTION_FILL("remixal-function-fill", '\ued9d'),
    FUNCTION_LINE("remixal-function-line", '\ued9e'),
    FUNDS_BOX_FILL("remixal-funds-box-fill", '\ueda0'),
    FUNDS_BOX_LINE("remixal-funds-box-line", '\ueda1'),
    FUNDS_FILL("remixal-funds-fill", '\ueda2'),
    FUNDS_LINE("remixal-funds-line", '\ueda3'),
    GALLERY_FILL("remixal-gallery-fill", '\ueda4'),
    GALLERY_LINE("remixal-gallery-line", '\ueda5'),
    GALLERY_UPLOAD_FILL("remixal-gallery-upload-fill", '\ueda6'),
    GALLERY_UPLOAD_LINE("remixal-gallery-upload-line", '\ueda7'),
    GAMEPAD_FILL("remixal-gamepad-fill", '\uedaa'),
    GAMEPAD_LINE("remixal-gamepad-line", '\uedab'),
    GAME_FILL("remixal-game-fill", '\ueda8'),
    GAME_LINE("remixal-game-line", '\ueda9'),
    GAS_STATION_FILL("remixal-gas-station-fill", '\uedac'),
    GAS_STATION_LINE("remixal-gas-station-line", '\uedad'),
    GATSBY_FILL("remixal-gatsby-fill", '\uedae'),
    GATSBY_LINE("remixal-gatsby-line", '\uedaf'),
    GENDERLESS_FILL("remixal-genderless-fill", '\uedb0'),
    GENDERLESS_LINE("remixal-genderless-line", '\uedb1'),
    GHOST_2_FILL("remixal-ghost-2-fill", '\uedb2'),
    GHOST_2_LINE("remixal-ghost-2-line", '\uedb3'),
    GHOST_FILL("remixal-ghost-fill", '\uedb4'),
    GHOST_LINE("remixal-ghost-line", '\uedb5'),
    GHOST_SMILE_FILL("remixal-ghost-smile-fill", '\uedb6'),
    GHOST_SMILE_LINE("remixal-ghost-smile-line", '\uedb7'),
    GIFT_2_FILL("remixal-gift-2-fill", '\uedb8'),
    GIFT_2_LINE("remixal-gift-2-line", '\uedb9'),
    GIFT_FILL("remixal-gift-fill", '\uedba'),
    GIFT_LINE("remixal-gift-line", '\uedbb'),
    GITHUB_FILL("remixal-github-fill", '\uedca'),
    GITHUB_LINE("remixal-github-line", '\uedcb'),
    GITLAB_FILL("remixal-gitlab-fill", '\uedcc'),
    GITLAB_LINE("remixal-gitlab-line", '\uedcd'),
    GIT_BRANCH_FILL("remixal-git-branch-fill", '\uedbc'),
    GIT_BRANCH_LINE("remixal-git-branch-line", '\uedbd'),
    GIT_COMMIT_FILL("remixal-git-commit-fill", '\uedbe'),
    GIT_COMMIT_LINE("remixal-git-commit-line", '\uedbf'),
    GIT_MERGE_FILL("remixal-git-merge-fill", '\uedc0'),
    GIT_MERGE_LINE("remixal-git-merge-line", '\uedc1'),
    GIT_PULL_REQUEST_FILL("remixal-git-pull-request-fill", '\uedc2'),
    GIT_PULL_REQUEST_LINE("remixal-git-pull-request-line", '\uedc3'),
    GIT_REPOSITORY_COMMITS_FILL("remixal-git-repository-commits-fill", '\uedc4'),
    GIT_REPOSITORY_COMMITS_LINE("remixal-git-repository-commits-line", '\uedc5'),
    GIT_REPOSITORY_FILL("remixal-git-repository-fill", '\uedc6'),
    GIT_REPOSITORY_LINE("remixal-git-repository-line", '\uedc7'),
    GIT_REPOSITORY_PRIVATE_FILL("remixal-git-repository-private-fill", '\uedc8'),
    GIT_REPOSITORY_PRIVATE_LINE("remixal-git-repository-private-line", '\uedc9'),
    GLOBAL_FILL("remixal-global-fill", '\uedce'),
    GLOBAL_LINE("remixal-global-line", '\uedcf'),
    GLOBE_FILL("remixal-globe-fill", '\uedd0'),
    GLOBE_LINE("remixal-globe-line", '\uedd1'),
    GOBLET_FILL("remixal-goblet-fill", '\uedd2'),
    GOBLET_LINE("remixal-goblet-line", '\uedd3'),
    GOOGLE_FILL("remixal-google-fill", '\uedd4'),
    GOOGLE_LINE("remixal-google-line", '\uedd5'),
    GOOGLE_PLAY_FILL("remixal-google-play-fill", '\uedd6'),
    GOOGLE_PLAY_LINE("remixal-google-play-line", '\uedd7'),
    GOVERNMENT_FILL("remixal-government-fill", '\uedd8'),
    GOVERNMENT_LINE("remixal-government-line", '\uedd9'),
    GPS_FILL("remixal-gps-fill", '\uedda'),
    GPS_LINE("remixal-gps-line", '\ueddb'),
    GRADIENTER_FILL("remixal-gradienter-fill", '\ueddc'),
    GRADIENTER_LINE("remixal-gradienter-line", '\ueddd'),
    GRID_FILL("remixal-grid-fill", '\uedde'),
    GRID_LINE("remixal-grid-line", '\ueddf'),
    GROUP_2_FILL("remixal-group-2-fill", '\uede0'),
    GROUP_2_LINE("remixal-group-2-line", '\uede1'),
    GROUP_FILL("remixal-group-fill", '\uede2'),
    GROUP_LINE("remixal-group-line", '\uede3'),
    GUIDE_FILL("remixal-guide-fill", '\uede4'),
    GUIDE_LINE("remixal-guide-line", '\uede5'),
    HAIL_FILL("remixal-hail-fill", '\uedec'),
    HAIL_LINE("remixal-hail-line", '\ueded'),
    HAMMER_FILL("remixal-hammer-fill", '\uedee'),
    HAMMER_LINE("remixal-hammer-line", '\uedef'),
    HANDBAG_FILL("remixal-handbag-fill", '\uedf6'),
    HANDBAG_LINE("remixal-handbag-line", '\uedf7'),
    HAND_COIN_FILL("remixal-hand-coin-fill", '\uedf0'),
    HAND_COIN_LINE("remixal-hand-coin-line", '\uedf1'),
    HAND_HEART_FILL("remixal-hand-heart-fill", '\uedf2'),
    HAND_HEART_LINE("remixal-hand-heart-line", '\uedf3'),
    HAND_SANITIZER_FILL("remixal-hand-sanitizer-fill", '\uedf4'),
    HAND_SANITIZER_LINE("remixal-hand-sanitizer-line", '\uedf5'),
    HARD_DRIVE_2_FILL("remixal-hard-drive-2-fill", '\uedf8'),
    HARD_DRIVE_2_LINE("remixal-hard-drive-2-line", '\uedf9'),
    HARD_DRIVE_FILL("remixal-hard-drive-fill", '\uedfa'),
    HARD_DRIVE_LINE("remixal-hard-drive-line", '\uedfb'),
    HASHTAG("remixal-hashtag", '\uedfc'),
    HAZE_2_FILL("remixal-haze-2-fill", '\uedfd'),
    HAZE_2_LINE("remixal-haze-2-line", '\uedfe'),
    HAZE_FILL("remixal-haze-fill", '\uedff'),
    HAZE_LINE("remixal-haze-line", '\uee00'),
    HD_FILL("remixal-hd-fill", '\uee01'),
    HD_LINE("remixal-hd-line", '\uee02'),
    HEADING("remixal-heading", '\uee03'),
    HEADPHONE_FILL("remixal-headphone-fill", '\uee04'),
    HEADPHONE_LINE("remixal-headphone-line", '\uee05'),
    HEALTH_BOOK_FILL("remixal-health-book-fill", '\uee06'),
    HEALTH_BOOK_LINE("remixal-health-book-line", '\uee07'),
    HEARTS_FILL("remixal-hearts-fill", '\uee12'),
    HEARTS_LINE("remixal-hearts-line", '\uee13'),
    HEART_2_FILL("remixal-heart-2-fill", '\uee08'),
    HEART_2_LINE("remixal-heart-2-line", '\uee09'),
    HEART_3_FILL("remixal-heart-3-fill", '\uee0a'),
    HEART_3_LINE("remixal-heart-3-line", '\uee0b'),
    HEART_ADD_FILL("remixal-heart-add-fill", '\uee0c'),
    HEART_ADD_LINE("remixal-heart-add-line", '\uee0d'),
    HEART_FILL("remixal-heart-fill", '\uee0e'),
    HEART_LINE("remixal-heart-line", '\uee0f'),
    HEART_PULSE_FILL("remixal-heart-pulse-fill", '\uee10'),
    HEART_PULSE_LINE("remixal-heart-pulse-line", '\uee11'),
    HEAVY_SHOWERS_FILL("remixal-heavy-showers-fill", '\uee14'),
    HEAVY_SHOWERS_LINE("remixal-heavy-showers-line", '\uee15'),
    HISTORY_FILL("remixal-history-fill", '\uee16'),
    HISTORY_LINE("remixal-history-line", '\uee17'),
    HOME_2_FILL("remixal-home-2-fill", '\uee18'),
    HOME_2_LINE("remixal-home-2-line", '\uee19'),
    HOME_3_FILL("remixal-home-3-fill", '\uee1a'),
    HOME_3_LINE("remixal-home-3-line", '\uee1b'),
    HOME_4_FILL("remixal-home-4-fill", '\uee1c'),
    HOME_4_LINE("remixal-home-4-line", '\uee1d'),
    HOME_5_FILL("remixal-home-5-fill", '\uee1e'),
    HOME_5_LINE("remixal-home-5-line", '\uee1f'),
    HOME_6_FILL("remixal-home-6-fill", '\uee20'),
    HOME_6_LINE("remixal-home-6-line", '\uee21'),
    HOME_7_FILL("remixal-home-7-fill", '\uee22'),
    HOME_7_LINE("remixal-home-7-line", '\uee23'),
    HOME_8_FILL("remixal-home-8-fill", '\uee24'),
    HOME_8_LINE("remixal-home-8-line", '\uee25'),
    HOME_FILL("remixal-home-fill", '\uee26'),
    HOME_GEAR_FILL("remixal-home-gear-fill", '\uee27'),
    HOME_GEAR_LINE("remixal-home-gear-line", '\uee28'),
    HOME_HEART_FILL("remixal-home-heart-fill", '\uee29'),
    HOME_HEART_LINE("remixal-home-heart-line", '\uee2a'),
    HOME_LINE("remixal-home-line", '\uee2b'),
    HOME_SMILE_2_FILL("remixal-home-smile-2-fill", '\uee2c'),
    HOME_SMILE_2_LINE("remixal-home-smile-2-line", '\uee2d'),
    HOME_SMILE_FILL("remixal-home-smile-fill", '\uee2e'),
    HOME_SMILE_LINE("remixal-home-smile-line", '\uee2f'),
    HOME_WIFI_FILL("remixal-home-wifi-fill", '\uee30'),
    HOME_WIFI_LINE("remixal-home-wifi-line", '\uee31'),
    HONOR_OF_KINGS_FILL("remixal-honor-of-kings-fill", '\uee32'),
    HONOR_OF_KINGS_LINE("remixal-honor-of-kings-line", '\uee33'),
    HONOUR_FILL("remixal-honour-fill", '\uee34'),
    HONOUR_LINE("remixal-honour-line", '\uee35'),
    HOSPITAL_FILL("remixal-hospital-fill", '\uee36'),
    HOSPITAL_LINE("remixal-hospital-line", '\uee37'),
    HOTEL_BED_FILL("remixal-hotel-bed-fill", '\uee38'),
    HOTEL_BED_LINE("remixal-hotel-bed-line", '\uee39'),
    HOTEL_FILL("remixal-hotel-fill", '\uee3a'),
    HOTEL_LINE("remixal-hotel-line", '\uee3b'),
    HOTSPOT_FILL("remixal-hotspot-fill", '\uee3c'),
    HOTSPOT_LINE("remixal-hotspot-line", '\uee3d'),
    HQ_FILL("remixal-hq-fill", '\uee3e'),
    HQ_LINE("remixal-hq-line", '\uee3f'),
    HTML5_FILL("remixal-html5-fill", '\uee40'),
    HTML5_LINE("remixal-html5-line", '\uee41'),
    H_1("remixal-h-1", '\uede6'),
    H_2("remixal-h-2", '\uede7'),
    H_3("remixal-h-3", '\uede8'),
    H_4("remixal-h-4", '\uede9'),
    H_5("remixal-h-5", '\uedea'),
    H_6("remixal-h-6", '\uedeb'),
    IE_FILL("remixal-ie-fill", '\uee42'),
    IE_LINE("remixal-ie-line", '\uee43'),
    IMAGE_2_FILL("remixal-image-2-fill", '\uee44'),
    IMAGE_2_LINE("remixal-image-2-line", '\uee45'),
    IMAGE_ADD_FILL("remixal-image-add-fill", '\uee46'),
    IMAGE_ADD_LINE("remixal-image-add-line", '\uee47'),
    IMAGE_EDIT_FILL("remixal-image-edit-fill", '\uee48'),
    IMAGE_EDIT_LINE("remixal-image-edit-line", '\uee49'),
    IMAGE_FILL("remixal-image-fill", '\uee4a'),
    IMAGE_LINE("remixal-image-line", '\uee4b'),
    INBOX_ARCHIVE_FILL("remixal-inbox-archive-fill", '\uee4c'),
    INBOX_ARCHIVE_LINE("remixal-inbox-archive-line", '\uee4d'),
    INBOX_FILL("remixal-inbox-fill", '\uee4e'),
    INBOX_LINE("remixal-inbox-line", '\uee4f'),
    INBOX_UNARCHIVE_FILL("remixal-inbox-unarchive-fill", '\uee50'),
    INBOX_UNARCHIVE_LINE("remixal-inbox-unarchive-line", '\uee51'),
    INCREASE_DECREASE_FILL("remixal-increase-decrease-fill", '\uee52'),
    INCREASE_DECREASE_LINE("remixal-increase-decrease-line", '\uee53'),
    INDENT_DECREASE("remixal-indent-decrease", '\uee54'),
    INDENT_INCREASE("remixal-indent-increase", '\uee55'),
    INDETERMINATE_CIRCLE_FILL("remixal-indeterminate-circle-fill", '\uee56'),
    INDETERMINATE_CIRCLE_LINE("remixal-indeterminate-circle-line", '\uee57'),
    INFORMATION_FILL("remixal-information-fill", '\uee58'),
    INFORMATION_LINE("remixal-information-line", '\uee59'),
    INFRARED_THERMOMETER_FILL("remixal-infrared-thermometer-fill", '\uee5a'),
    INFRARED_THERMOMETER_LINE("remixal-infrared-thermometer-line", '\uee5b'),
    INK_BOTTLE_FILL("remixal-ink-bottle-fill", '\uee5c'),
    INK_BOTTLE_LINE("remixal-ink-bottle-line", '\uee5d'),
    INPUT_CURSOR_MOVE("remixal-input-cursor-move", '\uee5e'),
    INPUT_METHOD_FILL("remixal-input-method-fill", '\uee5f'),
    INPUT_METHOD_LINE("remixal-input-method-line", '\uee60'),
    INSERT_COLUMN_LEFT("remixal-insert-column-left", '\uee61'),
    INSERT_COLUMN_RIGHT("remixal-insert-column-right", '\uee62'),
    INSERT_ROW_BOTTOM("remixal-insert-row-bottom", '\uee63'),
    INSERT_ROW_TOP("remixal-insert-row-top", '\uee64'),
    INSTAGRAM_FILL("remixal-instagram-fill", '\uee65'),
    INSTAGRAM_LINE("remixal-instagram-line", '\uee66'),
    INSTALL_FILL("remixal-install-fill", '\uee67'),
    INSTALL_LINE("remixal-install-line", '\uee68'),
    INVISION_FILL("remixal-invision-fill", '\uee69'),
    INVISION_LINE("remixal-invision-line", '\uee6a'),
    ITALIC("remixal-italic", '\uee6b'),
    KAKAO_TALK_FILL("remixal-kakao-talk-fill", '\uee6c'),
    KAKAO_TALK_LINE("remixal-kakao-talk-line", '\uee6d'),
    KEYBOARD_BOX_FILL("remixal-keyboard-box-fill", '\uee72'),
    KEYBOARD_BOX_LINE("remixal-keyboard-box-line", '\uee73'),
    KEYBOARD_FILL("remixal-keyboard-fill", '\uee74'),
    KEYBOARD_LINE("remixal-keyboard-line", '\uee75'),
    KEYNOTE_FILL("remixal-keynote-fill", '\uee76'),
    KEYNOTE_LINE("remixal-keynote-line", '\uee77'),
    KEY_2_FILL("remixal-key-2-fill", '\uee6e'),
    KEY_2_LINE("remixal-key-2-line", '\uee6f'),
    KEY_FILL("remixal-key-fill", '\uee70'),
    KEY_LINE("remixal-key-line", '\uee71'),
    KNIFE_BLOOD_FILL("remixal-knife-blood-fill", '\uee78'),
    KNIFE_BLOOD_LINE("remixal-knife-blood-line", '\uee79'),
    KNIFE_FILL("remixal-knife-fill", '\uee7a'),
    KNIFE_LINE("remixal-knife-line", '\uee7b'),
    LANDSCAPE_FILL("remixal-landscape-fill", '\uee7c'),
    LANDSCAPE_LINE("remixal-landscape-line", '\uee7d'),
    LAYOUT_2_FILL("remixal-layout-2-fill", '\uee7e'),
    LAYOUT_2_LINE("remixal-layout-2-line", '\uee7f'),
    LAYOUT_3_FILL("remixal-layout-3-fill", '\uee80'),
    LAYOUT_3_LINE("remixal-layout-3-line", '\uee81'),
    LAYOUT_4_FILL("remixal-layout-4-fill", '\uee82'),
    LAYOUT_4_LINE("remixal-layout-4-line", '\uee83'),
    LAYOUT_5_FILL("remixal-layout-5-fill", '\uee84'),
    LAYOUT_5_LINE("remixal-layout-5-line", '\uee85'),
    LAYOUT_6_FILL("remixal-layout-6-fill", '\uee86'),
    LAYOUT_6_LINE("remixal-layout-6-line", '\uee87'),
    LAYOUT_BOTTOM_2_FILL("remixal-layout-bottom-2-fill", '\uee88'),
    LAYOUT_BOTTOM_2_LINE("remixal-layout-bottom-2-line", '\uee89'),
    LAYOUT_BOTTOM_FILL("remixal-layout-bottom-fill", '\uee8a'),
    LAYOUT_BOTTOM_LINE("remixal-layout-bottom-line", '\uee8b'),
    LAYOUT_COLUMN_FILL("remixal-layout-column-fill", '\uee8c'),
    LAYOUT_COLUMN_LINE("remixal-layout-column-line", '\uee8d'),
    LAYOUT_FILL("remixal-layout-fill", '\uee8e'),
    LAYOUT_GRID_FILL("remixal-layout-grid-fill", '\uee8f'),
    LAYOUT_GRID_LINE("remixal-layout-grid-line", '\uee90'),
    LAYOUT_LEFT_2_FILL("remixal-layout-left-2-fill", '\uee91'),
    LAYOUT_LEFT_2_LINE("remixal-layout-left-2-line", '\uee92'),
    LAYOUT_LEFT_FILL("remixal-layout-left-fill", '\uee93'),
    LAYOUT_LEFT_LINE("remixal-layout-left-line", '\uee94'),
    LAYOUT_LINE("remixal-layout-line", '\uee95'),
    LAYOUT_MASONRY_FILL("remixal-layout-masonry-fill", '\uee96'),
    LAYOUT_MASONRY_LINE("remixal-layout-masonry-line", '\uee97'),
    LAYOUT_RIGHT_2_FILL("remixal-layout-right-2-fill", '\uee98'),
    LAYOUT_RIGHT_2_LINE("remixal-layout-right-2-line", '\uee99'),
    LAYOUT_RIGHT_FILL("remixal-layout-right-fill", '\uee9a'),
    LAYOUT_RIGHT_LINE("remixal-layout-right-line", '\uee9b'),
    LAYOUT_ROW_FILL("remixal-layout-row-fill", '\uee9c'),
    LAYOUT_ROW_LINE("remixal-layout-row-line", '\uee9d'),
    LAYOUT_TOP_2_FILL("remixal-layout-top-2-fill", '\uee9e'),
    LAYOUT_TOP_2_LINE("remixal-layout-top-2-line", '\uee9f'),
    LAYOUT_TOP_FILL("remixal-layout-top-fill", '\ueea0'),
    LAYOUT_TOP_LINE("remixal-layout-top-line", '\ueea1'),
    LEAF_FILL("remixal-leaf-fill", '\ueea2'),
    LEAF_LINE("remixal-leaf-line", '\ueea3'),
    LIFEBUOY_FILL("remixal-lifebuoy-fill", '\ueea4'),
    LIFEBUOY_LINE("remixal-lifebuoy-line", '\ueea5'),
    LIGHTBULB_FILL("remixal-lightbulb-fill", '\ueea6'),
    LIGHTBULB_FLASH_FILL("remixal-lightbulb-flash-fill", '\ueea7'),
    LIGHTBULB_FLASH_LINE("remixal-lightbulb-flash-line", '\ueea8'),
    LIGHTBULB_LINE("remixal-lightbulb-line", '\ueea9'),
    LINE_CHART_FILL("remixal-line-chart-fill", '\ueeaa'),
    LINE_CHART_LINE("remixal-line-chart-line", '\ueeab'),
    LINE_FILL("remixal-line-fill", '\ueeac'),
    LINE_HEIGHT("remixal-line-height", '\ueead'),
    LINE_LINE("remixal-line-line", '\ueeae'),
    LINK("remixal-link", '\ueeb2'),
    LINKEDIN_BOX_FILL("remixal-linkedin-box-fill", '\ueeb3'),
    LINKEDIN_BOX_LINE("remixal-linkedin-box-line", '\ueeb4'),
    LINKEDIN_FILL("remixal-linkedin-fill", '\ueeb5'),
    LINKEDIN_LINE("remixal-linkedin-line", '\ueeb6'),
    LINKS_FILL("remixal-links-fill", '\ueeb7'),
    LINKS_LINE("remixal-links-line", '\ueeb8'),
    LINK_M("remixal-link-m", '\ueeaf'),
    LINK_UNLINK("remixal-link-unlink", '\ueeb1'),
    LINK_UNLINK_M("remixal-link-unlink-m", '\ueeb0'),
    LIST_CHECK("remixal-list-check", '\ueeba'),
    LIST_CHECK_2("remixal-list-check-2", '\ueeb9'),
    LIST_ORDERED("remixal-list-ordered", '\ueebb'),
    LIST_SETTINGS_FILL("remixal-list-settings-fill", '\ueebc'),
    LIST_SETTINGS_LINE("remixal-list-settings-line", '\ueebd'),
    LIST_UNORDERED("remixal-list-unordered", '\ueebe'),
    LIVE_FILL("remixal-live-fill", '\ueebf'),
    LIVE_LINE("remixal-live-line", '\ueec0'),
    LOADER_2_FILL("remixal-loader-2-fill", '\ueec1'),
    LOADER_2_LINE("remixal-loader-2-line", '\ueec2'),
    LOADER_3_FILL("remixal-loader-3-fill", '\ueec3'),
    LOADER_3_LINE("remixal-loader-3-line", '\ueec4'),
    LOADER_4_FILL("remixal-loader-4-fill", '\ueec5'),
    LOADER_4_LINE("remixal-loader-4-line", '\ueec6'),
    LOADER_5_FILL("remixal-loader-5-fill", '\ueec7'),
    LOADER_5_LINE("remixal-loader-5-line", '\ueec8'),
    LOADER_FILL("remixal-loader-fill", '\ueec9'),
    LOADER_LINE("remixal-loader-line", '\ueeca'),
    LOCK_2_FILL("remixal-lock-2-fill", '\ueecb'),
    LOCK_2_LINE("remixal-lock-2-line", '\ueecc'),
    LOCK_FILL("remixal-lock-fill", '\ueecd'),
    LOCK_LINE("remixal-lock-line", '\ueece'),
    LOCK_PASSWORD_FILL("remixal-lock-password-fill", '\ueecf'),
    LOCK_PASSWORD_LINE("remixal-lock-password-line", '\ueed0'),
    LOCK_UNLOCK_FILL("remixal-lock-unlock-fill", '\ueed1'),
    LOCK_UNLOCK_LINE("remixal-lock-unlock-line", '\ueed2'),
    LOGIN_BOX_FILL("remixal-login-box-fill", '\ueed3'),
    LOGIN_BOX_LINE("remixal-login-box-line", '\ueed4'),
    LOGIN_CIRCLE_FILL("remixal-login-circle-fill", '\ueed5'),
    LOGIN_CIRCLE_LINE("remixal-login-circle-line", '\ueed6'),
    LOGOUT_BOX_FILL("remixal-logout-box-fill", '\ueed7'),
    LOGOUT_BOX_LINE("remixal-logout-box-line", '\ueed8'),
    LOGOUT_BOX_R_FILL("remixal-logout-box-r-fill", '\ueed9'),
    LOGOUT_BOX_R_LINE("remixal-logout-box-r-line", '\ueeda'),
    LOGOUT_CIRCLE_FILL("remixal-logout-circle-fill", '\ueedb'),
    LOGOUT_CIRCLE_LINE("remixal-logout-circle-line", '\ueedc'),
    LOGOUT_CIRCLE_R_FILL("remixal-logout-circle-r-fill", '\ueedd'),
    LOGOUT_CIRCLE_R_LINE("remixal-logout-circle-r-line", '\ueede'),
    LUGGAGE_CART_FILL("remixal-luggage-cart-fill", '\ueedf'),
    LUGGAGE_CART_LINE("remixal-luggage-cart-line", '\ueee0'),
    LUGGAGE_DEPOSIT_FILL("remixal-luggage-deposit-fill", '\ueee1'),
    LUGGAGE_DEPOSIT_LINE("remixal-luggage-deposit-line", '\ueee2'),
    LUNGS_FILL("remixal-lungs-fill", '\ueee3'),
    LUNGS_LINE("remixal-lungs-line", '\ueee4');

    public static RemixiconAL findByDescription(String description) {
        for (RemixiconAL font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    RemixiconAL(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}