/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.Collections;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;
import org.keycloak.services.clientpolicy.executor.ConfidentialClientAcceptExecutor;

public class ConfidentialClientAcceptExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "confidential-client";

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new ConfidentialClientAcceptExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "On authorization endpoint and token endpoint, this executor checks whether the client is confidential client. If not, it denies its request.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }
}

