/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.representations.account.DeviceRepresentation;
import org.keycloak.utils.SecureContextResolver;

public class SecureContextResolverTest {
    static DeviceRepresentation DEVICE_UNKOWN = new DeviceRepresentation();
    static DeviceRepresentation DEVICE_SAFARI;

    @Test
    public void testHttps() {
        this.assertSecureContext("https://127.0.0.1", true);
        this.assertSecureContext("https://something", true);
    }

    @Test
    public void testIp4() {
        this.assertSecureContext("http://127.0.0.1", true);
        this.assertSecureContext("http://127.0.0.128", true);
        this.assertSecureContext("http://127.0.0.255", true);
        this.assertSecureContext("http://127.0.0.256", false);
        this.assertSecureContext("http://127.0.1.1", true);
        this.assertSecureContext("http://127.254.232.123", true);
        this.assertSecureContext("http://127.256.232.123", false);
        this.assertSecureContext("http://10.0.0.10", false);
        this.assertSecureContext("http://127.0.0.1.nip.io", false);
    }

    @Test
    public void testIp6() {
        this.assertSecureContext("http://[::1]", true);
        this.assertSecureContext("http://[0000:0000:0000:0000:0000:0000:0000:0001]", true);
        this.assertSecureContext("http://[0:0:0:0:0:0:0:1]", true);
        this.assertSecureContext("http://[0:0:0::1]", true);
        this.assertSecureContext("http://[::2]", false);
        this.assertSecureContext("http://[2001:0000:130F:0000:0000:09C0:876A:130B]", false);
        this.assertSecureContext("http://::1", false);
        this.assertSecureContext("http://[FE80:0000:130F:0000:0000:09C0:876A:130B]", false);
    }

    @Test
    public void testLocalhost() {
        this.assertSecureContext("http://localhost", true);
        this.assertSecureContext("http://localhost.", true);
        this.assertSecureContext("http://localhostn", false);
        this.assertSecureContext("http://test.localhost", true);
        this.assertSecureContext("http://test.localhost.", true);
        this.assertSecureContext("http://test.localhostn", false);
        this.assertSecureContext("http://test.localhost.not", false);
    }

    @Test
    public void testIsLocalhost() {
        Assert.assertTrue((boolean)SecureContextResolver.isLocalAddress((String)"127.0.0.1"));
        Assert.assertFalse((boolean)SecureContextResolver.isLocalAddress((String)"not.an.ip"));
        Assert.assertFalse((boolean)SecureContextResolver.isLocalAddress(null));
        Assert.assertFalse((boolean)SecureContextResolver.isLocalAddress((String)""));
        Assert.assertTrue((boolean)SecureContextResolver.isLocalAddress((String)"::1"));
        Assert.assertTrue((boolean)SecureContextResolver.isLocalAddress((String)"0:0:0:0:0:0:0:1"));
    }

    @Test
    public void testQuirksSafari() {
        this.assertSecureContext("https://127.0.0.1", DEVICE_SAFARI, true);
        this.assertSecureContext("https://something", DEVICE_SAFARI, true);
        this.assertSecureContext("http://[::1]", DEVICE_SAFARI, false);
        this.assertSecureContext("http://[0000:0000:0000:0000:0000:0000:0000:0001]", DEVICE_SAFARI, false);
        this.assertSecureContext("http://localhost", DEVICE_SAFARI, false);
        this.assertSecureContext("http://localhost.", DEVICE_SAFARI, false);
        this.assertSecureContext("http://test.localhost", DEVICE_SAFARI, false);
        this.assertSecureContext("http://test.localhost.", DEVICE_SAFARI, false);
    }

    @Test
    public void testNoDeviceRepresentation() {
        this.assertSecureContext("http://localhost", null, true);
    }

    void assertSecureContext(String url, boolean expectedSecureContext) {
        this.assertSecureContext(url, DEVICE_UNKOWN, expectedSecureContext);
    }

    void assertSecureContext(String url, DeviceRepresentation deviceRepresentation, boolean expectedSecureContext) {
        Supplier<DeviceRepresentation> deviceRepresentationSupplier = () -> deviceRepresentation;
        try {
            Assert.assertEquals((Object)expectedSecureContext, (Object)SecureContextResolver.isSecureContext((URI)new URI(url), deviceRepresentationSupplier));
        }
        catch (URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    static {
        DEVICE_UNKOWN.setBrowser("Unknown");
        DEVICE_SAFARI = new DeviceRepresentation();
        DEVICE_SAFARI.setBrowser("Safari/18.0.1");
    }
}

