/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;

public class ResponseTypeTest {
    @Test
    public void testResponseTypes() {
        this.assertFail(null);
        this.assertFail("");
        this.assertFail("foo");
        this.assertSuccess("code");
        this.assertSuccess("none");
        this.assertSuccess("id_token");
        this.assertSuccess("token");
        this.assertFail("refresh_token");
        this.assertSuccess("id_token token");
        this.assertSuccess("code token");
        this.assertSuccess("code id_token");
        this.assertSuccess("code id_token token");
        this.assertFail("code none");
        this.assertFail("code refresh_token");
    }

    @Test
    public void testMultipleResponseTypes() {
        OIDCResponseType responseType = OIDCResponseType.parse(Arrays.asList("code", "token"));
        Assert.assertTrue((boolean)responseType.hasResponseType("code"));
        Assert.assertFalse((boolean)responseType.hasResponseType("none"));
        Assert.assertTrue((boolean)responseType.isImplicitOrHybridFlow());
        Assert.assertFalse((boolean)responseType.isImplicitFlow());
        responseType = OIDCResponseType.parse(Collections.singletonList("code"));
        Assert.assertTrue((boolean)responseType.hasResponseType("code"));
        Assert.assertFalse((boolean)responseType.hasResponseType("none"));
        Assert.assertFalse((boolean)responseType.isImplicitOrHybridFlow());
        responseType = OIDCResponseType.parse(Arrays.asList("code", "none"));
        Assert.assertTrue((boolean)responseType.hasResponseType("code"));
        Assert.assertTrue((boolean)responseType.hasResponseType("none"));
        Assert.assertFalse((boolean)responseType.isImplicitOrHybridFlow());
        responseType = OIDCResponseType.parse(Arrays.asList("code", "code token"));
        Assert.assertTrue((boolean)responseType.hasResponseType("code"));
        Assert.assertFalse((boolean)responseType.hasResponseType("none"));
        Assert.assertTrue((boolean)responseType.hasResponseType("token"));
        Assert.assertFalse((boolean)responseType.hasResponseType("id_token"));
        Assert.assertTrue((boolean)responseType.isImplicitOrHybridFlow());
        Assert.assertFalse((boolean)responseType.isImplicitFlow());
        responseType = OIDCResponseType.parse(Arrays.asList("id_token", "id_token token"));
        Assert.assertFalse((boolean)responseType.hasResponseType("code"));
        Assert.assertTrue((boolean)responseType.isImplicitOrHybridFlow());
        Assert.assertTrue((boolean)responseType.isImplicitFlow());
    }

    private void assertSuccess(String responseType) {
        OIDCResponseType.parse((String)responseType);
    }

    private void assertFail(String responseType) {
        try {
            OIDCResponseType.parse((String)responseType);
            Assert.fail((String)("Not expected to parse '" + responseType + "' with success"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

