/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.web.servlet;

import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import org.jboss.weld.Container;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.BeanManagers;
import org.jboss.weld.module.web.context.http.HttpSessionDestructionContext;

public class WeldTerminalListener
implements HttpSessionListener {
    @Inject
    private volatile BeanManagerImpl beanManager;

    public WeldTerminalListener() {
    }

    public WeldTerminalListener(BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
    }

    @Override
    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        ServletContext ctx = event.getSession().getServletContext();
        if (this.beanManager == null) {
            WeldTerminalListener weldTerminalListener = this;
            synchronized (weldTerminalListener) {
                String contextId;
                if (this.beanManager == null && (contextId = ctx.getInitParameter("WELD_CONTEXT_ID_KEY")) != null) {
                    ArrayList<BeanManagerImpl> managers = new ArrayList<BeanManagerImpl>(Container.instance(contextId).beanDeploymentArchives().values());
                    Collections.sort(managers, BeanManagers.ID_COMPARATOR);
                    this.beanManager = (BeanManagerImpl)managers.get(0);
                }
                if (this.beanManager == null) {
                    this.beanManager = BeanManagerProxy.unwrap(CDI.current().getBeanManager());
                }
            }
        }
        if (!this.getSessionContext().isActive()) {
            HttpSessionDestructionContext context = this.getHttpSessionDestructionContext();
            context.associate(event.getSession());
            context.activate();
        }
    }

    private HttpSessionContext getSessionContext() {
        return (HttpSessionContext)this.beanManager.instance().select(HttpSessionContext.class, new Annotation[0]).get();
    }

    private HttpSessionDestructionContext getHttpSessionDestructionContext() {
        return (HttpSessionDestructionContext)this.beanManager.instance().select(HttpSessionDestructionContext.class, new Annotation[0]).get();
    }
}

