/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.tomcat;

import org.jboss.weld.environment.servlet.AbstractContainer;
import org.jboss.weld.environment.servlet.Container;
import org.jboss.weld.environment.servlet.ContainerContext;
import org.jboss.weld.environment.servlet.EnhancedListener;
import org.jboss.weld.environment.servlet.logging.TomcatLogger;
import org.jboss.weld.environment.tomcat.WeldForwardingInstanceManager;

public class TomcatContainer
extends AbstractContainer {
    public static final Container INSTANCE = new TomcatContainer();
    private static final String TOMCAT_REQUIRED_CLASS_NAME = "org.apache.catalina.connector.Request";

    @Override
    protected String classToCheck() {
        return TOMCAT_REQUIRED_CLASS_NAME;
    }

    @Override
    public void initialize(ContainerContext context) {
        try {
            WeldForwardingInstanceManager.replaceInstanceManager(context.getServletContext(), context.getManager());
            if (Boolean.TRUE.equals(context.getServletContext().getAttribute(EnhancedListener.ENHANCED_LISTENER_USED_ATTRIBUTE_NAME))) {
                TomcatLogger.LOG.allInjectionsAvailable();
            } else {
                TomcatLogger.LOG.listenersInjectionsNotAvailable();
            }
        }
        catch (Exception e) {
            TomcatLogger.LOG.unableToReplaceTomcat(e);
        }
    }
}

