/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.configurator;

import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.configurator.InjectionPointConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.bootstrap.events.configurator.Configurator;
import org.jboss.weld.util.Preconditions;

public class InjectionPointConfiguratorImpl
implements InjectionPointConfigurator,
Configurator<InjectionPoint> {
    private Type requiredType;
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();
    private Bean<?> bean;
    private boolean isDelegate;
    private boolean isTransient;
    private Member member;
    private Annotated annotated;

    public InjectionPointConfiguratorImpl() {
    }

    public InjectionPointConfiguratorImpl(InjectionPoint injectionPoint) {
        this();
        this.read(injectionPoint);
    }

    public InjectionPointConfigurator read(InjectionPoint injectionPoint) {
        this.bean = injectionPoint.getBean();
        this.type(injectionPoint.getType());
        this.qualifiers(injectionPoint.getQualifiers());
        this.delegate(injectionPoint.isDelegate());
        this.transientField(injectionPoint.isTransient());
        this.member(injectionPoint.getMember());
        this.annotated(injectionPoint.getAnnotated());
        return this;
    }

    @Override
    public InjectionPointConfigurator type(Type type) {
        Preconditions.checkArgumentNotNull(type);
        this.requiredType = type;
        return this;
    }

    @Override
    public InjectionPointConfigurator addQualifier(Annotation qualifier) {
        Preconditions.checkArgumentNotNull(qualifier);
        this.qualifiers.remove(Default.Literal.INSTANCE);
        this.qualifiers.add(qualifier);
        return this;
    }

    @Override
    public InjectionPointConfigurator addQualifiers(Annotation ... qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        this.qualifiers.remove(Default.Literal.INSTANCE);
        Collections.addAll(this.qualifiers, qualifiers);
        return this;
    }

    @Override
    public InjectionPointConfigurator addQualifiers(Set<Annotation> qualifiers) {
        Preconditions.checkArgumentNotNull(qualifiers);
        this.qualifiers.remove(Default.Literal.INSTANCE);
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    @Override
    public InjectionPointConfigurator qualifiers(Annotation ... qualifiers) {
        this.qualifiers.clear();
        return this.addQualifiers(qualifiers);
    }

    @Override
    public InjectionPointConfigurator qualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.clear();
        return this.addQualifiers(qualifiers);
    }

    @Override
    public InjectionPointConfigurator delegate(boolean delegate) {
        this.isDelegate = delegate;
        return this;
    }

    @Override
    public InjectionPointConfigurator transientField(boolean trans) {
        this.isTransient = trans;
        return this;
    }

    public InjectionPointConfigurator member(Member member) {
        this.member = member;
        return this;
    }

    public InjectionPointConfigurator annotated(Annotated annotated) {
        this.annotated = annotated;
        return this;
    }

    @Override
    public InjectionPoint complete() {
        return new ImmutableInjectionPoint(this);
    }

    static class ImmutableInjectionPoint
    implements InjectionPoint {
        private final Type requiredType;
        private final Set<Annotation> qualifiers;
        private final Bean<?> bean;
        private final boolean isDelegate;
        private final boolean isTransient;
        private final Member member;
        private final Annotated annotated;

        private ImmutableInjectionPoint(InjectionPointConfiguratorImpl configurator) {
            this.requiredType = configurator.requiredType;
            this.qualifiers = configurator.qualifiers;
            this.bean = configurator.bean;
            this.isDelegate = configurator.isDelegate;
            this.isTransient = configurator.isTransient;
            this.member = configurator.member;
            this.annotated = configurator.annotated;
        }

        @Override
        public Type getType() {
            return this.requiredType;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        @Override
        public Bean<?> getBean() {
            return this.bean;
        }

        @Override
        public Member getMember() {
            return this.member;
        }

        @Override
        public Annotated getAnnotated() {
            return this.annotated;
        }

        @Override
        public boolean isDelegate() {
            return this.isDelegate;
        }

        @Override
        public boolean isTransient() {
            return this.isTransient;
        }

        public String toString() {
            return "InjectionPoint with type=" + this.requiredType + ", qualifiers=" + this.qualifiers + ", delegate=" + this.isDelegate + ", transient=" + this.isTransient + ".";
        }
    }
}

