/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeContext;
import org.jboss.weld.bootstrap.MissingDependenciesRegistry;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

class AnnotatedTypeLoader {
    final ResourceLoader resourceLoader;
    final ClassTransformer classTransformer;
    final MissingDependenciesRegistry missingDependenciesRegistry;
    final ContainerLifecycleEvents containerLifecycleEvents;
    static final String MODULEINFO_CLASS_NAME = "module-info";
    static final String MULTI_RELEASE_JAR_PATH = "META-INF.versions";

    AnnotatedTypeLoader(BeanManagerImpl manager, ClassTransformer transformer, ContainerLifecycleEvents containerLifecycleEvents) {
        this.resourceLoader = manager.getServices().get(ResourceLoader.class);
        this.classTransformer = transformer;
        this.missingDependenciesRegistry = manager.getServices().get(MissingDependenciesRegistry.class);
        this.containerLifecycleEvents = containerLifecycleEvents;
    }

    public <T> SlimAnnotatedTypeContext<T> loadAnnotatedType(String className, String bdaId) {
        return this.loadAnnotatedType(this.loadClass(className), bdaId);
    }

    public <T> SlimAnnotatedTypeContext<T> loadAnnotatedType(Class<T> clazz, String bdaId) {
        return this.createContext(this.internalLoadAnnotatedType(clazz, bdaId));
    }

    protected <T> Class<T> loadClass(String className) {
        if (this.isModuleInfo(className) || this.isMultiReleaseJarClass(className)) {
            return null;
        }
        try {
            return (Class)Reflections.cast(this.resourceLoader.classForName(className));
        }
        catch (ResourceLoadingException e) {
            this.missingDependenciesRegistry.handleResourceLoadingException(className, e);
            return null;
        }
    }

    protected <T> SlimAnnotatedType<T> internalLoadAnnotatedType(Class<T> clazz, String bdaId) {
        if (!(clazz == null || clazz.isAnnotation() || clazz.isAnonymousClass() || clazz.isLocalClass())) {
            try {
                if (!Beans.isVetoed(clazz)) {
                    this.containerLifecycleEvents.preloadProcessAnnotatedType(clazz);
                    try {
                        return this.classTransformer.getBackedAnnotatedType(clazz, bdaId);
                    }
                    catch (ResourceLoadingException e) {
                        this.missingDependenciesRegistry.handleResourceLoadingException(clazz.getName(), e);
                    }
                }
            }
            catch (ArrayStoreException e) {
                this.missingDependenciesRegistry.handleResourceLoadingException(clazz.getName(), e);
            }
        }
        return null;
    }

    protected <T> SlimAnnotatedTypeContext<T> createContext(SlimAnnotatedType<T> type) {
        if (type != null) {
            return SlimAnnotatedTypeContext.of(type);
        }
        return null;
    }

    protected boolean isModuleInfo(String className) {
        return MODULEINFO_CLASS_NAME.equals(className);
    }

    protected boolean isMultiReleaseJarClass(String className) {
        return className.startsWith(MULTI_RELEASE_JAR_PATH);
    }
}

