/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.ReferenceJType;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.StaticRefJExpr;
import org.jboss.jdeparser.Tokens$;

class PrimitiveJType
extends AbstractJType {
    private final String simpleName;
    private final ReferenceJType boxed;
    private StaticRefJExpr classExpr;

    PrimitiveJType(String simpleName, String boxed) {
        this.simpleName = simpleName;
        this.boxed = boxed == null ? null : new ReferenceJType("java.lang", boxed, this);
    }

    @Override
    public JType box() {
        return this.boxed;
    }

    @Override
    void writeDirect(SourceFileWriter sourceFileWriter) throws IOException {
        switch (this.simpleName) {
            case "boolean": {
                sourceFileWriter.write(Tokens$.KW.BOOLEAN);
                return;
            }
            case "byte": {
                sourceFileWriter.write(Tokens$.KW.BYTE);
                return;
            }
            case "short": {
                sourceFileWriter.write(Tokens$.KW.SHORT);
                return;
            }
            case "int": {
                sourceFileWriter.write(Tokens$.KW.INT);
                return;
            }
            case "long": {
                sourceFileWriter.write(Tokens$.KW.LONG);
                return;
            }
            case "char": {
                sourceFileWriter.write(Tokens$.KW.CHAR);
                return;
            }
            case "float": {
                sourceFileWriter.write(Tokens$.KW.FLOAT);
                return;
            }
            case "double": {
                sourceFileWriter.write(Tokens$.KW.DOUBLE);
                return;
            }
            case "void": {
                sourceFileWriter.write(Tokens$.KW.VOID);
                return;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public JExpr _class() {
        StaticRefJExpr expr = this.classExpr;
        if (expr == null) {
            expr = this.classExpr = new StaticRefJExpr(this, "class");
        }
        return expr;
    }

    @Override
    boolean equals(AbstractJType other) {
        return other instanceof PrimitiveJType && this.simpleName.equals(((PrimitiveJType)other).simpleName);
    }

    @Override
    public int hashCode() {
        return this.simpleName.hashCode();
    }

    @Override
    public String simpleName() {
        return this.simpleName;
    }

    @Override
    public String toString() {
        return this.simpleName;
    }
}

