/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.util.LinkedHashMap;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.jboss.jdeparser.CachingThreadLocal;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.ReferenceJType;

public final class JTypes {
    static final ThreadLocal<LinkedHashMap<String, JType>> cache = new CachingThreadLocal<String, JType>();

    private JTypes() {
    }

    public static JType $t(JClassDef classDef) {
        return JTypes.typeOf(classDef);
    }

    public static JType $t(Class<?> clazz) {
        return JTypes.typeOf(clazz);
    }

    public static JType $t(String name) {
        return JTypes.typeNamed(name);
    }

    public static JType typeOf(JClassDef classDef) {
        return classDef.erasedType();
    }

    public static JType typeOf(Class<?> clazz) {
        Class<?> enclosingClass = clazz.getEnclosingClass();
        if (enclosingClass != null) {
            return JTypes.$t(enclosingClass).$t(clazz.getSimpleName());
        }
        return JTypes.$t(clazz.getName());
    }

    public static JType typeNamed(String name) {
        if (name.endsWith("[]")) {
            return JTypes.typeNamed(name.substring(0, name.length() - 2)).array();
        }
        LinkedHashMap<String, JType> map = cache.get();
        JType type = map.get(name);
        if (type == null) {
            int idx = name.lastIndexOf(46);
            type = new ReferenceJType(idx == -1 ? "" : name.substring(0, idx), name.substring(idx + 1));
            map.put(name, type);
        }
        return type;
    }

    public static JType typeOf(TypeMirror typeMirror) {
        if (typeMirror instanceof ArrayType) {
            return JTypes.typeOf(((ArrayType)typeMirror).getComponentType()).array();
        }
        if (typeMirror instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)typeMirror;
            TypeMirror extendsBound = wildcardType.getExtendsBound();
            TypeMirror superBound = wildcardType.getSuperBound();
            return extendsBound != null ? JTypes.typeOf(extendsBound).wildcardExtends() : (superBound != null ? JTypes.typeOf(superBound).wildcardSuper() : JType.WILDCARD);
        }
        if (typeMirror instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)typeMirror;
            String name = typeVariable.asElement().getSimpleName().toString();
            return JTypes.typeNamed(name);
        }
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            TypeMirror enclosingType = declaredType.getEnclosingType();
            if (enclosingType != null && enclosingType.getKind() == TypeKind.DECLARED) {
                return JTypes.typeOf(enclosingType).nestedType(typeElement.getSimpleName().toString());
            }
            String name = typeElement.getQualifiedName().toString();
            JType rawType = JTypes.typeNamed(name);
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.isEmpty()) {
                return rawType;
            }
            JType[] args = new JType[typeArguments.size()];
            for (int i = 0; i < typeArguments.size(); ++i) {
                TypeMirror argument = typeArguments.get(i);
                args[i] = JTypes.typeOf(argument);
            }
            return rawType.typeArg(args);
        }
        if (typeMirror instanceof NoType) {
            switch (typeMirror.getKind()) {
                case VOID: {
                    return JType.VOID;
                }
            }
        } else if (typeMirror instanceof PrimitiveType) {
            switch (typeMirror.getKind()) {
                case BOOLEAN: {
                    return JType.BOOLEAN;
                }
                case BYTE: {
                    return JType.BYTE;
                }
                case SHORT: {
                    return JType.SHORT;
                }
                case INT: {
                    return JType.INT;
                }
                case LONG: {
                    return JType.LONG;
                }
                case CHAR: {
                    return JType.CHAR;
                }
                case FLOAT: {
                    return JType.FLOAT;
                }
                case DOUBLE: {
                    return JType.DOUBLE;
                }
            }
        }
        throw new IllegalArgumentException(String.format("Cannot find equivalent type to %s", typeMirror));
    }
}

