/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.BasicJBlock;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JMod;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class ForEachJBlock
extends BasicJBlock {
    private final int mods;
    private final JType type;
    private final String name;
    private final JExpr iterable;

    ForEachJBlock(BasicJBlock parent, int mods, JType type, String name, JExpr iterable) {
        super(parent, JBlock.Braces.IF_MULTILINE);
        this.mods = mods;
        this.type = type;
        this.name = name;
        this.iterable = iterable;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        this.writeComments(writer);
        writer.write(Tokens$.KW.FOR);
        writer.write(FormatPreferences.Space.BEFORE_PAREN_FOR);
        writer.write(Tokens$.PUNCT.PAREN.OPEN);
        writer.write(FormatPreferences.Space.WITHIN_PAREN_FOR);
        JMod.write(writer, this.mods);
        writer.write(this.type);
        writer.sp();
        writer.writeEscaped(this.name);
        writer.write(FormatPreferences.Space.BEFORE_COLON);
        writer.write(Tokens$.PUNCT.COLON);
        writer.write(FormatPreferences.Space.AFTER_COLON);
        writer.write(this.iterable);
        writer.write(FormatPreferences.Space.WITHIN_PAREN_FOR);
        writer.write(Tokens$.PUNCT.PAREN.CLOSE);
        super.write(writer, FormatPreferences.Space.BEFORE_BRACE_FOR);
    }
}

