/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.settings.Repository;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependency;
import org.jboss.shrinkwrap.resolver.impl.maven.ArtifactAsKey;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.Validate;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.Exclusion;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.artifact.DefaultArtifactType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenConverter {
    private static final Logger log = Logger.getLogger(MavenConverter.class.getName());
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?(:([^: ]+))?");
    private static final int DEPENDENCY_GROUP_ID = 1;
    private static final int DEPENDENCY_ARTIFACT_ID = 2;
    private static final int DEPENDENCY_TYPE_ID = 4;
    private static final int DEPENDENCY_CLASSIFIER_ID = 6;
    private static final int DEPENDENCY_VERSION_ID = 8;
    private static final Pattern EXCLUSION_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?");
    private static final int EXCLUSION_GROUP_ID = 1;
    private static final int EXCLUSION_ARTIFACT_ID = 2;
    private static final int EXCLUSION_TYPE_ID = 4;
    private static final int EXCLUSION_CLASSIFIER_ID = 6;

    private MavenConverter() {
        throw new AssertionError((Object)"Utility class MavenConverter cannot be instantiated.");
    }

    public static String resolveArtifactVersion(Map<ArtifactAsKey, MavenDependency> dependencyManagement, String coordinates) {
        Matcher m = DEPENDENCY_PATTERN.matcher(coordinates);
        if (!m.matches()) {
            throw new ResolutionException("Bad artifact coordinates, expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]][:<version>]");
        }
        ArtifactAsKey key = new ArtifactAsKey(m.group(1), m.group(2), m.group(4), m.group(6));
        if (m.group(8) == null && dependencyManagement.containsKey(key)) {
            String version = MavenConverter.asArtifact(dependencyManagement.get(key).getCoordinates()).getVersion();
            log.fine("Resolved version " + version + " from the POM file for the artifact: " + coordinates);
            coordinates = coordinates + ":" + version;
        }
        return coordinates;
    }

    public static Dependency asDependency(MavenDependency dependency) {
        return new Dependency(MavenConverter.asArtifact(dependency.getCoordinates()), dependency.getScope(), dependency.isOptional(), MavenConverter.asExclusions(Arrays.asList(dependency.getExclusions())));
    }

    public static List<Dependency> asDependencies(List<MavenDependency> dependencies) {
        ArrayList<Dependency> list = new ArrayList<Dependency>(dependencies.size());
        for (MavenDependency d : dependencies) {
            list.add(MavenConverter.asDependency(d));
        }
        return list;
    }

    public static Artifact asArtifact(String coordinates) throws ResolutionException {
        try {
            return new DefaultArtifact(coordinates);
        }
        catch (IllegalArgumentException e) {
            throw new ResolutionException("Unable to create artifact from coordinates " + coordinates + ", " + "they are either invalid or version information was not specified in loaded POM file (maybe the POM file wasn't load at all)", (Throwable)e);
        }
    }

    public static Exclusion asExclusion(String coordinates) {
        Validate.notNull(coordinates, "Exclusion string must not be null");
        if (coordinates.length() == 0 || coordinates.equals("*")) {
            return new Exclusion("*", "*", "*", "*");
        }
        Matcher m = EXCLUSION_PATTERN.matcher(coordinates);
        if (!m.matches()) {
            throw new ResolutionException("Bad exclusion coordinates, expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]");
        }
        String group = m.group(1);
        String artifact = m.group(2);
        String type = m.group(4);
        String classifier = m.group(6);
        group = group == null || group.length() == 0 ? "*" : group;
        artifact = artifact == null || artifact.length() == 0 ? "*" : artifact;
        type = type == null || type.length() == 0 ? "*" : type;
        classifier = classifier == null || classifier.length() == 0 ? "*" : classifier;
        return new Exclusion(group, artifact, classifier, type);
    }

    public static List<Exclusion> asExclusions(Collection<String> coordinates) {
        ArrayList<Exclusion> list = new ArrayList<Exclusion>(coordinates.size());
        for (String coords : coordinates) {
            list.add(MavenConverter.asExclusion(coords));
        }
        return list;
    }

    public static String fromExclusion(org.apache.maven.model.Exclusion exclusion) {
        StringBuilder sb = new StringBuilder();
        sb.append(exclusion.getGroupId()).append(":");
        sb.append(exclusion.getArtifactId());
        return sb.toString();
    }

    public static String fromExclusion(Exclusion exclusion) {
        String classifier;
        StringBuilder sb = new StringBuilder();
        sb.append(exclusion.getGroupId()).append(":");
        sb.append(exclusion.getArtifactId());
        String type = exclusion.getExtension();
        if (type != null && type.length() != 0) {
            sb.append(":").append(type);
        }
        if ((classifier = exclusion.getClassifier()) != null && classifier.length() != 0) {
            sb.append(":").append(classifier);
        }
        return sb.toString();
    }

    public static Collection<String> fromExclusions(Collection<Exclusion> exclusions) {
        ArrayList<String> list = new ArrayList<String>(exclusions.size());
        for (Exclusion e : exclusions) {
            list.add(MavenConverter.fromExclusion(e));
        }
        return list;
    }

    public static String fromArtifact(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId()).append(":");
        sb.append(artifact.getArtifactId()).append(":");
        String extension = artifact.getExtension();
        sb.append(extension.length() == 0 ? "jar" : extension).append(":");
        String classifier = artifact.getClassifier();
        if (classifier.length() != 0) {
            sb.append(classifier).append(":");
        }
        sb.append(artifact.getVersion());
        return sb.toString();
    }

    public static MavenDependency fromDependency(Dependency dependency) {
        MavenDependencyImpl result = new MavenDependencyImpl(MavenConverter.fromArtifact(dependency.getArtifact()));
        result.setOptional(dependency.isOptional());
        result.setScope(dependency.getScope());
        result.addExclusions(MavenConverter.fromExclusions(dependency.getExclusions()).toArray(new String[0]));
        return result;
    }

    public static MavenDependency fromDependency(org.apache.maven.model.Dependency dependency, ArtifactTypeRegistry registry) {
        ArtifactType stereotype = registry.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<String> exclusions = new ArrayList<String>();
        for (org.apache.maven.model.Exclusion e : dependency.getExclusions()) {
            exclusions.add(MavenConverter.fromExclusion(e));
        }
        MavenDependencyImpl result = new MavenDependencyImpl(MavenConverter.fromArtifact((Artifact)artifact));
        result.setOptional(dependency.isOptional());
        result.setScope(dependency.getScope());
        result.addExclusions(exclusions.toArray(new String[0]));
        return result;
    }

    public static RemoteRepository asRemoteRepository(org.apache.maven.model.Repository repository) {
        return new RemoteRepository().setId(repository.getId()).setContentType(repository.getLayout()).setUrl(repository.getUrl()).setPolicy(true, MavenConverter.asRepositoryPolicy(repository.getSnapshots())).setPolicy(false, MavenConverter.asRepositoryPolicy(repository.getReleases()));
    }

    public static RemoteRepository asRemoteRepository(Repository repository) {
        return new RemoteRepository().setId(repository.getId()).setContentType(repository.getLayout()).setUrl(repository.getUrl()).setPolicy(true, MavenConverter.asRepositoryPolicy(repository.getSnapshots())).setPolicy(false, MavenConverter.asRepositoryPolicy(repository.getReleases()));
    }

    private static org.sonatype.aether.repository.RepositoryPolicy asRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new org.sonatype.aether.repository.RepositoryPolicy(enabled, updates, checksums);
    }

    private static org.sonatype.aether.repository.RepositoryPolicy asRepositoryPolicy(org.apache.maven.settings.RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new org.sonatype.aether.repository.RepositoryPolicy(enabled, updates, checksums);
    }
}

