/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.support.IdMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.ee.IdMetaDataParser;
import org.jboss.metadata.parser.servlet.Attribute;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.servlet.OrderingMetaDataParser;
import org.jboss.metadata.parser.servlet.Version;
import org.jboss.metadata.parser.servlet.WebCommonMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.web.spec.WebFragmentMetaData;

public class WebFragmentMetaDataParser
extends MetaDataElementParser {
    public static WebFragmentMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        reader.require(7, null, null);
        while (reader.hasNext() && reader.next() != 1) {
        }
        WebFragmentMetaData wmd = new WebFragmentMetaData();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (WebFragmentMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSION: {
                    wmd.setVersion(value);
                    continue block9;
                }
                case METADATA_COMPLETE: {
                    if (!Boolean.TRUE.equals(Boolean.valueOf(value))) continue block9;
                    wmd.setMetadataComplete(true);
                    continue block9;
                }
                default: {
                    IdMetaDataParser.parseAttribute((XMLStreamReader)reader, (int)i, (IdMetaData)wmd);
                }
            }
        }
        Version version = Optional.ofNullable(wmd.getVersion()).map(Version::fromString).orElse(Version.LATEST);
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        EnvironmentRefsGroupMetaData env = new EnvironmentRefsGroupMetaData();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            if (WebCommonMetaDataParser.parse(reader, version, wmd, propertyReplacer)) continue;
            if (EnvironmentRefsGroupMetaDataParser.parse((XMLStreamReader)reader, (EnvironmentRefsGroupMetaData)env, (PropertyReplacer)propertyReplacer)) {
                if (wmd.getJndiEnvironmentRefsGroup() != null) continue;
                wmd.setJndiEnvironmentRefsGroup(env);
                continue;
            }
            if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)descriptionGroup)) {
                if (wmd.getDescriptionGroup() != null) continue;
                wmd.setDescriptionGroup(descriptionGroup);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    wmd.setName(WebFragmentMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block10;
                }
                case ORDERING: {
                    wmd.setOrdering(OrderingMetaDataParser.parse(reader, propertyReplacer));
                    continue block10;
                }
            }
            throw WebFragmentMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return wmd;
    }
}

