/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.osgi.parser.Namespace;
import org.jboss.as.osgi.parser.Namespace11;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class OSGiNamespace11Parser
implements Namespace11,
XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    static XMLElementReader<List<ModelNode>> INSTANCE = new OSGiNamespace11Parser();

    private OSGiNamespace11Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "osgi");
        address.protect();
        ModelNode activation = this.parseActivationAttribute(reader, address);
        operations.add(activation);
        while (reader.hasNext() && reader.nextTag() != 2) {
            block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_1: {
                    Namespace11.Element element = Namespace11.Element.forName(reader.getLocalName());
                    switch (element) {
                        case CONFIGURATION: {
                            List<ModelNode> result = this.parseConfigurations(reader, address);
                            operations.addAll(result);
                            break block0;
                        }
                        case PROPERTIES: {
                            List<ModelNode> result = this.parseFrameworkProperties(reader, address, operations);
                            operations.addAll(result);
                            break block0;
                        }
                        case CAPABILITIES: {
                            List<ModelNode> result = this.parseCapabilities(reader, address);
                            operations.addAll(result);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    private ModelNode parseActivationAttribute(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        ModelNode result = new ModelNode();
        result.get("operation").set("add");
        result.get("address").set(address);
        switch (Namespace.forUri(reader.getNamespaceURI())) {
            case OSGI_1_1: {
                int count = reader.getAttributeCount();
                block6: for (int i = 0; i < count; ++i) {
                    ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                    String attrValue = reader.getAttributeValue(i);
                    Namespace11.Attribute attribute = Namespace11.Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case ACTIVATION: {
                            result.get("activation").set(attrValue);
                            continue block6;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
        return result;
    }

    private List<ModelNode> parseConfigurations(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        String pid = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            Namespace11.Attribute attribute = Namespace11.Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PID: {
                    pid = attrValue;
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (pid == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Namespace11.Attribute.PID));
        }
        ModelNode configuration = new ModelNode();
        configuration.get("operation").set("add");
        configuration.get("address").set(address).add("configuration", pid);
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        result.add(configuration);
        ModelNode propNode = configuration.get("entries");
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_1: {
                    Namespace11.Element element = Namespace11.Element.forName(reader.getLocalName());
                    if (element == Namespace11.Element.PROPERTY) {
                        String name = null;
                        String value = null;
                        count = reader.getAttributeCount();
                        block12: for (int i = 0; i < count; ++i) {
                            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                            String attrValue = reader.getAttributeValue(i);
                            Namespace11.Attribute attribute = Namespace11.Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = attrValue;
                                    continue block12;
                                }
                                case VALUE: {
                                    value = attrValue;
                                    continue block12;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Namespace11.Attribute.NAME));
                        }
                        if (value == null) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Namespace11.Attribute.VALUE));
                        }
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        propNode.get(name).set(value);
                        continue block11;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return result;
    }

    private List<ModelNode> parseFrameworkProperties(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_1: {
                    Namespace11.Element element = Namespace11.Element.forName(reader.getLocalName());
                    if (element == Namespace11.Element.PROPERTY) {
                        String name = null;
                        String value = null;
                        int count = reader.getAttributeCount();
                        block7: for (int i = 0; i < count; ++i) {
                            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                            String attrValue = reader.getAttributeValue(i);
                            Namespace11.Attribute attribute = Namespace11.Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = attrValue;
                                    continue block7;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Namespace11.Attribute.NAME));
                        }
                        value = reader.getElementText().trim();
                        ModelNode propNode = new ModelNode();
                        propNode.get("operation").set("add");
                        propNode.get("address").set(address).add("property", name);
                        propNode.get("value").set(value);
                        result.add(propNode);
                        continue block6;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return result;
    }

    private List<ModelNode> parseCapabilities(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        ArrayList<ModelNode> nodes = new ArrayList<ModelNode>();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case OSGI_1_1: {
                    Namespace11.Element element = Namespace11.Element.forName(reader.getLocalName());
                    if (element == Namespace11.Element.CAPABILITY) {
                        String name = null;
                        String start = null;
                        int count = reader.getAttributeCount();
                        block8: for (int i = 0; i < count; ++i) {
                            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                            Namespace11.Attribute attribute = Namespace11.Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    name = reader.getAttributeValue(i);
                                    continue block8;
                                }
                                case STARTLEVEL: {
                                    start = reader.getAttributeValue(i);
                                    continue block8;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Namespace11.Attribute.NAME));
                        }
                        ModelNode moduleNode = new ModelNode();
                        moduleNode.get("operation").set("add");
                        moduleNode.get("address").set(address).add("capability", name);
                        if (start != null) {
                            moduleNode.get("startlevel").set(start);
                        }
                        nodes.add(moduleNode);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        continue block7;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return nodes;
    }
}

