/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jmx.model.NameConverter;

class ChildAddOperationFinder {
    ChildAddOperationFinder() {
    }

    static Map<PathElement, ChildAddOperationEntry> findAddChildOperations(ImmutableManagementResourceRegistration resourceRegistration) {
        HashMap<PathElement, ChildAddOperationEntry> operations = new HashMap<PathElement, ChildAddOperationEntry>();
        for (PathElement childElement : resourceRegistration.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            ImmutableManagementResourceRegistration childReg = resourceRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{childElement}));
            Map registeredOps = childReg.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, false);
            OperationEntry childAdd = (OperationEntry)registeredOps.get("add");
            if (childAdd == null) continue;
            operations.put(childElement, new ChildAddOperationEntry(childAdd, childElement));
        }
        return operations;
    }

    static ChildAddOperationEntry findAddChildOperation(ImmutableManagementResourceRegistration resourceRegistration, String addName) {
        for (PathElement childElement : resourceRegistration.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            ImmutableManagementResourceRegistration childReg = resourceRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{childElement}));
            Map registeredOps = childReg.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, false);
            OperationEntry childAdd = (OperationEntry)registeredOps.get("add");
            if (childAdd == null || !NameConverter.createValidAddOperationName(childElement).equals(addName)) continue;
            return new ChildAddOperationEntry(childAdd, childElement);
        }
        return null;
    }

    static class ChildAddOperationEntry {
        private final OperationEntry op;
        private final PathElement element;

        public ChildAddOperationEntry(OperationEntry op, PathElement element) {
            this.op = op;
            this.element = element;
        }

        public OperationEntry getOperationEntry() {
            return this.op;
        }

        public PathElement getElement() {
            return this.element;
        }
    }
}

