/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Iterator;
import java.util.Set;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformerExpressionResolver;
import org.jboss.dmr.ModelNode;

class ResourceTransformationContextImpl
implements ResourceTransformationContext {
    private final Resource root;
    private final PathAddress current;
    private final OriginalModel originalModel;

    static ResourceTransformationContext create(OperationContext context, TransformationTarget target) {
        Resource root = Resource.Factory.create();
        Resource original = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true);
        ImmutableManagementResourceRegistration registration = context.getRootResourceRegistration().getSubModel(PathAddress.EMPTY_ADDRESS);
        ExpressionResolver expressionResolver = TransformerExpressionResolver.create(context, target.getTargetType());
        OriginalModel originalModel = new OriginalModel(original, context.getRunningMode(), context.getProcessType(), target, registration, expressionResolver);
        return new ResourceTransformationContextImpl(root, PathAddress.EMPTY_ADDRESS, originalModel);
    }

    static ResourceTransformationContext create(TransformationTarget target, Resource model, ImmutableManagementResourceRegistration registration, ExpressionResolver resolver, RunningMode runningMode, ProcessType type) {
        Resource root = Resource.Factory.create();
        OriginalModel originalModel = new OriginalModel(model, runningMode, type, target, registration, resolver);
        return new ResourceTransformationContextImpl(root, PathAddress.EMPTY_ADDRESS, originalModel);
    }

    ResourceTransformationContextImpl(Resource root, PathAddress address, OriginalModel originalModel) {
        this.root = root;
        this.current = address;
        this.originalModel = originalModel;
    }

    public Resource createResource(PathAddress element) {
        PathAddress absoluteAddress = this.current.append(element);
        Resource resource = Resource.Factory.create();
        this.addTransformedRecursiveResourceFromRoot(absoluteAddress, resource);
        return resource;
    }

    public Resource createResource(PathAddress element, Resource copy) {
        PathAddress absoluteAddress = this.current.append(element);
        Resource resource = Resource.Factory.create();
        resource.writeModel(copy.getModel());
        this.addTransformedRecursiveResourceFromRoot(absoluteAddress, resource);
        return resource;
    }

    @Override
    public ResourceTransformationContext addTransformedResource(PathAddress address, Resource toAdd) {
        PathAddress absoluteAddress = this.current.append(address);
        return this.addTransformedResourceFromRoot(absoluteAddress, toAdd);
    }

    @Override
    public ResourceTransformationContext addTransformedResourceFromRoot(PathAddress absoluteAddress, Resource toAdd) {
        Resource copy = Resource.Factory.create();
        if (toAdd != null) {
            copy.writeModel(toAdd.getModel());
        }
        return this.addTransformedRecursiveResourceFromRoot(absoluteAddress, copy);
    }

    @Override
    public void addTransformedRecursiveResource(PathAddress relativeAddress, Resource resource) {
        PathAddress absoluteAddress = this.current.append(relativeAddress);
        this.addTransformedRecursiveResourceFromRoot(absoluteAddress, resource);
    }

    public ResourceTransformationContext addTransformedRecursiveResourceFromRoot(PathAddress absoluteAddress, Resource toAdd) {
        Resource model = this.root;
        Iterator i = absoluteAddress.iterator();
        while (i.hasNext()) {
            PathElement element = (PathElement)i.next();
            if (element.isMultiTarget()) {
                throw ControllerMessages.MESSAGES.cannotWriteTo("*");
            }
            if (!i.hasNext()) {
                if (model.hasChild(element)) {
                    throw ControllerMessages.MESSAGES.duplicateResourceAddress(absoluteAddress);
                }
                model.registerChild(element, toAdd);
                model = toAdd;
                continue;
            }
            if ((model = model.getChild(element)) != null) continue;
            PathAddress ancestor = PathAddress.EMPTY_ADDRESS;
            for (PathElement pe : absoluteAddress) {
                ancestor = ancestor.append(pe);
                if (!element.equals(pe)) continue;
                break;
            }
            throw ControllerMessages.MESSAGES.resourceNotFound(ancestor, absoluteAddress);
        }
        return new ResourceTransformationContextImpl(this.root, absoluteAddress, this.originalModel);
    }

    @Override
    public ResourceTransformer resolveTransformer(PathAddress address) {
        ResourceTransformer transformer = this.originalModel.target.resolveTransformer(address);
        if (transformer == null) {
            ImmutableManagementResourceRegistration childReg = this.originalModel.getRegistration(address);
            if (childReg == null) {
                return ResourceTransformer.DISCARD;
            }
            if (childReg.isRemote() || childReg.isRuntimeOnly()) {
                return ResourceTransformer.DISCARD;
            }
            return ResourceTransformer.DEFAULT;
        }
        return transformer;
    }

    @Override
    public void processChildren(Resource resource) throws OperationFailedException {
        Set<String> types = resource.getChildTypes();
        for (String type : types) {
            for (Resource.ResourceEntry child : resource.getChildren(type)) {
                this.processChild(child.getPathElement(), child);
            }
        }
    }

    @Override
    public void processChild(PathElement element, Resource child) throws OperationFailedException {
        PathAddress childAddress = this.current.append(element);
        ResourceTransformer transformer = this.resolveTransformer(childAddress);
        ResourceTransformationContextImpl childContext = new ResourceTransformationContextImpl(this.root, childAddress, this.originalModel);
        transformer.transformResource(childContext, childAddress, child);
    }

    @Override
    public TransformationTarget getTarget() {
        return this.originalModel.target;
    }

    @Override
    public ProcessType getProcessType() {
        return this.originalModel.type;
    }

    @Override
    public RunningMode getRunningMode() {
        return this.originalModel.mode;
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistration(PathAddress address) {
        PathAddress a = this.current.append(address);
        return this.originalModel.getRegistration(a);
    }

    @Override
    public ImmutableManagementResourceRegistration getResourceRegistrationFromRoot(PathAddress address) {
        return this.originalModel.getRegistration(address);
    }

    @Override
    public Resource readResource(PathAddress address) {
        PathAddress a = this.current.append(address);
        return this.originalModel.get(a);
    }

    @Override
    public Resource readResourceFromRoot(PathAddress address) {
        return this.originalModel.get(address);
    }

    @Override
    public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.originalModel.expressionResolver.resolveExpressions(node);
    }

    @Override
    public Resource getTransformedRoot() {
        return this.root;
    }

    static class OriginalModel {
        private final Resource original;
        private final RunningMode mode;
        private final ProcessType type;
        private final TransformationTarget target;
        private final ImmutableManagementResourceRegistration registration;
        private final ExpressionResolver expressionResolver;

        OriginalModel(Resource original, RunningMode mode, ProcessType type, TransformationTarget target, ImmutableManagementResourceRegistration registration, ExpressionResolver expressionResolver) {
            this.original = original;
            this.mode = mode;
            this.type = type;
            this.target = target;
            this.registration = registration;
            this.expressionResolver = expressionResolver;
        }

        Resource get(PathAddress address) {
            return this.original.navigate(address);
        }

        ImmutableManagementResourceRegistration getRegistration(PathAddress address) {
            return this.registration.getSubModel(address);
        }
    }
}

