/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.resource;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.MaskedAddressValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ClientMappingsAttributeDefinition
extends ListAttributeDefinition {
    public static final ParameterValidator validator;
    public static final ParameterValidator fieldValidator;

    public ClientMappingsAttributeDefinition(String name) {
        super(name, name, true, 0, Integer.MAX_VALUE, validator, null, null, AttributeAccess.Flag.RESTART_ALL_SERVICES);
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
        throw new UnsupportedOperationException("Use the ResourceDescriptionResolver variant");
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueType = this.getNoTextValueTypeDescription(node);
        valueType.get(new String[]{"source-network", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, "source-network"));
        valueType.get(new String[]{"destination-address", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, "destination-address"));
        valueType.get(new String[]{"destination-port", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, "destination-port"));
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueType = this.getNoTextValueTypeDescription(node);
        valueType.get(new String[]{"source-network", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, "source-network"));
        valueType.get(new String[]{"destination-address", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, "destination-address"));
        valueType.get(new String[]{"destination-port", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, "destination-port"));
    }

    @Override
    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private ModelNode getNoTextValueTypeDescription(ModelNode parent) {
        ModelNode valueType = parent.get("value-type");
        ModelNode sourceNetwork = valueType.get("source-network");
        sourceNetwork.get("description");
        sourceNetwork.get("type").set(ModelType.STRING);
        sourceNetwork.get("nillable").set(true);
        sourceNetwork.get("min-length").set(1);
        ModelNode destination = valueType.get("destination-address");
        destination.get("description");
        destination.get("type").set(ModelType.STRING);
        destination.get("nillable").set(false);
        destination.get("min-length").set(1);
        ModelNode port = valueType.get("destination-port");
        port.get("description");
        port.get("type").set(ModelType.INT);
        port.get("nillable").set(true);
        port.get("min").set(0);
        port.get("max").set(65535);
        return valueType;
    }

    static {
        ParametersValidator delegate = new ParametersValidator();
        delegate.registerValidator("source-network", new MaskedAddressValidator(true, false));
        delegate.registerValidator("destination-address", new StringLengthValidator(1));
        delegate.registerValidator("destination-port", new IntRangeValidator(0, 65535, true, false));
        validator = new ParametersOfValidator(delegate);
        fieldValidator = delegate;
    }
}

