/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.protocol.jmx;

import java.util.HashSet;
import java.util.Set;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.as.arquillian.protocol.jmx.JMXProtocolAS7;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;

public class ArquillianServiceDeployer {
    private static final Logger log = Logger.getLogger(ArquillianServiceDeployer.class);
    private Set<String> serviceArchiveDeployed = new HashSet<String>();

    public synchronized void doServiceDeploy(@Observes BeforeDeploy event, Container container, JMXProtocolAS7.ServiceArchiveHolder archiveHolder) {
        if (this.serviceArchiveDeployed.contains(container.getName())) {
            return;
        }
        if (archiveHolder.deploymentExistsAndRemove(event.getDeployment().getTestableArchive())) {
            Archive<?> serviceArchive = archiveHolder.getArchive();
            try {
                log.infof("Deploy arquillian service: %s", serviceArchive);
                DeployableContainer deployableContainer = container.getDeployableContainer();
                deployableContainer.deploy(serviceArchive);
                this.serviceArchiveDeployed.add(container.getName());
            }
            catch (Throwable th) {
                log.error((Object)"Cannot deploy arquillian service", th);
            }
        }
    }

    public synchronized void undeploy(@Observes BeforeStop event, Container container, JMXProtocolAS7.ServiceArchiveHolder archiveHolder) {
        if (this.serviceArchiveDeployed.contains(container.getName())) {
            try {
                Archive<?> serviceArchive = archiveHolder.getArchive();
                log.infof("Undeploy arquillian service: %s", serviceArchive);
                DeployableContainer deployableContainer = container.getDeployableContainer();
                deployableContainer.undeploy(serviceArchive);
                this.serviceArchiveDeployed.remove(container.getName());
            }
            catch (Throwable th) {
                log.error((Object)"Cannot undeploy arquillian service", th);
            }
        }
    }
}

