/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class PollingFileInputStream
extends FilterInputStream {
    private AtomicBoolean done;

    PollingFileInputStream(InputStream in, AtomicBoolean done) {
        super(in);
        this.done = done;
    }

    @Override
    public int read() throws IOException {
        int i = this.in.read();
        while (i == -1 && !this.done.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            i = this.in.read();
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = this.in.read(b, off, len);
        while (i == -1 && !this.done.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            i = this.in.read(b, off, len);
        }
        return i;
    }
}

