/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.container;

import java.util.Map;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.container.test.impl.client.container.command.KillContainerCommand;
import org.jboss.arquillian.container.test.impl.client.container.command.StartContainerCommand;
import org.jboss.arquillian.container.test.impl.client.container.command.StopContainerCommand;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandService;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerContainerController
implements ContainerController {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public void start(String containerQualifier) {
        this.getCommandService().execute((Command)new StartContainerCommand(containerQualifier));
    }

    public void start(String containerQualifier, Map<String, String> config) {
        this.getCommandService().execute((Command)new StartContainerCommand(containerQualifier, config));
    }

    public void stop(String containerQualifier) {
        this.getCommandService().execute((Command)new StopContainerCommand(containerQualifier));
    }

    public void kill(String containerQualifier) {
        this.getCommandService().execute((Command)new KillContainerCommand(containerQualifier));
    }

    private CommandService getCommandService() {
        ServiceLoader loader = (ServiceLoader)this.serviceLoader.get();
        if (loader == null) {
            throw new IllegalStateException("No " + ServiceLoader.class.getName() + " found in context");
        }
        CommandService service = (CommandService)loader.onlyOne(CommandService.class);
        if (service == null) {
            throw new IllegalStateException("No " + CommandService.class.getName() + " found in context");
        }
        return service;
    }
}

