/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.string;

import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.logging.Log;
import org.infinispan.server.resp.serialization.Resp3Response;

public class MSETNX
extends RespCommand
implements Resp3Command {
    public MSETNX() {
        super(-3, 1, -1, 2);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        if (arguments.size() < 2 || arguments.size() % 2 != 0) {
            RespErrorUtil.wrongArgumentNumber(this, handler.allocator());
            return handler.myStage();
        }
        Log.SERVER.msetnxConsistencyMessage();
        HashMap<WrappedByteArray, byte[]> entriesWBA = new HashMap<WrappedByteArray, byte[]>();
        for (int i = 0; i < arguments.size(); ++i) {
            entriesWBA.put(new WrappedByteArray(arguments.get(i)), arguments.get(++i));
        }
        Map<byte[], byte[]> entries = entriesWBA.entrySet().stream().collect(Collectors.toMap(e -> ((WrappedByteArray)e.getKey()).getBytes(), Map.Entry::getValue));
        Map existingEntries = handler.cache().getAll(entriesWBA.keySet());
        if (existingEntries.isEmpty()) {
            return handler.stageToReturn(handler.cache().putAllAsync(entries).thenApply(v -> 1L), ctx, Resp3Response.INTEGER);
        }
        return handler.stageToReturn(CompletableFuture.completedFuture(0L), ctx, Resp3Response.INTEGER);
    }
}

