/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.Attribute;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.counter.configuration.CounterParser;
import org.infinispan.counter.configuration.Element;
import org.infinispan.counter.configuration.Reliability;
import org.infinispan.counter.logging.Log;

@Namespaces(value={@Namespace(root="counters"), @Namespace(uri="urn:infinispan:config:counters:*", root="counters", since="9.0")})
public class CounterConfigurationParser
extends CounterParser {
    @Override
    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        if (!holder.inScope((Enum)ParserScope.CACHE_CONTAINER)) {
            throw Log.CONTAINER.invalidScope(holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        if (element != Element.COUNTERS) {
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
        this.parseCountersElement(reader, (CounterManagerConfigurationBuilder)builder.addModule(CounterManagerConfigurationBuilder.class));
    }

    @Override
    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, AbstractCounterConfiguration> parseConfigurations(InputStream is) throws IOException {
        BufferedInputStream input = new BufferedInputStream(is);
        ConfigurationReader reader = ConfigurationReader.from((InputStream)input).build();
        CounterManagerConfigurationBuilder builder = new CounterManagerConfigurationBuilder(null);
        try {
            reader.require(ConfigurationReader.ElementType.START_DOCUMENT);
            reader.nextElement();
            reader.require(ConfigurationReader.ElementType.START_ELEMENT);
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.COUNTERS) {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
            this.parseCountersElement(reader, builder);
        }
        finally {
            Util.close((AutoCloseable)reader);
        }
        return builder.create().counters();
    }

    private void parseCountersElement(ConfigurationReader reader, CounterManagerConfigurationBuilder builder) {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NUM_OWNERS: {
                    builder.numOwner(Integer.parseInt(value));
                    continue block4;
                }
                case RELIABILITY: {
                    builder.reliability(Reliability.valueOf(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        if (reader.hasFeature(ConfigurationFormatFeature.MIXED_ELEMENTS)) {
            while (reader.inTag()) {
                Map.Entry item = reader.getMapItem((Enum)Attribute.NAME);
                this.readElement(reader, builder, Element.forName((String)item.getValue()), (String)item.getKey());
                reader.endMapItem();
            }
        } else {
            reader.nextElement();
            reader.require(ConfigurationReader.ElementType.START_ELEMENT, null, (Enum)Element.COUNTERS);
            while (reader.inTag()) {
                Map.Entry item = reader.getMapItem((Enum)Attribute.NAME);
                this.readElement(reader, builder, Element.forName((String)item.getValue()), (String)item.getKey());
                reader.endMapItem();
            }
            reader.nextElement();
            reader.require(ConfigurationReader.ElementType.END_ELEMENT, null, (Enum)Element.COUNTERS);
        }
    }
}

