/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Collections;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.immutables.value.processor.meta.BuilderMirrors;

public class FParameterMirror
implements BuilderMirrors.FParameter {
    public static final String QUALIFIED_NAME = "org.immutables.builder.Builder.Parameter";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.processor.meta.BuilderMirrors.FParameter";
    private final AnnotationMirror annotationMirror;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Parameter";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Optional<FParameterMirror> find(Element element) {
        return FParameterMirror.find(element.getAnnotationMirrors());
    }

    public static Optional<FParameterMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return Optional.of((Object)new FParameterMirror(annotationMirror));
        }
        return Optional.absent();
    }

    public static ImmutableList<FParameterMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Preconditions.checkState((boolean)element.getQualifiedName().contentEquals(QUALIFIED_NAME), (Object)"Supplied mirrors should all be of this annotation type");
            builder.add((Object)new FParameterMirror(annotationMirror));
        }
        return builder.build();
    }

    public static FParameterMirror from(TypeElement element) {
        return new FParameterMirror(element);
    }

    public static Optional<FParameterMirror> from(AnnotationMirror mirror) {
        return FParameterMirror.find(Collections.singleton(mirror));
    }

    private FParameterMirror(TypeElement defaultAnnotationElement) {
        Preconditions.checkArgument((defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME) ? 1 : 0) != 0);
        this.annotationMirror = null;
    }

    private FParameterMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
    }

    public AnnotationMirror getAnnotationMirror() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return BuilderMirrors.FParameter.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        return h;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof FParameterMirror) {
            FParameterMirror otherMirror = (FParameterMirror)other;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "FParameterMirror:" + this.annotationMirror;
    }
}

