/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Inherited;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.immutables.generator.AbstractTemplate;
import org.immutables.generator.Generator;
import org.immutables.generator.Templates;
import org.immutables.value.processor.meta.HasStyleInfo;
import org.immutables.value.processor.meta.LongBits;
import org.immutables.value.processor.meta.ObscureFeatures;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.StyleInfo;
import org.immutables.value.processor.meta.UnshadeGuava;
import org.immutables.value.processor.meta.ValueAttribute;
import org.immutables.value.processor.meta.ValueType;

public abstract class AbstractValuesTemplate
extends AbstractTemplate {
    @Generator.Typedef
    protected ValueType Type;
    @Generator.Typedef
    protected ValueAttribute Attribute;
    @Generator.Typedef
    protected HasStyleInfo HasStyleInfo;
    @Generator.Typedef
    protected LongBits.LongPositions LongPositions;
    @Generator.Typedef
    protected LongBits.BitPosition BitPosition;
    @Generator.Typedef
    protected Proto.DeclaringPackage Package;
    protected final ImmutableList<ValueAttribute> noAttributes = ImmutableList.of();
    protected final String guava = UnshadeGuava.prefix();
    protected final LongBits longsFor = new LongBits();
    protected final Function<Object, String> asDiamond = new Function<Object, String>(){

        public String apply(Object input) {
            return ObscureFeatures.noDiamonds() ? "<" + input + ">" : "<>";
        }
    };
    @Nullable
    private String jaxartaPackage;
    private static final String JAKARTA_NULLABLE = "jakarta.annotation.Nullable";
    protected final Function<Object, String> docEscaped = new Function<Object, String>(){

        public String apply(Object input) {
            return input.toString().replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;").replace("java.lang.", "").replace("java.util.", "");
        }
    };
    protected final Templates.Binary<HasStyleInfo, String, Boolean> allowsClasspathAnnotation = (hasStyle, annotationClass) -> {
        StyleInfo style = hasStyle.style();
        this.setJaxartaFrom(style);
        if (annotationClass.startsWith(CLASSNAME_TAG_JAXARTA)) {
            annotationClass = annotationClass.replace(CLASSNAME_TAG_JAXARTA, this.jaxarta());
        }
        return (style.allowedClasspathAnnotationsNames().isEmpty() || style.allowedClasspathAnnotationsNames().contains(annotationClass)) && this.classpath.available.apply(annotationClass);
    };
    protected final Function<HasStyleInfo, String> atFallbackNullable = input -> {
        String annotation = input.style().fallbackNullableAnnotationName();
        if (annotation.equals(Inherited.class.getCanonicalName())) {
            this.setJaxartaFrom(input.style());
            String defaultNullable = this.jaxarta() + ".annotation.Nullable";
            annotation = (Boolean)this.allowsClasspathAnnotation.apply(input, (Object)defaultNullable) != false ? defaultNullable : "";
        }
        return !annotation.isEmpty() ? "@" + annotation + " " : "";
    };
    protected final Flag flag = new Flag();
    protected static final String CLASSNAME_TAG_JAXARTA = "[jaxarta]";

    protected final void setJaxarta(String jaxartaPackage) {
        this.jaxartaPackage = jaxartaPackage;
    }

    public final String jaxarta() {
        return this.jaxartaPackage != null ? this.jaxartaPackage : (this.inferJaxarta() ? "jakarta" : "javax");
    }

    protected boolean inferJaxarta() {
        return this.classpath.available.apply((Object)JAKARTA_NULLABLE);
    }

    private void setJaxartaFrom(StyleInfo style) {
        this.jaxartaPackage = style.jakarta() ? "jakarta" : "javax";
    }

    public TrackingSet newTrackingSet() {
        return new TrackingSet();
    }

    protected static class Flag {
        public boolean is;

        protected Flag() {
        }

        public String set() {
            this.is = true;
            return "";
        }

        public String clear() {
            this.is = false;
            return "";
        }
    }

    public static class TrackingSet {
        private final HashSet<Object> set = new HashSet();
        public final Predicate<Object> add = new Predicate<Object>(){

            public boolean apply(@Nullable Object input) {
                return set.add(input);
            }
        };
        public final Predicate<Object> includes = new Predicate<Object>(){

            public boolean apply(@Nullable Object input) {
                return set.contains(input);
            }
        };
        public final Predicate<Object> excludes = new Predicate<Object>(){

            public boolean apply(@Nullable Object input) {
                return !set.contains(input);
            }
        };
    }
}

