/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.functions;

import org.htmlunit.xpath.Expression;
import org.htmlunit.xpath.XPathVisitor;
import org.htmlunit.xpath.functions.Function3Args;
import org.htmlunit.xpath.functions.WrongNumberArgsException;
import org.htmlunit.xpath.res.XPATHMessages;

public class FunctionMultiArgs
extends Function3Args {
    Expression[] args_;

    @Override
    public void setArg(Expression arg, int argNum) throws WrongNumberArgsException {
        if (argNum < 3) {
            super.setArg(arg, argNum);
        } else {
            if (null == this.args_) {
                this.args_ = new Expression[1];
                this.args_[0] = arg;
            } else {
                Expression[] args = new Expression[this.args_.length + 1];
                System.arraycopy(this.args_, 0, args, 0, this.args_.length);
                args[this.args_.length] = arg;
                this.args_ = args;
            }
            arg.exprSetParent(this);
        }
    }

    @Override
    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
    }

    @Override
    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        String fMsg = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{"Programmer's assertion:  the method FunctionMultiArgs.reportWrongNumberArgs() should never be called."});
        throw new RuntimeException(fMsg);
    }

    @Override
    public boolean canTraverseOutsideSubtree() {
        if (super.canTraverseOutsideSubtree()) {
            return true;
        }
        for (Expression arg : this.args_) {
            if (!arg.canTraverseOutsideSubtree()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void callArgVisitors(XPathVisitor visitor) {
        super.callArgVisitors(visitor);
        if (null != this.args_) {
            for (Expression arg : this.args_) {
                arg.callVisitors(visitor);
            }
        }
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        FunctionMultiArgs fma = (FunctionMultiArgs)expr;
        if (null != this.args_) {
            int n = this.args_.length;
            if (null == fma || fma.args_.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.args_[i].deepEquals(fma.args_[i])) continue;
                return false;
            }
        } else if (null != fma.args_) {
            return false;
        }
        return true;
    }
}

