/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.mapper.pojo.logging.impl.IndexingLog;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategyConfigurationContext;
import org.hibernate.search.mapper.pojo.work.SearchIndexingPlanExecutionReport;
import org.hibernate.search.util.common.annotation.Incubating;
import org.hibernate.search.util.common.impl.Futures;

@Incubating
public final class WriteSyncIndexingPlanSynchronizationStrategy
implements IndexingPlanSynchronizationStrategy {
    public static final IndexingPlanSynchronizationStrategy INSTANCE = new WriteSyncIndexingPlanSynchronizationStrategy();

    private WriteSyncIndexingPlanSynchronizationStrategy() {
    }

    public String toString() {
        return IndexingPlanSynchronizationStrategy.class.getSimpleName() + ".writeSync()";
    }

    @Override
    public void apply(IndexingPlanSynchronizationStrategyConfigurationContext context) {
        context.documentCommitStrategy(DocumentCommitStrategy.FORCE);
        context.documentRefreshStrategy(DocumentRefreshStrategy.NONE);
        context.indexingFutureHandler(future -> {
            SearchIndexingPlanExecutionReport report = (SearchIndexingPlanExecutionReport)Futures.unwrappedExceptionJoin((CompletableFuture)future);
            report.throwable().ifPresent(t -> {
                throw IndexingLog.INSTANCE.indexingFailure(t.getMessage(), report.failingEntities(), (Throwable)t);
            });
        });
    }
}

