/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.projection.internal;

import java.util.Map;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.EntityInstantiator;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.projection.AuditProjection;

public class EntityAuditProjection
implements AuditProjection {
    private final String alias;
    private final boolean distinct;

    public EntityAuditProjection(String alias, boolean distinct) {
        this.alias = alias;
        this.distinct = distinct;
    }

    @Override
    public String getAlias(String baseAlias) {
        return this.alias == null ? baseAlias : this.alias;
    }

    @Override
    public void addProjectionToQuery(EnversService enversService, AuditReaderImplementor auditReader, Map<String, String> aliasToEntityNameMap, Map<String, String> aliasToComponentPropertyNameMap, String baseAlias, QueryBuilder queryBuilder) {
        String projectionEntityAlias = this.getAlias(baseAlias);
        queryBuilder.addProjection(null, projectionEntityAlias, null, this.distinct);
    }

    @Override
    public Object convertQueryResult(EnversService enversService, EntityInstantiator entityInstantiator, String entityName, Number revision, Object value) {
        Object result = enversService.getEntitiesConfigurations().isVersioned(entityName) ? entityInstantiator.createInstanceFromVersionsEntity(entityName, (Map)value, revision) : value;
        return result;
    }
}

