/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotTargetMapping;
import com.oracle.truffle.polyglot.TargetMappingNode;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.ToHostNodeGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=TargetMappingNode.class)
final class TargetMappingNodeGen
extends TargetMappingNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private CachedData cached_cache;

    private TargetMappingNodeGen() {
    }

    @Override
    Object execute(Object arg0Value, Class<?> arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value) {
        int state = this.state_;
        if (state != 0) {
            CachedData s1_;
            if ((state & 1) != 0 && (s1_ = this.cached_cache) != null && arg1Value != null) {
                return this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.mappings_, s1_.mappingNodes_);
            }
            if ((state & 2) != 0) {
                return this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value, Class<?> arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0 && arg1Value != null) {
                CachedData s1_ = super.insert(new CachedData());
                s1_.mappings_ = TargetMappingNode.getMappings(arg2Value, arg1Value);
                s1_.mappingNodes_ = (TargetMappingNode.SingleMappingNode[])s1_.insertAccessor(TargetMappingNode.createMappingNodes(s1_.mappings_));
                this.cached_cache = s1_;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.mappings_, s1_.mappingNodes_);
                return object;
            }
            this.exclude_ = exclude |= 1;
            this.cached_cache = null;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            Object object = this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static TargetMappingNode create() {
        return new TargetMappingNodeGen();
    }

    public static TargetMappingNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=TargetMappingNode.SingleMappingNode.class)
    static final class SingleMappingNodeGen
    extends TargetMappingNode.SingleMappingNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_;
        @Node.Child
        private DefaultData default_cache;

        private SingleMappingNodeGen() {
        }

        @Override
        Object execute(Object arg0Value, PolyglotTargetMapping arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value) {
            DefaultData s1_;
            int state = this.state_;
            if (state != 0 && (s1_ = this.default_cache) != null) {
                return this.doDefault(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.acceptsProfile_, s1_.allowsImplementation_, s1_.toHostRecursive_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arg0Value, PolyglotTargetMapping arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                DefaultData s1_ = super.insert(new DefaultData());
                s1_.acceptsProfile_ = ConditionProfile.create();
                s1_.allowsImplementation_ = TargetMappingNode.SingleMappingNode.allowsImplementation(arg2Value, arg1Value.sourceType);
                s1_.toHostRecursive_ = s1_.insertAccessor(ToHostNodeGen.create());
                this.default_cache = s1_;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.doDefault(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.acceptsProfile_, s1_.allowsImplementation_, s1_.toHostRecursive_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public static TargetMappingNode.SingleMappingNode create() {
            return new SingleMappingNodeGen();
        }

        public static TargetMappingNode.SingleMappingNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TargetMappingNode.SingleMappingNode.class)
        private static final class Uncached
        extends TargetMappingNode.SingleMappingNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            Object execute(Object arg0Value, PolyglotTargetMapping arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value) {
                return this.doDefault(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, ConditionProfile.getUncached(), TargetMappingNode.SingleMappingNode.allowsImplementation(arg2Value, arg1Value.sourceType), ToHostNodeGen.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TargetMappingNode.SingleMappingNode.class)
        private static final class DefaultData
        extends Node {
            @CompilerDirectives.CompilationFinal
            ConditionProfile acceptsProfile_;
            @CompilerDirectives.CompilationFinal
            boolean allowsImplementation_;
            @Node.Child
            ToHostNode toHostRecursive_;

            DefaultData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }
        }
    }

    @GeneratedBy(value=TargetMappingNode.class)
    private static final class Uncached
    extends TargetMappingNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        Object execute(Object arg0Value, Class<?> arg1Value, PolyglotLanguageContext arg2Value, InteropLibrary arg3Value, boolean arg4Value) {
            return this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=TargetMappingNode.class)
    private static final class CachedData
    extends Node {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        PolyglotTargetMapping[] mappings_;
        @Node.Children
        TargetMappingNode.SingleMappingNode[] mappingNodes_;

        CachedData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T[] insertAccessor(T[] node) {
            return super.insert(node);
        }
    }
}

