/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.polyglot.EngineAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;

final class InstrumentCache {
    private static final List<InstrumentCache> nativeImageCache = TruffleOptions.AOT ? new ArrayList() : null;
    private static Map<List<EngineAccessor.AbstractClassLoaderSupplier>, List<InstrumentCache>> runtimeCaches = new HashMap<List<EngineAccessor.AbstractClassLoaderSupplier>, List<InstrumentCache>>();
    private final String className;
    private final String id;
    private final String name;
    private final String version;
    private final boolean internal;
    private final Set<String> services;
    private final InstrumentReflection instrumentReflection;

    private static void initializeNativeImageState(ClassLoader imageClassLoader) {
        nativeImageCache.addAll(InstrumentCache.doLoad(Arrays.asList(new EngineAccessor.StrongClassLoaderSupplier(imageClassLoader))));
    }

    private static void resetNativeImageState() {
        nativeImageCache.clear();
        runtimeCaches.clear();
    }

    private InstrumentCache(String id, String name, String version, String className, boolean internal, Set<String> services, InstrumentReflection instrumentReflection) {
        this.instrumentReflection = instrumentReflection;
        this.id = id;
        this.name = name;
        this.version = version;
        this.className = className;
        this.internal = internal;
        this.services = services;
        if (TruffleOptions.AOT) {
            instrumentReflection.aotInitializeAtBuildTime();
        }
    }

    public boolean isInternal() {
        return this.internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<InstrumentCache> load() {
        if (TruffleOptions.AOT) {
            return nativeImageCache;
        }
        Class<InstrumentCache> clazz = InstrumentCache.class;
        synchronized (InstrumentCache.class) {
            List<EngineAccessor.AbstractClassLoaderSupplier> classLoaders = EngineAccessor.locatorOrDefaultLoaders();
            List<InstrumentCache> cache = runtimeCaches.get(classLoaders);
            if (cache == null) {
                cache = InstrumentCache.doLoad(classLoaders);
                runtimeCaches.put(classLoaders, cache);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    static List<InstrumentCache> doLoad(List<EngineAccessor.AbstractClassLoaderSupplier> suppliers) {
        ArrayList<InstrumentCache> list = new ArrayList<InstrumentCache>();
        HashSet classNamesUsed = new HashSet();
        for (Supplier supplier : suppliers) {
            Loader.load((ClassLoader)supplier.get(), list, classNamesUsed);
        }
        Collections.sort(list, new Comparator<InstrumentCache>(){

            @Override
            public int compare(InstrumentCache o1, InstrumentCache o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        return list;
    }

    String getId() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    String getClassName() {
        return this.className;
    }

    String getVersion() {
        return this.version;
    }

    TruffleInstrument loadInstrument() {
        return this.instrumentReflection.newInstance();
    }

    boolean supportsService(Class<?> clazz) {
        return this.services.contains(clazz.getName()) || this.services.contains(clazz.getCanonicalName());
    }

    String[] services() {
        return this.services.toArray(new String[0]);
    }

    private static final class ServicesLoader
    extends Loader {
        static final Loader INSTANCE = new ServicesLoader();
        private static final String DEBUGGER_CLASS = "com.oracle.truffle.api.debug.impl.DebuggerInstrument";
        private static final String DEBUGGER_PROVIDER = "com.oracle.truffle.api.debug.impl.DebuggerInstrumentProvider";

        private ServicesLoader() {
        }

        @Override
        void loadImpl(ClassLoader loader, List<? super InstrumentCache> list, Set<? super String> classNamesUsed) {
            ServicesLoader.exportTruffle(loader);
            for (TruffleInstrument.Provider provider : ServiceLoader.load(TruffleInstrument.Provider.class, loader)) {
                ServicesLoader.loadInstrumentImpl(provider, list, classNamesUsed);
            }
            if (!classNamesUsed.contains(DEBUGGER_CLASS)) {
                try {
                    ServicesLoader.loadInstrumentImpl((TruffleInstrument.Provider)loader.loadClass(DEBUGGER_PROVIDER).getConstructor(new Class[0]).newInstance(new Object[0]), list, classNamesUsed);
                }
                catch (Exception e) {
                    throw new AssertionError("Failed to discover debugger instrument.", e);
                }
            }
        }

        static void loadInstrumentImpl(TruffleInstrument.Provider provider, List<? super InstrumentCache> list, Set<? super String> classNamesUsed) {
            TruffleInstrument.Registration reg = provider.getClass().getAnnotation(TruffleInstrument.Registration.class);
            if (reg == null) {
                PrintStream out = System.err;
                out.println("Provider " + provider.getClass() + " is missing @Registration annotation.");
                return;
            }
            String className = provider.getInstrumentClassName();
            String name = reg.name();
            String id = reg.id();
            if (id == null || id.isEmpty()) {
                id = ServicesLoader.defaultId(className);
            }
            String version = reg.version();
            boolean internal = reg.internal();
            TreeSet<String> servicesClassNames = new TreeSet<String>();
            for (String service : provider.getServicesClassNames()) {
                servicesClassNames.add(service);
            }
            if (!classNamesUsed.contains(className)) {
                classNamesUsed.add(className);
                ServiceLoaderInstrumentReflection reflection = new ServiceLoaderInstrumentReflection(provider);
                list.add(new InstrumentCache(id, name, version, className, internal, servicesClassNames, reflection));
            }
        }

        private static final class ServiceLoaderInstrumentReflection
        extends InstrumentReflection {
            private final TruffleInstrument.Provider provider;

            ServiceLoaderInstrumentReflection(TruffleInstrument.Provider provider) {
                assert (provider != null);
                this.provider = provider;
            }

            @Override
            TruffleInstrument newInstance() {
                return this.provider.create();
            }

            @Override
            Class<? extends TruffleInstrument> aotInitializeAtBuildTime() {
                return null;
            }
        }
    }

    private static final class LegacyLoader
    extends Loader {
        static final Loader INSTANCE = new LegacyLoader();

        private LegacyLoader() {
        }

        @Override
        void loadImpl(ClassLoader loader, List<? super InstrumentCache> list, Set<? super String> classNamesUsed) {
            Enumeration<URL> en;
            try {
                en = loader.getResources("META-INF/truffle/instrument");
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot read list of Truffle instruments", ex);
            }
            while (en.hasMoreElements()) {
                String prefix;
                String className;
                Properties p;
                URL u = en.nextElement();
                try {
                    p = new Properties();
                    try (InputStream is = u.openStream();){
                        p.load(is);
                    }
                }
                catch (IOException ex) {
                    PrintStream out = System.err;
                    out.println("Cannot process " + u + " as language definition");
                    ex.printStackTrace();
                    continue;
                }
                int cnt = 1;
                while ((className = p.getProperty((prefix = "instrument" + cnt + ".") + "className")) != null) {
                    if (!classNamesUsed.contains(className)) {
                        classNamesUsed.add(className);
                        list.add(LegacyLoader.createInstrumentCache(prefix, p, loader));
                    }
                    ++cnt;
                }
            }
        }

        private static InstrumentCache createInstrumentCache(String prefix, Properties info, ClassLoader loader) {
            String nth;
            String serviceName;
            String className = info.getProperty(prefix + "className");
            String name = info.getProperty(prefix + "name");
            String version = info.getProperty(prefix + "version");
            boolean internal = Boolean.valueOf(info.getProperty(prefix + "internal"));
            String id = info.getProperty(prefix + "id");
            if (id == null || id.isEmpty()) {
                id = LegacyLoader.defaultId(className);
            }
            int servicesCounter = 0;
            TreeSet<String> services = new TreeSet<String>();
            while ((serviceName = info.getProperty(nth = prefix + "service" + servicesCounter++)) != null) {
                services.add(serviceName);
            }
            LegacyInstrumentReflection reflection = new LegacyInstrumentReflection(name, loader, className);
            return new InstrumentCache(id, name, version, className, internal, services, reflection);
        }

        private static final class LegacyInstrumentReflection
        extends InstrumentReflection {
            private final String name;
            private final ClassLoader loader;
            private final String className;
            private volatile Class<? extends TruffleInstrument> instrumentClass;

            LegacyInstrumentReflection(String name, ClassLoader loader, String className) {
                Objects.requireNonNull(name, "Name must be non null.");
                Objects.requireNonNull(loader, "Loader must be non null.");
                Objects.requireNonNull(className, "ClassName must be non null.");
                this.name = name;
                this.loader = loader;
                this.className = className;
            }

            @Override
            TruffleInstrument newInstance() {
                try {
                    return this.getInstrumentationClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot create instance of " + this.name + " language implementation. Public default constructor expected in " + this.className + ".", e);
                }
            }

            @Override
            Class<? extends TruffleInstrument> aotInitializeAtBuildTime() {
                this.initializeInstrumentClass();
                assert (this.instrumentClass != null);
                return this.instrumentClass;
            }

            private Class<? extends TruffleInstrument> getInstrumentationClass() {
                if (!TruffleOptions.AOT) {
                    this.initializeInstrumentClass();
                }
                return this.instrumentClass;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void initializeInstrumentClass() {
                if (this.instrumentClass == null) {
                    LegacyInstrumentReflection legacyInstrumentReflection = this;
                    synchronized (legacyInstrumentReflection) {
                        if (this.instrumentClass == null) {
                            try {
                                Loader.exportTruffle(this.loader);
                                this.instrumentClass = Class.forName(this.className, true, this.loader).asSubclass(TruffleInstrument.class);
                            }
                            catch (Exception ex) {
                                throw new IllegalStateException("Cannot initialize " + this.name + " instrument with implementation " + this.className, ex);
                            }
                        }
                    }
                }
            }
        }
    }

    private static abstract class Loader {
        private Loader() {
        }

        static void load(ClassLoader loader, List<? super InstrumentCache> list, Set<? super String> classNamesUsed) {
            if (loader == null) {
                return;
            }
            try {
                Class<?> truffleInstrumentClassAsSeenByLoader = Class.forName(TruffleInstrument.class.getName(), true, loader);
                if (truffleInstrumentClassAsSeenByLoader != TruffleInstrument.class) {
                    return;
                }
            }
            catch (ClassNotFoundException ex) {
                return;
            }
            LegacyLoader.INSTANCE.loadImpl(loader, list, classNamesUsed);
            ServicesLoader.INSTANCE.loadImpl(loader, list, classNamesUsed);
        }

        static void exportTruffle(ClassLoader loader) {
            if (!TruffleOptions.AOT) {
                EngineAccessor.JDKSERVICES.exportTo(loader, null);
            }
        }

        abstract void loadImpl(ClassLoader var1, List<? super InstrumentCache> var2, Set<? super String> var3);

        static String defaultId(String className) {
            int lastIndex = className.lastIndexOf(36);
            if (lastIndex == -1) {
                lastIndex = className.lastIndexOf(46);
            }
            return className.substring(lastIndex + 1, className.length());
        }
    }

    private static abstract class InstrumentReflection {
        private InstrumentReflection() {
        }

        abstract TruffleInstrument newInstance();

        abstract Class<? extends TruffleInstrument> aotInitializeAtBuildTime();
    }
}

