/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.reflect.MethodMetadataDecoder;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageSystemIOWrappers;
import com.oracle.svm.hosted.ProgressReporterCHelper;
import com.oracle.svm.hosted.StringAccess;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.util.ImageBuildStatistics;
import java.io.File;
import java.io.PrintWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ImageSingletonsSupport;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

public class ProgressReporter {
    private static final int CHARACTERS_PER_LINE;
    private static final int PROGRESS_BAR_START = 30;
    private static final boolean IS_CI;
    private static final int MAX_NUM_FEATURES = 50;
    private static final int MAX_NUM_BREAKDOWN = 10;
    private static final String CODE_BREAKDOWN_TITLE;
    private static final String HEAP_BREAKDOWN_TITLE;
    private static final String STAGE_DOCS_URL = "https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/BuildOutput.md";
    private static final double EXCESSIVE_GC_MIN_THRESHOLD_MILLIS = 15000.0;
    private static final double EXCESSIVE_GC_RATIO = 0.5;
    private static final String BREAKDOWN_BYTE_ARRAY_PREFIX = "byte[] for ";
    private static final double MILLIS_TO_SECONDS = 1000.0;
    private static final double NANOS_TO_SECONDS = 1.0E9;
    private static final double BYTES_TO_KiB = 1024.0;
    private static final double BYTES_TO_MiB = 1048576.0;
    private static final double BYTES_TO_GiB = 1.073741824E9;
    private final NativeImageSystemIOWrappers builderIO;
    private final boolean isEnabled;
    private final LinePrinter linePrinter;
    private final boolean usePrefix;
    private final boolean showLinks;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> periodicPrintingTask;
    private int numStageChars = 0;
    private long lastGCCheckTimeMillis = System.currentTimeMillis();
    private GCStats lastGCStats = ProgressReporter.getCurrentGCStats();
    private long numRuntimeCompiledMethods = -1L;
    private long graphEncodingByteLength = 0L;
    private int numJNIClasses = -1;
    private int numJNIFields = -1;
    private int numJNIMethods = -1;
    private Timer debugInfoTimer;
    private boolean initializeStageEndCompleted = false;
    private boolean creationStageEndCompleted = false;

    public static ProgressReporter singleton() {
        return (ProgressReporter)ImageSingletons.lookup(ProgressReporter.class);
    }

    public ProgressReporter(OptionValues options) {
        boolean enableProgress;
        boolean enableColors;
        this.builderIO = NativeImageSystemIOWrappers.singleton();
        this.isEnabled = (Boolean)SubstrateOptions.BuildOutputUseNewStyle.getValue(options);
        if (this.isEnabled) {
            Timer.disablePrinting();
        }
        this.usePrefix = (Boolean)SubstrateOptions.BuildOutputPrefix.getValue(options);
        boolean bl = enableColors = !IS_CI && OS.getCurrent() != OS.WINDOWS;
        if (SubstrateOptions.BuildOutputColorful.hasBeenSet(options)) {
            enableColors = (Boolean)SubstrateOptions.BuildOutputColorful.getValue(options);
        }
        boolean loggingDisabled = DebugOptions.Log.getValue(options) == null;
        boolean bl2 = enableProgress = !IS_CI && loggingDisabled;
        if (SubstrateOptions.BuildOutputProgress.hasBeenSet(options)) {
            enableProgress = (Boolean)SubstrateOptions.BuildOutputProgress.getValue(options);
        }
        if (enableColors) {
            this.linePrinter = new ColorfulLinePrinter(enableProgress);
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(ProgressReporter::resetANSIMode));
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.linePrinter = new ColorlessLinePrinter(enableProgress);
        }
        this.showLinks = (Boolean)SubstrateOptions.BuildOutputColorful.getValue(options);
    }

    private LinePrinter l() {
        assert (this.linePrinter.isEmpty()) : "Line printer should be empty before printing a new line";
        return this.linePrinter;
    }

    public void setNumRuntimeCompiledMethods(int value) {
        this.numRuntimeCompiledMethods = value;
    }

    public void setGraphEncodingByteLength(int value) {
        this.graphEncodingByteLength = value;
    }

    public void setJNIInfo(int numClasses, int numFields, int numMethods) {
        this.numJNIClasses = numClasses;
        this.numJNIFields = numFields;
        this.numJNIMethods = numMethods;
    }

    public void printStart(String imageName) {
        if (this.usePrefix) {
            this.linePrinter.outputPrefix = String.format("[%s:%s] ", imageName, GraalServices.getExecutionID());
        }
        this.l().printHeadlineSeparator();
        this.l().blueBold().link("GraalVM Native Image", "https://www.graalvm.org/native-image/").reset().a(": Generating '").bold().a(imageName).reset().a("'...").flushln();
        this.l().printHeadlineSeparator();
        this.printStageStart(BuildStage.INITIALIZING);
    }

    public void printInitializeEnd(Timer classlistTimer, Timer setupTimer) {
        if (this.initializeStageEndCompleted) {
            return;
        }
        this.printStageEnd(classlistTimer.getTotalTime() + setupTimer.getTotalTime());
        this.initializeStageEndCompleted = true;
    }

    public void printInitializeEnd(Timer classlistTimer, Timer setupTimer, Collection<String> libraries) {
        this.printInitializeEnd(classlistTimer, setupTimer);
        this.l().a(" ").doclink("Version info", "#glossary-version-info").a(": '").a(((VM)ImageSingletons.lookup(VM.class)).version).a("'").flushln();
        this.printNativeLibraries(libraries);
    }

    private void printNativeLibraries(Collection<String> libraries) {
        int numLibraries = libraries.size();
        if (numLibraries > 0) {
            if (numLibraries == 1) {
                this.l().a(" 1 native library: ").a(libraries.iterator().next()).flushln();
            } else {
                this.l().a(" ").a(numLibraries).a(" native libraries: ").a(String.join((CharSequence)", ", libraries)).flushln();
            }
        }
    }

    public void printFeatures(List<String> list) {
        int numUserFeatures = list.size();
        if (numUserFeatures > 0) {
            this.l().a(" ").a(numUserFeatures).a(" ").doclink("user-provided feature(s)", "#glossary-user-provided-features").flushln();
            if (numUserFeatures <= 50) {
                for (String name : list) {
                    this.l().a("  - ").a(name).flushln();
                }
            } else {
                for (int i = 0; i < 50; ++i) {
                    this.l().a("  - ").a(list.get(i)).flushln();
                }
                this.l().a("  ... ").a(numUserFeatures - 50).a(" more").flushln();
            }
        }
    }

    public ReporterClosable printAnalysis(final BigBang bb) {
        final Timer timer = bb.getAnalysisTimer();
        timer.start();
        this.printStageStart(BuildStage.ANALYSIS);
        this.printProgressStart();
        return new ReporterClosable(){

            @Override
            public void closeAction() {
                timer.stop();
                ProgressReporter.this.printProgressEnd();
                ProgressReporter.this.printStageEnd(bb.getAnalysisTimer());
                String actualVsTotalFormat = "%,8d (%5.2f%%) of %,6d";
                long reachableClasses = bb.getUniverse().getTypes().stream().filter(t -> t.isReachable()).count();
                long totalClasses = bb.getUniverse().getTypes().size();
                ProgressReporter.this.l().a(actualVsTotalFormat, reachableClasses, (double)reachableClasses / (double)totalClasses * 100.0, totalClasses).a(" classes ").doclink("reachable", "#glossary-reachability").flushln();
                Collection fields = bb.getUniverse().getFields();
                long reachableFields = fields.stream().filter(f -> f.isAccessed()).count();
                int totalFields = fields.size();
                ProgressReporter.this.l().a(actualVsTotalFormat, reachableFields, (double)reachableFields / (double)totalFields * 100.0, totalFields).a(" fields ").doclink("reachable", "#glossary-reachability").flushln();
                Collection methods = bb.getUniverse().getMethods();
                long reachableMethods = methods.stream().filter(m -> m.isReachable()).count();
                int totalMethods = methods.size();
                ProgressReporter.this.l().a(actualVsTotalFormat, reachableMethods, (double)reachableMethods / (double)totalMethods * 100.0, totalMethods).a(" methods ").doclink("reachable", "#glossary-reachability").flushln();
                if (ProgressReporter.this.numRuntimeCompiledMethods >= 0L) {
                    ProgressReporter.this.l().a(actualVsTotalFormat, ProgressReporter.this.numRuntimeCompiledMethods, (double)ProgressReporter.this.numRuntimeCompiledMethods / (double)totalMethods * 100.0, totalMethods).a(" methods included for ").doclink("runtime compilation", "#glossary-runtime-methods").flushln();
                }
                String classesFieldsMethodFormat = "%,8d classes, %,5d fields, and %,5d methods ";
                RuntimeReflectionSupport rs = (RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class);
                ProgressReporter.this.l().a(classesFieldsMethodFormat, rs.getReflectionClassesCount(), rs.getReflectionFieldsCount(), rs.getReflectionMethodsCount()).doclink("registered for reflection", "#glossary-reflection-registrations").flushln();
                if (ProgressReporter.this.numJNIClasses > 0) {
                    ProgressReporter.this.l().a(classesFieldsMethodFormat, ProgressReporter.this.numJNIClasses, ProgressReporter.this.numJNIFields, ProgressReporter.this.numJNIMethods).doclink("registered for JNI access", "#glossary-jni-access-registrations").flushln();
                }
            }
        };
    }

    public ReporterClosable printUniverse(final Timer timer) {
        timer.start();
        this.printStageStart(BuildStage.UNIVERSE);
        return new ReporterClosable(){

            @Override
            public void closeAction() {
                timer.stop();
                ProgressReporter.this.printStageEnd(timer);
            }
        };
    }

    public ReporterClosable printParsing(final Timer timer) {
        timer.start();
        this.printStageStart(BuildStage.PARSING);
        this.printProgressStart();
        this.startPeriodicPrinting();
        return new ReporterClosable(){

            @Override
            public void closeAction() {
                timer.stop();
                ProgressReporter.this.stopPeriodicPrinting();
                ProgressReporter.this.printProgressEnd();
                ProgressReporter.this.printStageEnd(timer);
            }
        };
    }

    public ReporterClosable printInlining(final Timer timer) {
        timer.start();
        this.printStageStart(BuildStage.INLINING);
        this.printProgressStart();
        return new ReporterClosable(){

            @Override
            public void closeAction() {
                timer.stop();
                ProgressReporter.this.printProgressEnd();
                ProgressReporter.this.printStageEnd(timer);
            }
        };
    }

    public void printInliningSkipped() {
        this.printStageStart(BuildStage.INLINING);
        this.linePrinter.a(this.progressBarStartPadding()).dim().a("(skipped)").reset().flushln(false);
        this.numStageChars = 0;
    }

    public ReporterClosable printCompiling(final Timer timer) {
        timer.start();
        this.printStageStart(BuildStage.COMPILING);
        this.printProgressStart();
        this.startPeriodicPrinting();
        return new ReporterClosable(){

            @Override
            public void closeAction() {
                timer.stop();
                ProgressReporter.this.stopPeriodicPrinting();
                ProgressReporter.this.printProgressEnd();
                ProgressReporter.this.printStageEnd(timer);
            }
        };
    }

    public void printCreationStart() {
        this.printStageStart(BuildStage.CREATING);
    }

    public void setDebugInfoTimer(Timer timer) {
        this.debugInfoTimer = timer;
    }

    public void printCreationEnd(Timer creationTimer, Timer writeTimer, int imageSize, AnalysisUniverse universe, int numHeapObjects, long imageHeapSize, int codeCacheSize, int numCompilations, int debugInfoSize) {
        this.printStageEnd(creationTimer.getTotalTime() + writeTimer.getTotalTime());
        this.creationStageEndCompleted = true;
        String format = "%9s (%5.2f%%) for ";
        this.l().a(format, ProgressReporter.bytesToHuman(codeCacheSize), (double)codeCacheSize / (double)imageSize * 100.0).doclink("code area", "#glossary-code-area").a(":%,9d compilation units", numCompilations).flushln();
        long numInstantiatedClasses = universe.getTypes().stream().filter(t -> t.isInstantiated()).count();
        this.l().a(format, ProgressReporter.bytesToHuman(imageHeapSize), (double)imageHeapSize / (double)imageSize * 100.0).doclink("image heap", "#glossary-image-heap").a(":%,8d classes and %,d objects", numInstantiatedClasses, numHeapObjects).flushln();
        if (debugInfoSize > 0) {
            LinePrinter l = this.l().a(format, ProgressReporter.bytesToHuman(debugInfoSize), (double)debugInfoSize / (double)imageSize * 100.0).doclink("debug info", "#glossary-debug-info");
            if (this.debugInfoTimer != null) {
                l.a(" generated in %.1fs", ProgressReporter.millisToSeconds(this.debugInfoTimer.getTotalTime()));
            }
            l.flushln();
        }
        long otherBytes = (long)(imageSize - codeCacheSize) - imageHeapSize - (long)debugInfoSize;
        this.l().a(format, ProgressReporter.bytesToHuman(otherBytes), (double)otherBytes / (double)imageSize * 100.0).doclink("other data", "#glossary-other-data").flushln();
        this.l().a("%9s in total", ProgressReporter.bytesToHuman(imageSize)).flushln();
    }

    public void ensureCreationStageEndCompleted() {
        if (!this.creationStageEndCompleted) {
            this.linePrinter.flushln();
            this.restoreBuilderIO();
        }
    }

    private void restoreBuilderIO() {
        this.builderIO.useCapturing = false;
        this.builderIO.flushCapturedContent();
    }

    public void printBreakdowns(Collection<CompileQueue.CompileTask> compilationTasks, Collection<NativeImageHeap.ObjectInfo> heapObjects) {
        Map<String, Long> codeBreakdown = ProgressReporter.calculateCodeBreakdown(compilationTasks);
        Map<String, Long> heapBreakdown = this.calculateHeapBreakdown(heapObjects);
        this.l().printLineSeparator();
        int numCodeBreakdownItems = codeBreakdown.size();
        int numHeapBreakdownItems = heapBreakdown.size();
        Iterator packagesBySize = codeBreakdown.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).iterator();
        Iterator typesBySizeInHeap = heapBreakdown.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).iterator();
        this.l().yellowBold().a(ProgressReporter.CODE_BREAKDOWN_TITLE).jumpToMiddle().a(ProgressReporter.HEAP_BREAKDOWN_TITLE).reset().flushln();
        ArrayList<Map.Entry> printedCodeSizeEntries = new ArrayList<Map.Entry>();
        ArrayList<Map.Entry> printedHeapSizeEntries = new ArrayList<Map.Entry>();
        for (int i = 0; i < 10; ++i) {
            String codeSizePart = "";
            if (packagesBySize.hasNext()) {
                Map.Entry e = (Map.Entry)packagesBySize.next();
                String className = ProgressReporter.truncateClassOrPackageName((String)e.getKey());
                codeSizePart = String.format("%9s %s", ProgressReporter.bytesToHuman((Long)e.getValue()), className);
                printedCodeSizeEntries.add(e);
            }
            String heapSizePart = "";
            if (typesBySizeInHeap.hasNext()) {
                Map.Entry e = (Map.Entry)typesBySizeInHeap.next();
                String className = (String)e.getKey();
                if (!className.startsWith(BREAKDOWN_BYTE_ARRAY_PREFIX)) {
                    className = ProgressReporter.truncateClassOrPackageName(className);
                }
                heapSizePart = String.format("%9s %s", ProgressReporter.bytesToHuman((Long)e.getValue()), className);
                printedHeapSizeEntries.add(e);
            }
            if (codeSizePart.isEmpty() && heapSizePart.isEmpty()) break;
            this.l().a(codeSizePart).jumpToMiddle().a(heapSizePart).flushln();
        }
        this.l().a("      ... ").a(numCodeBreakdownItems - printedHeapSizeEntries.size()).a(" additional packages").jumpToMiddle().a("      ... ").a(numHeapBreakdownItems - printedCodeSizeEntries.size()).a(" additional object types").flushln();
        this.l().dim().a("(use ").link("GraalVM Dashboard", "https://www.graalvm.org/dashboard/?ojr=help%3Btopic%3Dgetting-started.md").a(" to see all)").reset().flushCenteredln();
    }

    private static Map<String, Long> calculateCodeBreakdown(Collection<CompileQueue.CompileTask> compilationTasks) {
        HashMap<String, Long> classNameToCodeSize = new HashMap<String, Long>();
        for (CompileQueue.CompileTask task : compilationTasks) {
            String classOrPackageName = task.method.format("%H");
            int lastDotIndex = classOrPackageName.lastIndexOf(46);
            if (lastDotIndex > 0) {
                classOrPackageName = classOrPackageName.substring(0, lastDotIndex);
            }
            classNameToCodeSize.merge(classOrPackageName, Long.valueOf(task.result.getTargetCodeSize()), Long::sum);
        }
        return classNameToCodeSize;
    }

    private Map<String, Long> calculateHeapBreakdown(Collection<NativeImageHeap.ObjectInfo> heapObjects) {
        HashMap<String, Long> classNameToSize = new HashMap<String, Long>();
        long stringByteLength = 0L;
        for (NativeImageHeap.ObjectInfo o : heapObjects) {
            classNameToSize.merge(o.getClazz().toJavaName(true), o.getSize(), Long::sum);
            Object javaObject = o.getObject();
            if (!(javaObject instanceof String)) continue;
            stringByteLength += (long)StringAccess.getInternalByteArrayLength((String)javaObject);
        }
        Long byteArraySize = (Long)classNameToSize.remove("byte[]");
        if (byteArraySize != null) {
            long remainingBytes = byteArraySize;
            classNameToSize.put("byte[] for java.lang.String", stringByteLength);
            remainingBytes -= stringByteLength;
            long metadataByteLength = ((MethodMetadataDecoder)ImageSingletons.lookup(MethodMetadataDecoder.class)).getMetadataByteLength();
            if (metadataByteLength > 0L) {
                classNameToSize.put(BREAKDOWN_BYTE_ARRAY_PREFIX + this.linePrinter.asDocLink("method metadata", "#glossary-method-metadata"), metadataByteLength);
                remainingBytes -= metadataByteLength;
            }
            if (this.graphEncodingByteLength > 0L) {
                classNameToSize.put(BREAKDOWN_BYTE_ARRAY_PREFIX + this.linePrinter.asDocLink("graph encodings", "#glossary-graph-encodings"), this.graphEncodingByteLength);
                remainingBytes -= this.graphEncodingByteLength;
            }
            assert (remainingBytes >= 0L);
            classNameToSize.put(BREAKDOWN_BYTE_ARRAY_PREFIX + this.linePrinter.asDocLink("general heap data", "#glossary-general-heap-data"), remainingBytes);
        }
        return classNameToSize;
    }

    public void printEpilog(String imageName, NativeImageGenerator generator, boolean wasSuccessfulBuild, Timer totalTimer, OptionValues parsedHostedOptions) {
        this.l().printLineSeparator();
        this.printResourceStats();
        this.l().printLineSeparator();
        this.l().yellowBold().a("Produced artifacts:").reset().flushln();
        generator.getBuildArtifacts().forEach((artifactType, paths) -> {
            for (Path p : paths) {
                this.l().a(" ").link(p).dim().a(" (").a(artifactType.name().toLowerCase()).a(")").reset().flushln();
            }
        });
        if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(parsedHostedOptions)).booleanValue()) {
            this.l().a(" ").link(this.reportImageBuildStatistics(imageName, generator.getBigbang())).flushln();
        }
        this.l().a(" ").link(this.reportBuildArtifacts(imageName, generator.getBuildArtifacts())).flushln();
        this.l().printHeadlineSeparator();
        double totalSeconds = ProgressReporter.millisToSeconds(totalTimer.getTotalTime());
        String timeStats = totalSeconds < 60.0 ? String.format("%.1fs", totalSeconds) : String.format("%dm %ds", (int)totalSeconds / 60, (int)totalSeconds % 60);
        this.l().a(wasSuccessfulBuild ? "Finished" : "Failed").a(" generating '").bold().a(imageName).reset().a("' ").a(wasSuccessfulBuild ? "in" : "after").a(" ").a(timeStats).a(".").flushln();
        this.executor.shutdown();
    }

    private Path reportImageBuildStatistics(String imageName, BigBang bb) {
        Consumer statsReporter = ((ImageBuildStatistics)ImageSingletons.lookup(ImageBuildStatistics.class)).getReporter();
        String description = "image build statistics";
        if (ImageBuildStatistics.Options.ImageBuildStatisticsFile.hasBeenSet(bb.getOptions())) {
            File file = new File((String)ImageBuildStatistics.Options.ImageBuildStatisticsFile.getValue(bb.getOptions()));
            return ReportUtils.report((String)description, (Path)file.getAbsoluteFile().toPath(), (Consumer)statsReporter, (!this.isEnabled ? 1 : 0) != 0);
        }
        String name = "image_build_statistics_" + ReportUtils.extractImageName((String)imageName);
        String path = SubstrateOptions.Path.getValue() + File.separatorChar + "reports";
        return ReportUtils.report((String)description, (String)path, (String)name, (String)"json", (Consumer)statsReporter, (!this.isEnabled ? 1 : 0) != 0);
    }

    private Path reportBuildArtifacts(String imageName, Map<BuildArtifacts.ArtifactType, List<Path>> buildArtifacts) {
        Path buildDir = NativeImageGenerator.generatedFiles(HostedOptionValues.singleton());
        Consumer<PrintWriter> writerConsumer = writer -> buildArtifacts.forEach((artifactType, paths) -> {
            writer.println("[" + (Object)artifactType + "]");
            if (artifactType == BuildArtifacts.ArtifactType.JDK_LIB_SHIM) {
                writer.println("# Note that shim JDK libraries depend on this");
                writer.println("# particular native image (including its name)");
                writer.println("# and therefore cannot be used with others.");
            }
            paths.stream().map(Path::toAbsolutePath).map(buildDir::relativize).forEach(writer::println);
            writer.println();
        });
        return ReportUtils.report((String)"build artifacts", (Path)buildDir.resolve(imageName + ".build_artifacts.txt"), writerConsumer, (!this.isEnabled ? 1 : 0) != 0);
    }

    private void printResourceStats() {
        OperatingSystemMXBean osMXBean;
        long processCPUTime;
        double totalProcessTimeSeconds = ProgressReporter.millisToSeconds(System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getStartTime());
        GCStats gcStats = ProgressReporter.getCurrentGCStats();
        double gcSeconds = ProgressReporter.millisToSeconds(gcStats.totalTimeMillis);
        LinePrinter l = this.l().a("%.1fs (%.1f%% of total time) in %d ", gcSeconds, gcSeconds / totalProcessTimeSeconds * 100.0, gcStats.totalCount).doclink("GCs", "#glossary-garbage-collections");
        long peakRSS = ProgressReporterCHelper.getPeakRSS();
        if (peakRSS >= 0L) {
            l.a(" | ").doclink("Peak RSS", "#glossary-peak-rss").a(": ").a("%.2fGB", ProgressReporter.bytesToGiB(peakRSS));
        }
        if ((processCPUTime = ((com.sun.management.OperatingSystemMXBean)(osMXBean = ManagementFactory.getOperatingSystemMXBean())).getProcessCpuTime()) > 0L) {
            l.a(" | ").doclink("CPU load", "#glossary-cpu-load").a(": ").a("%.2f", ProgressReporter.nanosToSeconds(processCPUTime) / totalProcessTimeSeconds);
        }
        l.flushCenteredln();
    }

    private void printStageStart(BuildStage stage) {
        assert (this.numStageChars == 0);
        this.l().appendPrefix().flush();
        this.linePrinter.blue().a("[").a(1 + stage.ordinal()).a("/").a(BuildStage.NUM_STAGES).a("] ").reset().blueBold().doclink(stage.message, "#stage-" + stage.name().toLowerCase()).a("...").reset();
        this.numStageChars = this.linePrinter.getCurrentTextLength();
        this.linePrinter.flush();
        this.builderIO.useCapturing = true;
    }

    private void printProgressStart() {
        this.linePrinter.a(this.progressBarStartPadding()).dim().a("[");
        this.numStageChars = 31;
        this.linePrinter.flush();
    }

    private String progressBarStartPadding() {
        return ProgressReporter.stringFilledWith(30 - this.numStageChars, " ");
    }

    private void printProgressEnd() {
        this.linePrinter.printRaw(']');
        ++this.numStageChars;
    }

    public void printStageProgress() {
        this.linePrinter.printRaw('*');
        ++this.numStageChars;
    }

    private void startPeriodicPrinting() {
        this.periodicPrintingTask = this.executor.scheduleAtFixedRate(new Runnable(){
            int countdown;
            int numPrints;

            @Override
            public void run() {
                if (--this.countdown < 0) {
                    ProgressReporter.this.printStageProgress();
                    this.countdown = ++this.numPrints > 2 ? this.numPrints * 2 : this.numPrints;
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    private void stopPeriodicPrinting() {
        this.periodicPrintingTask.cancel(false);
    }

    private void printStageEnd(Timer timer) {
        this.printStageEnd(timer.getTotalTime());
    }

    private void printStageEnd(double totalTime) {
        boolean optionsAvailable;
        assert (this.numStageChars >= 0);
        String suffix = String.format("(%.1fs @ %.2fGB)", ProgressReporter.millisToSeconds(totalTime), ProgressReporter.getUsedMemory());
        String padding = ProgressReporter.stringFilledWith(Math.max(0, CHARACTERS_PER_LINE - this.numStageChars - suffix.length()), " ");
        this.linePrinter.a(padding).dim().a(suffix).reset().flushln(false);
        this.numStageChars = 0;
        boolean bl = optionsAvailable = ImageSingletonsSupport.isInstalled() && ImageSingletons.contains(HostedOptionValues.class);
        if (optionsAvailable && SubstrateOptions.BuildOutputGCWarnings.getValue().booleanValue()) {
            this.checkForExcessiveGarbageCollection();
        }
        this.restoreBuilderIO();
    }

    private void checkForExcessiveGarbageCollection() {
        long current = System.currentTimeMillis();
        long timeDeltaMillis = current - this.lastGCCheckTimeMillis;
        this.lastGCCheckTimeMillis = current;
        GCStats currentGCStats = ProgressReporter.getCurrentGCStats();
        long gcTimeDeltaMillis = currentGCStats.totalTimeMillis - this.lastGCStats.totalTimeMillis;
        double ratio = (double)gcTimeDeltaMillis / (double)timeDeltaMillis;
        if ((double)gcTimeDeltaMillis > 15000.0 && ratio > 0.5) {
            this.l().redBold().a("GC warning").reset().a(": %.1fs spent in %d GCs during the last stage, taking up %.2f%% of the time.", ProgressReporter.millisToSeconds(gcTimeDeltaMillis), currentGCStats.totalCount - this.lastGCStats.totalCount, ratio * 100.0).flushln();
            this.l().a("            Please ensure more than %.2fGB of memory is available for Native Image", ProgressReporter.bytesToGiB(ProgressReporterCHelper.getPeakRSS())).flushln();
            this.l().a("            to reduce GC overhead and improve image build time.").flushln();
        }
        this.lastGCStats = currentGCStats;
    }

    private static void resetANSIMode() {
        NativeImageSystemIOWrappers.singleton().getOut().print("\u001b[0m");
    }

    private static String stringFilledWith(int size, String fill) {
        return new String(new char[size]).replace("\u0000", fill);
    }

    protected static String truncateClassOrPackageName(String classOrPackageName) {
        int maxLength;
        int classNameLength = classOrPackageName.length();
        if (classNameLength <= (maxLength = CHARACTERS_PER_LINE / 2 - 10)) {
            return classOrPackageName;
        }
        StringBuilder sb = new StringBuilder();
        int currentDot = -1;
        while (true) {
            int nextDot;
            if ((nextDot = classOrPackageName.indexOf(46, currentDot + 1)) < 0) {
                int restLength;
                String rest = classOrPackageName.substring(currentDot + 1);
                int sbLength = sb.length();
                if (sbLength + (restLength = rest.length()) <= maxLength) {
                    sb.append(rest);
                    break;
                }
                int remainingSpaceDivBy2 = (maxLength - sbLength) / 2;
                sb.append(rest.substring(0, remainingSpaceDivBy2 - 1) + "~" + rest.substring(restLength - remainingSpaceDivBy2, restLength));
                break;
            }
            sb.append(classOrPackageName.charAt(currentDot + 1)).append('.');
            if (sb.length() + (classNameLength - nextDot) <= maxLength) {
                sb.append(classOrPackageName.substring(nextDot + 1));
                break;
            }
            currentDot = nextDot;
        }
        return sb.toString();
    }

    private static double getUsedMemory() {
        return ProgressReporter.bytesToGiB(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
    }

    private static String bytesToHuman(long bytes) {
        return ProgressReporter.bytesToHuman("%4.2f", bytes);
    }

    private static String bytesToHuman(String format, long bytes) {
        if ((double)bytes < 1024.0) {
            return String.format(format, bytes) + "B";
        }
        if ((double)bytes < 1048576.0) {
            return String.format(format, ProgressReporter.bytesToKiB(bytes)) + "KB";
        }
        if ((double)bytes < 1.073741824E9) {
            return String.format(format, ProgressReporter.bytesToMiB(bytes)) + "MB";
        }
        return String.format(format, ProgressReporter.bytesToGiB(bytes)) + "GB";
    }

    private static double bytesToKiB(long bytes) {
        return (double)bytes / 1024.0;
    }

    private static double bytesToGiB(long bytes) {
        return (double)bytes / 1.073741824E9;
    }

    private static double bytesToMiB(long bytes) {
        return (double)bytes / 1048576.0;
    }

    private static double millisToSeconds(double millis) {
        return millis / 1000.0;
    }

    private static double nanosToSeconds(double nanos) {
        return nanos / 1.0E9;
    }

    private static GCStats getCurrentGCStats() {
        long totalCount = 0L;
        long totalTime = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long collectionTime;
            long collectionCount = bean.getCollectionCount();
            if (collectionCount > 0L) {
                totalCount += collectionCount;
            }
            if ((collectionTime = bean.getCollectionTime()) <= 0L) continue;
            totalTime += collectionTime;
        }
        return new GCStats(totalCount, totalTime);
    }

    static {
        IS_CI = System.console() == null || System.getenv("CI") != null;
        CODE_BREAKDOWN_TITLE = String.format("Top %d packages in code area:", 10);
        HEAP_BREAKDOWN_TITLE = String.format("Top %d object types in image heap:", 10);
        CHARACTERS_PER_LINE = IS_CI ? 120 : ProgressReporterCHelper.getTerminalWindowColumnsClamped();
    }

    private static class ANSIColors {
        static final String ESCAPE = "\u001b";
        static final String RESET = "\u001b[0m";
        static final String BOLD = "\u001b[1m";
        static final String DIM = "\u001b[2m";
        static final String LINK_START = "\u001b]8;;";
        static final String LINK_TEXT = "\u001b\\";
        static final String LINK_END = "\u001b]8;;\u001b\\";
        static final String LINK_FORMAT = "\u001b]8;;%s\u001b\\%s\u001b]8;;\u001b\\";
        static final String BLUE = "\u001b[0;34m";
        static final String RED_BOLD = "\u001b[1;31m";
        static final String YELLOW_BOLD = "\u001b[1;33m";
        static final String BLUE_BOLD = "\u001b[1;34m";

        private ANSIColors() {
        }
    }

    private final class ColorlessLinePrinter
    extends LinePrinter {
        ColorlessLinePrinter(boolean enableProgress) {
            super(enableProgress);
        }

        @Override
        protected LinePrinter bold() {
            return this;
        }

        @Override
        protected LinePrinter blue() {
            return this;
        }

        @Override
        protected LinePrinter blueBold() {
            return this;
        }

        @Override
        protected LinePrinter redBold() {
            return this;
        }

        @Override
        protected LinePrinter yellowBold() {
            return this;
        }

        @Override
        protected LinePrinter dim() {
            return this;
        }

        @Override
        protected LinePrinter link(String text, String url) {
            return this.a(text);
        }

        @Override
        protected LinePrinter link(Path path) {
            return this.a(path.normalize().toString());
        }

        @Override
        protected LinePrinter doclink(String text, String htmlAnchor) {
            return this.a(text);
        }

        @Override
        protected LinePrinter reset() {
            return this;
        }

        @Override
        protected String asDocLink(String text, String htmlAnchor) {
            return text;
        }
    }

    private final class ColorfulLinePrinter
    extends LinePrinter {
        ColorfulLinePrinter(boolean enableProgress) {
            super(enableProgress);
        }

        @Override
        protected LinePrinter bold() {
            return this.a("\u001b[1m");
        }

        @Override
        protected LinePrinter blue() {
            return this.a("\u001b[0;34m");
        }

        @Override
        protected LinePrinter blueBold() {
            return this.a("\u001b[1;34m");
        }

        @Override
        protected LinePrinter redBold() {
            return this.a("\u001b[1;31m");
        }

        @Override
        protected LinePrinter yellowBold() {
            return this.a("\u001b[1;33m");
        }

        @Override
        protected LinePrinter dim() {
            return this.a("\u001b[2m");
        }

        @Override
        protected LinePrinter link(String text, String url) {
            if (ProgressReporter.this.showLinks) {
                this.a("\u001b]8;;" + url).a("\u001b\\").a(text).a("\u001b]8;;\u001b\\");
            } else {
                this.a(text);
            }
            return this;
        }

        @Override
        protected LinePrinter link(Path path) {
            Path normalized = path.normalize();
            return this.link(normalized.toString(), normalized.toUri().toString());
        }

        @Override
        protected LinePrinter doclink(String text, String htmlAnchor) {
            return this.link(text, ProgressReporter.STAGE_DOCS_URL + htmlAnchor);
        }

        @Override
        protected LinePrinter reset() {
            return this.a("\u001b[0m");
        }

        @Override
        protected String asDocLink(String text, String htmlAnchor) {
            if (ProgressReporter.this.showLinks) {
                return String.format("\u001b]8;;%s\u001b\\%s\u001b]8;;\u001b\\", ProgressReporter.STAGE_DOCS_URL + htmlAnchor, text);
            }
            return text;
        }
    }

    abstract class LinePrinter {
        private final List<String> textBuffer = new ArrayList<String>();
        private final StringBuilder printBuffer;
        protected final String headlineSeparator = ProgressReporter.access$2300(ProgressReporter.access$2200(), "=");
        protected final String lineSeparator = ProgressReporter.access$2300(ProgressReporter.access$2200(), "-");
        private String outputPrefix = "";

        LinePrinter(boolean enableProgress) {
            this.printBuffer = enableProgress ? null : new StringBuilder();
        }

        protected LinePrinter a(String text) {
            if (ProgressReporter.this.isEnabled) {
                this.textBuffer.add(text);
            }
            return this;
        }

        protected LinePrinter a(String text, Object ... args) {
            return this.a(String.format(text, args));
        }

        protected LinePrinter a(int i) {
            return this.a(String.valueOf(i));
        }

        protected LinePrinter a(long i) {
            return this.a(String.valueOf(i));
        }

        protected LinePrinter appendPrefix() {
            return this.a(this.outputPrefix);
        }

        protected LinePrinter jumpToMiddle() {
            int remaining = CHARACTERS_PER_LINE / 2 - this.getCurrentTextLength();
            assert (remaining >= 0) : "Column text too wide";
            this.a(ProgressReporter.stringFilledWith(remaining, " "));
            assert (!ProgressReporter.this.isEnabled || this.getCurrentTextLength() == CHARACTERS_PER_LINE / 2);
            return this;
        }

        protected abstract LinePrinter bold();

        protected abstract LinePrinter blue();

        protected abstract LinePrinter blueBold();

        protected abstract LinePrinter redBold();

        protected abstract LinePrinter yellowBold();

        protected abstract LinePrinter dim();

        protected abstract LinePrinter reset();

        protected abstract LinePrinter link(String var1, String var2);

        protected abstract LinePrinter link(Path var1);

        protected abstract LinePrinter doclink(String var1, String var2);

        protected abstract String asDocLink(String var1, String var2);

        private void flush() {
            if (!ProgressReporter.this.isEnabled) {
                return;
            }
            if (this.printBuffer != null) {
                this.textBuffer.forEach(this.printBuffer::append);
            } else {
                this.textBuffer.forEach(ProgressReporter.this.builderIO.getOut()::print);
            }
            this.textBuffer.clear();
        }

        private void printRaw(char value) {
            if (!ProgressReporter.this.isEnabled) {
                return;
            }
            if (this.printBuffer != null) {
                this.printBuffer.append(value);
            } else {
                ProgressReporter.this.builderIO.getOut().print(value);
            }
        }

        private void flushln() {
            this.flushln(true);
        }

        private void flushln(boolean useOutputPrefix) {
            if (!ProgressReporter.this.isEnabled) {
                return;
            }
            if (useOutputPrefix) {
                ProgressReporter.this.builderIO.getOut().print(this.outputPrefix);
            }
            if (this.printBuffer != null) {
                ProgressReporter.this.builderIO.getOut().print(this.printBuffer);
                this.printBuffer.setLength(0);
            }
            this.textBuffer.forEach(ProgressReporter.this.builderIO.getOut()::print);
            this.textBuffer.clear();
            ProgressReporter.this.builderIO.getOut().println();
        }

        private void flushCenteredln() {
            if (!ProgressReporter.this.isEnabled) {
                return;
            }
            String padding = ProgressReporter.stringFilledWith(Math.max(0, CHARACTERS_PER_LINE - this.getCurrentTextLength()) / 2, " ");
            this.textBuffer.add(0, padding);
            this.flushln();
        }

        private int getCurrentTextLength() {
            int textLength = 0;
            for (String text : this.textBuffer) {
                if (text.startsWith("\u001b")) continue;
                textLength += text.length();
            }
            return textLength;
        }

        private boolean isEmpty() {
            return this.textBuffer.isEmpty();
        }

        private void printHeadlineSeparator() {
            this.dim().a(this.headlineSeparator).reset().flushln();
        }

        private void printLineSeparator() {
            this.dim().a(this.lineSeparator).reset().flushln();
        }
    }

    public static abstract class ReporterClosable
    implements AutoCloseable {
        @Override
        public void close() {
            this.closeAction();
        }

        abstract void closeAction();
    }

    @AutomaticFeature
    public static class ProgressReporterFeature
    implements Feature {
        private final ProgressReporter reporter = ProgressReporter.singleton();

        public void duringAnalysis(Feature.DuringAnalysisAccess access) {
            this.reporter.printStageProgress();
        }
    }

    private static class GCStats {
        private final long totalCount;
        private final long totalTimeMillis;

        GCStats(long totalCount, long totalTime) {
            this.totalCount = totalCount;
            this.totalTimeMillis = totalTime;
        }
    }

    private static enum BuildStage {
        INITIALIZING("Initializing"),
        ANALYSIS("Performing analysis"),
        UNIVERSE("Building universe"),
        PARSING("Parsing methods"),
        INLINING("Inlining methods"),
        COMPILING("Compiling methods"),
        CREATING("Creating image");

        private static final int NUM_STAGES;
        private final String message;

        private BuildStage(String message) {
            this.message = message;
        }

        static {
            NUM_STAGES = BuildStage.values().length;
        }
    }
}

