/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;

public class ResourceURLConnection
extends URLConnection {
    private final URL url;
    private final int index;
    private byte[] data;

    public ResourceURLConnection(URL url) {
        this(url, 0);
    }

    public ResourceURLConnection(URL url, int index) {
        super(url);
        this.url = url;
        this.index = index;
    }

    private static String resolveName(String resourceName) {
        return resourceName.startsWith("/") ? resourceName.substring(1) : resourceName;
    }

    @Override
    public void connect() {
        List<byte[]> bytes;
        if (this.connected) {
            return;
        }
        this.connected = true;
        String resourceName = ResourceURLConnection.resolveName(this.url.getPath());
        ResourceStorageEntry entry = Resources.get(Resources.toCanonicalForm(resourceName));
        this.data = (byte[])(entry != null ? (this.index < (bytes = entry.getData()).size() ? bytes.get(this.index) : bytes.get(0)) : null);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.data == null) {
            throw new FileNotFoundException(this.url.toString());
        }
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long getContentLengthLong() {
        this.connect();
        return this.data != null ? (long)this.data.length : -1L;
    }
}

