/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import com.oracle.svm.core.jdk.resources.Target_com_sun_nio_zipfs_ZipUtils_JDK8OrEarlier;
import com.oracle.svm.core.jdk.resources.Target_jdk_nio_zipfs_ZipUtils_JDK11OrLater;
import java.io.InputStream;
import java.util.Arrays;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public final class NativeImageResourceFileSystemUtil {
    private NativeImageResourceFileSystemUtil() {
    }

    public static byte[] getBytes(String resourceName, boolean readOnly) {
        ResourceStorageEntry entry = Resources.get(resourceName);
        if (entry == null) {
            return new byte[0];
        }
        byte[] bytes = entry.getData().get(0);
        if (readOnly) {
            return bytes;
        }
        return Arrays.copyOf(bytes, bytes.length);
    }

    public static int getSize(String resourceName) {
        ResourceStorageEntry entry = Resources.get(resourceName);
        if (entry == null) {
            return 0;
        }
        return entry.getData().get(0).length;
    }

    public static String toRegexPattern(String globPattern) {
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            return Target_jdk_nio_zipfs_ZipUtils_JDK11OrLater.toRegexPattern(globPattern);
        }
        return Target_com_sun_nio_zipfs_ZipUtils_JDK8OrEarlier.toRegexPattern(globPattern);
    }

    public static byte[] inputStreamToByteArray(InputStream is) {
        return Resources.inputStreamToByteArray(is);
    }
}

