/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.SubstrateStackIntrospection;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.svm.truffle.api.SubstateTruffleOptions;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTarget;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.OptimizationFailedException;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.CancellableCompileTask;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.LoopNodeFactory;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class SubstrateTruffleRuntime
extends GraalTruffleRuntime {
    private static final int DEBUG_TEAR_DOWN_TIMEOUT = 2000;
    private static final int PRODUCTION_TEAR_DOWN_TIMEOUT = 10000;
    private GraalTruffleRuntime.CallMethods hostedCallMethods;
    private volatile BackgroundCompileQueue compileQueue;
    private volatile boolean initialized;
    private volatile Boolean profilingEnabled;

    protected BackgroundCompileQueue getCompileQueue() {
        assert (this.compileQueue != null);
        return this.compileQueue;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleRuntime() {
        super(Collections.emptyList());
        super.getLoopNodeFactory();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void resetHosted() {
        this.truffleCompiler = null;
    }

    private void initializeAtRuntime(OptimizedCallTarget callTarget) {
        this.truffleCompiler.initialize(TruffleRuntimeOptions.getOptionsForCompiler((OptimizedCallTarget)callTarget));
        if (SubstateTruffleOptions.isMultiThreaded()) {
            this.compileQueue = TruffleFeature.getSupport().createBackgroundCompileQueue(this);
            RuntimeSupport.getRuntimeSupport().addTearDownHook(this::tearDown);
        }
        if (callTarget.engine.traceTransferToInterpreter) {
            if (!SubstrateOptions.IncludeNodeSourcePositions.getValue().booleanValue()) {
                Log.log().string("Warning: TraceTruffleTransferToInterpreter cannot print stack traces. Build image with -H:+IncludeNodeSourcePositions to enable stack traces.").newline();
            }
            RuntimeOptionValues.singleton().update(Deoptimizer.Options.TraceDeoptimization, true);
        }
        this.installDefaultListeners();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompiler initTruffleCompiler() {
        assert (this.truffleCompiler == null) : "Cannot re-initialize Substrate TruffleCompiler";
        SubstrateTruffleCompiler compiler = this.newTruffleCompiler();
        this.truffleCompiler = compiler;
        return compiler;
    }

    public ResolvedJavaMethod[] getAnyFrameMethod() {
        return this.callMethods.anyFrameMethod;
    }

    protected String getCompilerConfigurationName() {
        TruffleCompiler compiler = this.truffleCompiler;
        if (compiler != null) {
            return compiler.getCompilerConfigurationName();
        }
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompiler newTruffleCompiler() {
        return TruffleFeature.getSupport().createTruffleCompiler(this);
    }

    private void tearDown() {
        long timeout = SubstrateUtil.assertionsEnabled() ? 2000L : 10000L;
        this.getCompileQueue().shutdownAndAwaitTermination(timeout);
    }

    public SubstrateTruffleCompiler getTruffleCompiler(CompilableTruffleAST compilable) {
        Objects.requireNonNull(compilable, "Compilable must be non null.");
        this.ensureInitializedAtRuntime((OptimizedCallTarget)compilable);
        return (SubstrateTruffleCompiler)this.truffleCompiler;
    }

    protected LoopNodeFactory getLoopNodeFactory() {
        if (this.loopNodeFactory == null) {
            throw VMError.shouldNotReachHere("loopNodeFactory not initialized");
        }
        return this.loopNodeFactory;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void lookupCallMethods(MetaAccessProvider metaAccess) {
        super.lookupCallMethods(metaAccess);
        this.hostedCallMethods = GraalTruffleRuntime.CallMethods.lookup((MetaAccessProvider)GraalAccess.getOriginalProviders().getMetaAccess());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void clearState() {
        super.clearState();
        this.hostedCallMethods = null;
    }

    protected GraalTruffleRuntime.CallMethods getCallMethods() {
        if (SubstrateUtil.HOSTED) {
            return this.hostedCallMethods;
        }
        return this.callMethods;
    }

    public OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget source, RootNode rootNode) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.profilingEnabled == null) {
            this.profilingEnabled = SubstrateTruffleRuntime.getEngineData((RootNode)rootNode).profilingEnabled;
        }
        SubstrateOptimizedCallTarget callTarget = TruffleFeature.getSupport().createOptimizedCallTarget(source, rootNode);
        this.ensureInitializedAtRuntime(callTarget);
        return callTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitializedAtRuntime(OptimizedCallTarget callTarget) {
        if (!SubstrateUtil.HOSTED && !this.initialized) {
            SubstrateTruffleRuntime substrateTruffleRuntime = this;
            synchronized (substrateTruffleRuntime) {
                if (!this.initialized) {
                    this.initializeAtRuntime(callTarget);
                    this.initialized = true;
                }
            }
        }
    }

    public SpeculationLog createSpeculationLog() {
        return new SubstrateSpeculationLog();
    }

    public void notifyTransferToInterpreter() {
        CompilerAsserts.neverPartOfCompilation();
    }

    public boolean isProfilingEnabled() {
        if (this.profilingEnabled == null) {
            this.profilingEnabled = SubstrateTruffleRuntime.getEngineData(null).profilingEnabled;
        }
        return this.profilingEnabled;
    }

    public CancellableCompileTask submitForCompilation(OptimizedCallTarget optimizedCallTarget, boolean lastTierCompilation) {
        block4: {
            if (SubstrateUtil.HOSTED) {
                return null;
            }
            this.ensureInitializedAtRuntime(optimizedCallTarget);
            if (SubstateTruffleOptions.isMultiThreaded()) {
                return super.submitForCompilation(optimizedCallTarget, lastTierCompilation);
            }
            try {
                this.doCompile(optimizedCallTarget, null);
            }
            catch (OptimizationFailedException e) {
                if (!((Boolean)TruffleRuntimeOptions.getPolyglotOptionValue((org.graalvm.options.OptionValues)optimizedCallTarget.getOptionValues(), (org.graalvm.options.OptionKey)PolyglotCompilerOptions.CompilationExceptionsArePrinted)).booleanValue()) break block4;
                Log.log().string(this.printStackTraceToString(e));
            }
        }
        return null;
    }

    public void finishCompilation(OptimizedCallTarget optimizedCallTarget, CancellableCompileTask task, boolean mayBeAsynchronous) {
        if (SubstateTruffleOptions.isMultiThreaded()) {
            super.finishCompilation(optimizedCallTarget, task, mayBeAsynchronous);
        }
    }

    public boolean cancelInstalledTask(OptimizedCallTarget optimizedCallTarget, Object source, CharSequence reason) {
        if (SubstateTruffleOptions.isMultiThreaded()) {
            return super.cancelInstalledTask(optimizedCallTarget, source, reason);
        }
        return false;
    }

    public void waitForCompilation(OptimizedCallTarget optimizedCallTarget, long timeout) throws ExecutionException, TimeoutException {
        if (SubstateTruffleOptions.isMultiThreaded()) {
            super.waitForCompilation(optimizedCallTarget, timeout);
            return;
        }
    }

    public boolean isCompiling(OptimizedCallTarget optimizedCallTarget) {
        if (SubstateTruffleOptions.isMultiThreaded()) {
            return super.isCompiling(optimizedCallTarget);
        }
        return false;
    }

    protected StackIntrospection getStackIntrospection() {
        return SubstrateStackIntrospection.SINGLETON;
    }

    public <T> T getOptions(Class<T> type) {
        if (type == OptionValues.class) {
            return type.cast((Object)RuntimeOptionValues.singleton());
        }
        return (T)super.getOptions(type);
    }

    public <T> T convertOptions(Class<T> type, Map<String, Object> map) {
        if (type == OptionValues.class) {
            EconomicMap values = OptionValues.newOptionMap();
            for (Map.Entry<String, Object> e : map.entrySet()) {
                String optionName = e.getKey();
                Object optionValue = e.getValue();
                Optional<OptionDescriptor> descriptor = RuntimeOptionParser.singleton().getDescriptor(optionName);
                if (!descriptor.isPresent()) continue;
                OptionDescriptor desc = descriptor.get();
                Class<?> valueType = optionValue.getClass();
                if (desc.getOptionValueType().isAssignableFrom(valueType)) {
                    values.put((Object)desc.getOptionKey(), optionValue);
                    continue;
                }
                throw new IllegalArgumentException("Invalid type of option '" + optionName + "': required " + desc.getOptionValueType().getSimpleName() + ", got " + valueType);
            }
            return type.cast(new OptionValues((UnmodifiableEconomicMap)values));
        }
        return (T)super.convertOptions(type, map);
    }

    protected Map<String, Object> createInitialOptions() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        UnmodifiableMapCursor optionValues = RuntimeOptionValues.singleton().getMap().getEntries();
        while (optionValues.advance()) {
            OptionKey key = (OptionKey)optionValues.getKey();
            Object value = optionValues.getValue();
            res.put(key.getName(), value);
        }
        return res;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void resetNativeImageState() {
        this.clearState();
    }

    protected <T> T asObject(Class<T> type, JavaConstant constant) {
        return (T)KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject(type, constant), Object.class);
    }

    protected JavaConstant forObject(Object object) {
        return SubstrateObjectConstant.forObject(object);
    }

    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumptionConstant) {
        return TruffleFeature.getSupport().registerOptimizedAssumptionDependency(optimizedAssumptionConstant);
    }

    public JavaConstant getCallTargetForCallNode(JavaConstant callNodeConstant) {
        return TruffleFeature.getSupport().getCallTargetForCallNode(callNodeConstant);
    }

    public CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
        return TruffleFeature.getSupport().asCompilableTruffleAST(constant);
    }

    public void log(CompilableTruffleAST compilable, String message) {
        if (!TruffleFeature.getSupport().tryLog(this, compilable, message)) {
            super.log(compilable, message);
        }
    }

    protected OutputStream getDefaultLogStream() {
        return TTY.out;
    }
}

