/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.access;

import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.MethodPointer;
import com.oracle.svm.jni.access.JNIAccessibleClass;
import com.oracle.svm.jni.access.JNIAccessibleMember;
import com.oracle.svm.jni.access.JNIAccessibleMethodDescriptor;
import com.oracle.svm.jni.hosted.JNIJavaCallWrapperMethod;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public final class JNIAccessibleMethod
extends JNIAccessibleMember {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final JNIAccessibleMethodDescriptor descriptor;
    private final int modifiers;
    private CFunctionPointer varargsCallWrapper;
    private CFunctionPointer arrayCallWrapper;
    private CFunctionPointer valistCallWrapper;
    private CFunctionPointer varargsNonvirtualCallWrapper;
    private CFunctionPointer arrayNonvirtualCallWrapper;
    private CFunctionPointer valistNonvirtualCallWrapper;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final JNIJavaCallWrapperMethod varargsCallWrapperMethod;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final JNIJavaCallWrapperMethod arrayCallWrapperMethod;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final JNIJavaCallWrapperMethod valistCallWrapperMethod;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final JNIJavaCallWrapperMethod varargsNonvirtualCallWrapperMethod;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final JNIJavaCallWrapperMethod arrayNonvirtualCallWrapperMethod;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final JNIJavaCallWrapperMethod valistNonvirtualCallWrapperMethod;

    public static ResolvedJavaField getCallWrapperField(MetaAccessProvider metaAccess, JNIJavaCallWrapperMethod.CallVariant variant, boolean nonVirtual) {
        StringBuilder name = new StringBuilder(32);
        if (variant == JNIJavaCallWrapperMethod.CallVariant.VARARGS) {
            name.append("varargs");
        } else if (variant == JNIJavaCallWrapperMethod.CallVariant.ARRAY) {
            name.append("array");
        } else if (variant == JNIJavaCallWrapperMethod.CallVariant.VA_LIST) {
            name.append("valist");
        } else {
            throw VMError.shouldNotReachHere();
        }
        if (nonVirtual) {
            name.append("Nonvirtual");
        }
        name.append("CallWrapper");
        try {
            return metaAccess.lookupJavaField(JNIAccessibleMethod.class.getDeclaredField(name.toString()));
        }
        catch (NoSuchFieldException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    JNIAccessibleMethod(JNIAccessibleMethodDescriptor descriptor, int modifiers, JNIAccessibleClass declaringClass, JNIJavaCallWrapperMethod varargsCallWrapper, JNIJavaCallWrapperMethod arrayCallWrapper, JNIJavaCallWrapperMethod valistCallWrapper, JNIJavaCallWrapperMethod varargsNonvirtualCallWrapperMethod, JNIJavaCallWrapperMethod arrayNonvirtualCallWrapperMethod, JNIJavaCallWrapperMethod valistNonvirtualCallWrapperMethod) {
        super(declaringClass);
        assert (varargsCallWrapper != null && arrayCallWrapper != null && valistCallWrapper != null);
        assert (!Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers) ? varargsNonvirtualCallWrapperMethod != null & arrayNonvirtualCallWrapperMethod != null && valistNonvirtualCallWrapperMethod != null : varargsNonvirtualCallWrapperMethod == null && arrayNonvirtualCallWrapperMethod == null && valistNonvirtualCallWrapperMethod == null);
        this.descriptor = descriptor;
        this.modifiers = modifiers;
        this.varargsCallWrapperMethod = varargsCallWrapper;
        this.arrayCallWrapperMethod = arrayCallWrapper;
        this.valistCallWrapperMethod = valistCallWrapper;
        this.varargsNonvirtualCallWrapperMethod = varargsNonvirtualCallWrapperMethod;
        this.arrayNonvirtualCallWrapperMethod = arrayNonvirtualCallWrapperMethod;
        this.valistNonvirtualCallWrapperMethod = valistNonvirtualCallWrapperMethod;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void finishBeforeCompilation(FeatureImpl.CompilationAccessImpl access) {
        HostedUniverse hUniverse = access.getUniverse();
        AnalysisUniverse aUniverse = access.getUniverse().getBigBang().getUniverse();
        this.varargsCallWrapper = MethodPointer.factory(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)this.varargsCallWrapperMethod)));
        this.arrayCallWrapper = MethodPointer.factory(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)this.arrayCallWrapperMethod)));
        this.valistCallWrapper = MethodPointer.factory(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)this.valistCallWrapperMethod)));
        if (!Modifier.isStatic(this.modifiers) && !Modifier.isAbstract(this.modifiers)) {
            this.varargsNonvirtualCallWrapper = MethodPointer.factory(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)this.varargsNonvirtualCallWrapperMethod)));
            this.arrayNonvirtualCallWrapper = MethodPointer.factory(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)this.arrayNonvirtualCallWrapperMethod)));
            this.valistNonvirtualCallWrapper = MethodPointer.factory(hUniverse.lookup((JavaMethod)aUniverse.lookup((JavaMethod)this.valistNonvirtualCallWrapperMethod)));
        }
        this.setHidingSubclasses(access.getMetaAccess(), this::anyMatchIgnoreReturnType);
    }

    private boolean anyMatchIgnoreReturnType(ResolvedJavaType sub) {
        for (ResolvedJavaMethod method : sub.getDeclaredMethods()) {
            if (!this.descriptor.matchesIgnoreReturnType(method)) continue;
            return true;
        }
        return false;
    }
}

