/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.code.InstantReferenceAdjuster;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.code.CompilationInfo;
import com.oracle.svm.hosted.code.CompilationInfoSupport;
import com.oracle.svm.hosted.image.NativeBootImage;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.NativeImageHeapWriter;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.UnsignedWord;

public abstract class NativeImageCodeCache {
    private final NativeImageHeap imageHeap;
    protected final Map<HostedMethod, CompilationResult> compilations;
    protected final NavigableMap<Integer, CompilationResult> compilationsByStart = new TreeMap<Integer, CompilationResult>();
    protected final Platform targetPlatform;
    private final DataSection dataSection;
    private final Map<Constant, String> constantReasons = new HashMap<Constant, String>();

    public NativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap) {
        this(compilations, imageHeap, (Platform)ImageSingletons.lookup(Platform.class));
    }

    public NativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap, Platform targetPlatform) {
        this.compilations = compilations;
        this.imageHeap = imageHeap;
        this.dataSection = new DataSection();
        this.targetPlatform = targetPlatform;
    }

    public abstract int getCodeCacheSize();

    public CompilationResult getCompilationAtOffset(int offset) {
        Map.Entry<Integer, CompilationResult> floor = this.compilationsByStart.floorEntry(offset);
        if (floor != null) {
            return floor.getValue();
        }
        return null;
    }

    public CompilationResult getFirstCompilation() {
        Map.Entry<Integer, CompilationResult> floor = this.compilationsByStart.ceilingEntry(0);
        if (floor != null) {
            return floor.getValue();
        }
        return null;
    }

    public abstract void layoutMethods(DebugContext var1, String var2, BigBang var3, ForkJoinPool var4);

    public void layoutConstants() {
        for (CompilationResult compilation : this.compilations.values()) {
            SubstrateObjectConstant constant;
            for (DataSection.Data data : compilation.getDataSection()) {
                if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
                constant = ((SubstrateDataBuilder.ObjectData)data).getConstant();
                this.constantReasons.put(constant, compilation.getName());
            }
            this.dataSection.addAll(compilation.getDataSection());
            for (DataPatch patch : compilation.getDataPatches()) {
                if (!(patch.reference instanceof ConstantReference)) continue;
                constant = ((ConstantReference)patch.reference).getConstant();
                this.constantReasons.put(constant, compilation.getName());
            }
        }
        this.dataSection.close();
    }

    public void addConstantsToHeap() {
        for (DataSection.Data data : this.dataSection) {
            if (!(data instanceof SubstrateDataBuilder.ObjectData)) continue;
            SubstrateObjectConstant constant = ((SubstrateDataBuilder.ObjectData)data).getConstant();
            this.addConstantToHeap(constant);
        }
        for (CompilationResult compilationResult : this.compilations.values()) {
            for (DataPatch patch : compilationResult.getDataPatches()) {
                if (!(patch.reference instanceof ConstantReference)) continue;
                this.addConstantToHeap((Constant)((ConstantReference)patch.reference).getConstant(), compilationResult.getName());
            }
        }
    }

    private void addConstantToHeap(Constant constant) {
        this.addConstantToHeap(constant, null);
    }

    private void addConstantToHeap(Constant constant, Object reason) {
        Object obj = SubstrateObjectConstant.asObject(constant);
        if (!this.imageHeap.getMetaAccess().lookupJavaType((Class)obj.getClass()).getWrapped().isInstantiated()) {
            throw VMError.shouldNotReachHere("Non-instantiated type referenced by a compiled method: " + obj.getClass().getName() + "." + (reason != null ? " Method: " + reason : ""));
        }
        this.imageHeap.addObject(obj, false, this.constantReasons.get(constant));
    }

    protected int getConstantsSize() {
        return this.dataSection.getSectionSize();
    }

    public int getAlignedConstantsSize() {
        return ConfigurationValues.getObjectLayout().alignUp(this.getConstantsSize());
    }

    public void buildRuntimeMetadata(CFunctionPointer firstMethod, UnsignedWord codeSize) {
        FrameInfoCustomization frameInfoCustomization = new FrameInfoCustomization();
        CodeInfoEncoder codeInfoEncoder = new CodeInfoEncoder(frameInfoCustomization);
        for (Map.Entry<HostedMethod, CompilationResult> entry : this.compilations.entrySet()) {
            HostedMethod method = entry.getKey();
            CompilationResult compilation = entry.getValue();
            codeInfoEncoder.addMethod(method, compilation, method.getCodeAddressOffset());
        }
        if (NativeImageOptions.PrintMethodHistogram.getValue().booleanValue()) {
            System.out.println("encoded deopt entry points                 ; " + frameInfoCustomization.numDeoptEntryPoints);
            System.out.println("encoded during call entry points           ; " + frameInfoCustomization.numDuringCallEntryPoints);
        }
        ImageCodeInfo.HostedImageCodeInfo imageCodeInfo = CodeInfoTable.getImageCodeCache().getHostedImageCodeInfo();
        codeInfoEncoder.encodeAllAndInstall(imageCodeInfo, new InstantReferenceAdjuster());
        imageCodeInfo.setCodeStart((CodePointer)firstMethod);
        imageCodeInfo.setCodeSize(codeSize);
        if (CodeInfoEncoder.Options.CodeInfoEncoderCounters.getValue().booleanValue()) {
            for (Counter counter : ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).group.getCounters()) {
                System.out.println(counter.getName() + " ; " + counter.getValue());
            }
        }
        if (Options.VerifyDeoptimizationEntryPoints.getValue().booleanValue()) {
            this.verifyDeoptEntries(imageCodeInfo);
        }
        assert (this.verifyMethods(codeInfoEncoder, imageCodeInfo));
    }

    private void verifyDeoptEntries(CodeInfo codeInfo) {
        boolean hasError = false;
        ArrayList<Map.Entry<AnalysisMethod, Set<Long>>> deoptEntries = new ArrayList<Map.Entry<AnalysisMethod, Set<Long>>>(CompilationInfoSupport.singleton().getDeoptEntries().entrySet());
        deoptEntries.sort((e1, e2) -> ((AnalysisMethod)e1.getKey()).format("%H.%n(%p)").compareTo(((AnalysisMethod)e2.getKey()).format("%H.%n(%p)")));
        for (Map.Entry entry : deoptEntries) {
            HostedMethod method = this.imageHeap.getUniverse().lookup((JavaMethod)entry.getKey());
            ArrayList encodedBcis = new ArrayList((Collection)entry.getValue());
            encodedBcis.sort((v1, v2) -> Long.compare(v1, v2));
            Iterator iterator = encodedBcis.iterator();
            while (iterator.hasNext()) {
                long encodedBci = (Long)iterator.next();
                hasError |= NativeImageCodeCache.verifyDeoptEntry(codeInfo, method, encodedBci);
            }
        }
        if (hasError) {
            VMError.shouldNotReachHere("Verification of deoptimization entry points failed");
        }
    }

    private static boolean verifyDeoptEntry(CodeInfo codeInfo, HostedMethod method, long encodedBci) {
        int deoptOffsetInImage = method.getDeoptOffsetInImage();
        if (deoptOffsetInImage <= 0) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point method not compiled");
        }
        CodeInfoQueryResult result = new CodeInfoQueryResult();
        long relativeIP = CodeInfoAccess.lookupDeoptimizationEntrypoint(codeInfo, deoptOffsetInImage, encodedBci, result);
        if (relativeIP < 0L) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point not found");
        }
        if (result.getFrameInfo() == null || !result.getFrameInfo().isDeoptEntry() || result.getFrameInfo().getEncodedBci() != encodedBci) {
            return NativeImageCodeCache.error(method, encodedBci, "entry point found, but wrong property");
        }
        return false;
    }

    private static boolean error(HostedMethod method, long encodedBci, String msg) {
        System.out.println(method.format("%H.%n(%p)") + ", encodedBci " + encodedBci + " (bci " + FrameInfoDecoder.readableBci(encodedBci) + "): " + msg);
        return true;
    }

    private boolean verifyMethods(CodeInfoEncoder codeInfoEncoder, CodeInfo codeInfo) {
        for (Map.Entry<HostedMethod, CompilationResult> entry : this.compilations.entrySet()) {
            CodeInfoEncoder.verifyMethod(entry.getKey(), entry.getValue(), entry.getKey().getCodeAddressOffset(), codeInfo);
        }
        codeInfoEncoder.verifyFrameInfo(codeInfo);
        return true;
    }

    public abstract void patchMethods(DebugContext var1, RelocatableBuffer var2, ObjectFile var3);

    public abstract void writeCode(RelocatableBuffer var1);

    public void writeConstants(NativeImageHeapWriter writer, RelocatableBuffer buffer) {
        ByteBuffer bb = buffer.getBuffer();
        this.dataSection.buildDataSection(bb, (position, constant) -> writer.writeReference(buffer, position, SubstrateObjectConstant.asObject((Constant)constant), "VMConstant: " + constant));
    }

    public abstract NativeBootImage.NativeTextSectionImpl getTextSectionImpl(RelocatableBuffer var1, ObjectFile var2, NativeImageCodeCache var3);

    public Path[] getCCInputFiles(Path tempDirectory, String imageName) {
        return new Path[]{tempDirectory.resolve(imageName + ObjectFile.getFilenameSuffix())};
    }

    public abstract List<ObjectFile.Symbol> getSymbols(ObjectFile var1, boolean var2);

    public Map<HostedMethod, CompilationResult> getCompilations() {
        return this.compilations;
    }

    public void printCompilationResults() {
        System.out.println("--- compiled methods");
        for (Map.Entry<HostedMethod, CompilationResult> entry : this.compilations.entrySet()) {
            HostedMethod method = entry.getKey();
            CompilationResult result = entry.getValue();
            System.out.format("%8d %5d %s: frame %d\n", method.getCodeAddressOffset(), result.getTargetCodeSize(), method.format("%H.%n(%p)"), result.getTotalFrameSize());
        }
        System.out.println("--- vtables:");
        for (HostedType type : this.imageHeap.getUniverse().getTypes()) {
            for (int i = 0; i < type.getVTable().length; ++i) {
                CompilationResult comp;
                HostedMethod method = type.getVTable()[i];
                if (method == null || (comp = this.compilations.get(type.getVTable()[i])) == null) continue;
                System.out.format("%d %s @ %d: %s = 0x%x\n", type.getTypeID(), type.toJavaName(false), i, method.format("%r %n(%p)"), method.getCodeAddressOffset());
            }
        }
    }

    private static class FrameInfoCustomization
    extends FrameInfoEncoder.NamesFromMethod {
        int numDeoptEntryPoints;
        int numDuringCallEntryPoints;

        private FrameInfoCustomization() {
        }

        @Override
        protected Class<?> getDeclaringJavaClass(ResolvedJavaMethod method) {
            HostedType type = (HostedType)method.getDeclaringClass();
            assert (type.getWrapped().isInTypeCheck()) : "Declaring class not marked as used, therefore the DynamicHub is not initialized properly: " + method.format("%H.%n(%p)");
            return type.getJavaClass();
        }

        @Override
        protected boolean shouldStoreMethod() {
            return false;
        }

        @Override
        protected boolean shouldInclude(ResolvedJavaMethod method, Infopoint infopoint) {
            CompilationInfo compilationInfo = ((HostedMethod)method).compilationInfo;
            BytecodeFrame topFrame = infopoint.debugInfo.frame();
            if (this.isDeoptEntry(method, infopoint)) {
                if (infopoint instanceof DeoptEntryInfopoint) {
                    ++this.numDeoptEntryPoints;
                } else if (infopoint instanceof Call) {
                    ++this.numDuringCallEntryPoints;
                } else {
                    throw VMError.shouldNotReachHere();
                }
                return true;
            }
            BytecodeFrame rootFrame = topFrame;
            while (rootFrame.caller() != null) {
                rootFrame = rootFrame.caller();
            }
            assert (rootFrame.getMethod().equals(method));
            boolean isDeoptEntry = compilationInfo.isDeoptEntry(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException);
            if (infopoint instanceof DeoptEntryInfopoint) {
                assert (isDeoptEntry);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame";
                ++this.numDeoptEntryPoints;
                return true;
            }
            if (isDeoptEntry && topFrame.duringCall) {
                assert (infopoint instanceof Call);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame";
                ++this.numDuringCallEntryPoints;
                return true;
            }
            for (BytecodeFrame frame = topFrame; frame != null; frame = frame.caller()) {
                if (!CompilationInfoSupport.singleton().isFrameInformationRequired(frame.getMethod())) continue;
                return true;
            }
            return compilationInfo.canDeoptForTesting();
        }

        @Override
        protected boolean isDeoptEntry(ResolvedJavaMethod method, Infopoint infopoint) {
            BytecodeFrame topFrame;
            CompilationInfo compilationInfo = ((HostedMethod)method).compilationInfo;
            BytecodeFrame rootFrame = topFrame = infopoint.debugInfo.frame();
            while (rootFrame.caller() != null) {
                rootFrame = rootFrame.caller();
            }
            assert (rootFrame.getMethod().equals(method));
            boolean isDeoptEntry = compilationInfo.isDeoptEntry(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException);
            if (infopoint instanceof DeoptEntryInfopoint) {
                assert (isDeoptEntry);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame";
                return true;
            }
            if (isDeoptEntry && topFrame.duringCall) {
                assert (infopoint instanceof Call);
                assert (topFrame == rootFrame) : "Deoptimization target has inlined frame";
                return true;
            }
            return false;
        }
    }

    public static class Options {
        @Option(help={"Verify that all possible deoptimization entry points have been properly compiled and registered in the metadata"})
        public static final HostedOptionKey<Boolean> VerifyDeoptimizationEntryPoints = new HostedOptionKey<Boolean>(false);
    }
}

