/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta.amd64;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.graal.meta.RuntimeCodeInstaller;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.graalvm.compiler.core.common.NumUtil;

public class AMD64RuntimeCodeInstallerPlatformHelper
implements RuntimeCodeInstaller.RuntimeCodeInstallerPlatformHelper {
    @Override
    public int getTrampolineCallSize() {
        return 6;
    }

    @Override
    public boolean targetWithinPCDisplacement(long pcDisplacement) {
        return pcDisplacement == (long)((int)pcDisplacement);
    }

    @Override
    public int insertTrampolineCalls(byte[] compiledBytes, int initialPos, Map<Long, Integer> directTargets) {
        int currentPos = NumUtil.roundUp((int)initialPos, (int)8);
        ByteOrder byteOrder = ConfigurationValues.getTarget().arch.getByteOrder();
        assert (byteOrder == ByteOrder.LITTLE_ENDIAN) : "Code below assumes little-endian byte order";
        ByteBuffer codeBuffer = ByteBuffer.wrap(compiledBytes).order(byteOrder);
        for (Map.Entry<Long, Integer> entry : directTargets.entrySet()) {
            long targetAddress = entry.getKey();
            int trampolineOffset = entry.getValue();
            codeBuffer.put(trampolineOffset + 0, (byte)-1);
            codeBuffer.put(trampolineOffset + 1, (byte)37);
            codeBuffer.putInt(trampolineOffset + 2, currentPos - (trampolineOffset + this.getTrampolineCallSize()));
            codeBuffer.putLong(currentPos, targetAddress);
            currentPos += 8;
        }
        return currentPos;
    }

    @Override
    public void performCodeSynchronization(CodeInfo codeInfo) {
    }
}

