/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.os.AbstractCommittedMemoryProvider;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class OSCommittedMemoryProvider
extends AbstractCommittedMemoryProvider {
    private static final boolean virtualMemoryVerboseDebugging = false;
    private final VirtualMemoryTracker tracker = new VirtualMemoryTracker();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public OSCommittedMemoryProvider() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static UnsignedWord defaultAlignment() {
        return VirtualMemoryProvider.get().getAlignment();
    }

    @Override
    @Uninterruptible(reason="Still being initialized.")
    public int initialize(WordPointer isolatePointer, CEntryPointCreateIsolateParameters parameters) {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            isolatePointer.write((WordBase)CEntryPointSetup.SINGLE_ISOLATE_SENTINEL);
            return 0;
        }
        return ImageHeapProvider.get().initialize((Pointer)WordFactory.nullPointer(), (UnsignedWord)WordFactory.zero(), isolatePointer, (WordPointer)WordFactory.nullPointer());
    }

    @Override
    @Uninterruptible(reason="Tear-down in progress.")
    public int tearDown() {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            return 0;
        }
        PointerBase heapBase = Isolates.getHeapBase(CurrentIsolate.getIsolate());
        return ImageHeapProvider.get().freeImageHeap(heapBase);
    }

    @Override
    public Pointer allocate(UnsignedWord size, UnsignedWord alignment, boolean executable) {
        if (alignment.equal(UNALIGNED)) {
            return this.allocate(size, executable);
        }
        UnsignedWord pageSize = this.getGranularity();
        UnsignedWord containerSize = alignment.add(size);
        UnsignedWord pagedContainerSize = UnsignedUtils.roundUp(containerSize, pageSize);
        Pointer containerStart = VirtualMemoryProvider.get().commit(WordFactory.nullPointer(), pagedContainerSize, OSCommittedMemoryProvider.defaultProtection(executable));
        if (containerStart.isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        this.trackVirtualMemory(pagedContainerSize);
        Pointer containerEnd = containerStart.add(pagedContainerSize);
        Pointer start = PointerUtils.roundUp((PointerBase)containerStart, alignment);
        Pointer end = start.add(size);
        Pointer pagedStart = PointerUtils.roundDown((PointerBase)start, pageSize);
        Pointer prefixStart = containerStart;
        Pointer prefixEnd = pagedStart;
        Pointer prefixSize = prefixEnd.subtract((UnsignedWord)prefixStart);
        if (prefixSize.aboveOrEqual(pageSize) && !this.free((PointerBase)prefixStart, (UnsignedWord)prefixSize)) {
            this.free((PointerBase)containerStart, pagedContainerSize);
            return (Pointer)WordFactory.nullPointer();
        }
        Pointer suffixEnd = containerEnd;
        Pointer pagedEnd = PointerUtils.roundUp((PointerBase)end, pageSize);
        Pointer suffixStart = pagedEnd;
        Pointer suffixSize = suffixEnd.subtract((UnsignedWord)suffixStart);
        if (suffixSize.aboveOrEqual(pageSize) && !this.free((PointerBase)suffixStart, (UnsignedWord)suffixSize)) {
            this.free((PointerBase)pagedStart, (UnsignedWord)containerEnd.subtract((UnsignedWord)pagedStart));
            return (Pointer)WordFactory.nullPointer();
        }
        return start;
    }

    protected final Pointer allocate(UnsignedWord size, boolean executable) {
        Pointer start = VirtualMemoryProvider.get().commit(WordFactory.nullPointer(), size, OSCommittedMemoryProvider.defaultProtection(executable));
        if (start.isNonNull()) {
            this.trackVirtualMemory(size);
        }
        return start;
    }

    protected static int defaultProtection(boolean executable) {
        int access = 3;
        if (executable) {
            access |= 4;
        }
        return access;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean free(PointerBase start, UnsignedWord nbytes, UnsignedWord alignment, boolean executable) {
        UnsignedWord pageSize = this.getGranularity();
        Pointer end = ((Pointer)start).add(nbytes);
        Pointer pagedStart = PointerUtils.roundDown(start, pageSize);
        Pointer pagedEnd = PointerUtils.roundUp((PointerBase)end, pageSize);
        Pointer pagedSize = pagedEnd.subtract((UnsignedWord)pagedStart);
        return this.free((PointerBase)pagedStart, (UnsignedWord)pagedSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected final boolean free(PointerBase start, UnsignedWord size) {
        boolean success;
        boolean bl = success = VirtualMemoryProvider.get().free(start, size) == 0;
        if (success) {
            this.untrackVirtualMemory(size);
        }
        return success;
    }

    private void trackVirtualMemory(UnsignedWord size) {
        this.tracker.track(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void untrackVirtualMemory(UnsignedWord size) {
        this.tracker.untrack(size);
    }

    protected static class VirtualMemoryTracker {
        private UnsignedWord totalAllocated = (UnsignedWord)WordFactory.zero();

        protected VirtualMemoryTracker() {
        }

        public void track(UnsignedWord size) {
            this.totalAllocated = this.totalAllocated.add(size);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void untrack(UnsignedWord size) {
            this.totalAllocated = this.totalAllocated.subtract(size);
        }
    }
}

