/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets.aarch64;

import com.oracle.svm.core.graal.snippets.ArithmeticSnippets;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.aarch64.SafeFloatRemNode;
import java.util.Map;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.RemNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.word.LocationIdentity;

final class AArch64ArithmeticSnippets
extends ArithmeticSnippets {
    private final SnippetTemplate.SnippetInfo drem;
    private final SnippetTemplate.SnippetInfo frem = this.snippet(AArch64ArithmeticSnippets.class, "fremSnippet", new LocationIdentity[0]);

    @Snippet
    protected static float fremSnippet(float x, float y) {
        if (Float.isInfinite(x) || y == 0.0f || Float.isNaN(y)) {
            return Float.NaN;
        }
        if (x == 0.0f || Float.isInfinite(y)) {
            return x;
        }
        float result = AArch64ArithmeticSnippets.safeRem(x, y);
        if (result == 0.0f && x < 0.0f) {
            return -result;
        }
        return result;
    }

    @Snippet
    protected static double dremSnippet(double x, double y) {
        if (Double.isInfinite(x) || y == 0.0 || Double.isNaN(y)) {
            return Double.NaN;
        }
        if (x == 0.0 || Double.isInfinite(y)) {
            return x;
        }
        double result = AArch64ArithmeticSnippets.safeRem(x, y);
        if (result == 0.0 && x < 0.0) {
            return -result;
        }
        return result;
    }

    @Node.NodeIntrinsic(value=SafeFloatRemNode.class)
    private static native float safeRem(float var0, float var1);

    @Node.NodeIntrinsic(value=SafeFloatRemNode.class)
    private static native double safeRem(double var0, double var2);

    public static void registerLowerings(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new AArch64ArithmeticSnippets(options, factories, providers, snippetReflection, lowerings);
    }

    private AArch64ArithmeticSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection, lowerings);
        this.drem = this.snippet(AArch64ArithmeticSnippets.class, "dremSnippet", new LocationIdentity[0]);
        lowerings.put(RemNode.class, new AArch64RemLowering());
        lowerings.put(SafeFloatRemNode.class, new ArithmeticSnippets.IdentityLowering());
    }

    protected class AArch64RemLowering
    implements NodeLoweringProvider<RemNode> {
        protected AArch64RemLowering() {
        }

        @Override
        public void lower(RemNode node, LoweringTool tool) {
            JavaKind kind = node.stamp(NodeView.DEFAULT).getStackKind();
            assert (kind == JavaKind.Float || kind == JavaKind.Double);
            SnippetTemplate.SnippetInfo snippet = kind == JavaKind.Float ? AArch64ArithmeticSnippets.this.frem : AArch64ArithmeticSnippets.this.drem;
            StructuredGraph graph = node.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("x", (Object)node.getX());
            args.add("y", (Object)node.getY());
            AArch64ArithmeticSnippets.this.template((ValueNode)node, args).instantiate(AArch64ArithmeticSnippets.this.providers.getMetaAccess(), (FloatingNode)node, SnippetTemplate.DEFAULT_REPLACER, tool, args);
        }
    }
}

