/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class GreyObjectsWalker {
    private Space space;
    private AlignedHeapChunk.AlignedHeader alignedHeapChunk;
    private Pointer alignedTop;
    private UnalignedHeapChunk.UnalignedHeader unalignedHeapChunk;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static GreyObjectsWalker factory() {
        return new GreyObjectsWalker();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private GreyObjectsWalker() {
    }

    void setScanStart(Space s) {
        UnalignedHeapChunk.UnalignedHeader uChunk;
        AlignedHeapChunk.AlignedHeader aChunk;
        Log trace = Log.noopLog().string("[Space.GreyObjectsWalker.setScanStart:").string("  s: ").string(s.getName());
        this.space = s;
        this.alignedHeapChunk = aChunk = s.getLastAlignedHeapChunk();
        trace.string("  alignedHeapChunk: ").hex((WordBase)this.alignedHeapChunk).string("  isNull: ").bool(aChunk.isNull());
        this.alignedTop = aChunk.isNonNull() ? aChunk.getTop() : (Pointer)WordFactory.nullPointer();
        trace.string("  alignedTop: ").hex((WordBase)this.alignedTop);
        this.unalignedHeapChunk = uChunk = s.getLastUnalignedHeapChunk();
        trace.string("  unalignedChunkPointer: ").hex((WordBase)this.unalignedHeapChunk).string("]").newline();
    }

    @AlwaysInline(value="GC performance")
    protected boolean haveGreyObjects() {
        return this.alignedHeapChunk.notEqual((ComparableWord)this.space.getLastAlignedHeapChunk()) || this.alignedHeapChunk.isNonNull() && this.alignedTop.notEqual((UnsignedWord)this.alignedHeapChunk.getTop()) || this.unalignedHeapChunk.notEqual((ComparableWord)this.space.getLastUnalignedHeapChunk());
    }

    @NeverInline(value="Split the GC into reasonable compilation units")
    void walkGreyObjects() {
        while (this.haveGreyObjects()) {
            this.walkAlignedGreyObjects();
            this.walkUnalignedGreyObjects();
        }
    }

    @AlwaysInline(value="GC performance")
    private void walkAlignedGreyObjects() {
        AlignedHeapChunk.AlignedHeader aChunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        Pointer aOffset = (Pointer)WordFactory.nullPointer();
        if (this.alignedHeapChunk.isNull() && this.alignedTop.isNull()) {
            aChunk = this.space.getFirstAlignedHeapChunk();
            aOffset = aChunk.isNonNull() ? AlignedHeapChunk.getAlignedHeapChunkStart(aChunk) : (Pointer)WordFactory.nullPointer();
        } else {
            aChunk = this.alignedHeapChunk;
            aOffset = this.alignedTop;
        }
        GreyToBlackObjectVisitor visitor = GCImpl.getGCImpl().getGreyToBlackObjectVisitor();
        if (aChunk.isNonNull()) {
            AlignedHeapChunk.AlignedHeader lastChunk;
            do {
                lastChunk = aChunk;
                if (!AlignedHeapChunk.walkObjectsFromInline(aChunk, aOffset, visitor)) {
                    throw VMError.shouldNotReachHere();
                }
                Pointer pointer = aOffset = (aChunk = (AlignedHeapChunk.AlignedHeader)aChunk.getNext()).isNonNull() ? AlignedHeapChunk.getAlignedHeapChunkStart(aChunk) : (Pointer)WordFactory.nullPointer();
            } while (aChunk.isNonNull());
            this.alignedHeapChunk = lastChunk;
            this.alignedTop = lastChunk.getTop();
        }
    }

    @AlwaysInline(value="GC performance")
    private void walkUnalignedGreyObjects() {
        UnalignedHeapChunk.UnalignedHeader uChunk = this.unalignedHeapChunk.isNull() ? this.space.getFirstUnalignedHeapChunk() : (UnalignedHeapChunk.UnalignedHeader)this.unalignedHeapChunk.getNext();
        GreyToBlackObjectVisitor visitor = GCImpl.getGCImpl().getGreyToBlackObjectVisitor();
        if (uChunk.isNonNull()) {
            UnalignedHeapChunk.UnalignedHeader lastChunk;
            do {
                lastChunk = uChunk;
                if (UnalignedHeapChunk.walkObjectsFromInline(uChunk, UnalignedHeapChunk.getUnalignedHeapChunkStart(uChunk), visitor)) continue;
                throw VMError.shouldNotReachHere();
            } while ((uChunk = (UnalignedHeapChunk.UnalignedHeader)uChunk.getNext()).isNonNull());
            this.unalignedHeapChunk = lastChunk;
        }
    }
}

