/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni;

import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.jni.JNIOnLoadFunctionPointer;
import com.oracle.svm.jni.functions.JNIFunctionTables;
import com.oracle.svm.jni.nativeapi.JNIJavaVM;
import com.oracle.svm.jni.nativeapi.JNIVersion;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class JNILibraryInitializer
implements NativeLibrarySupport.LibraryInitializer {
    JNILibraryInitializer() {
    }

    private static String getOnLoadName(String libName, boolean builtIn) {
        String name = "JNI_OnLoad";
        if (builtIn) {
            return name + "_" + libName;
        }
        return name;
    }

    @Override
    public boolean isBuiltinLibrary(String libName) {
        if (PlatformNativeLibrarySupport.singleton().isBuiltinLibrary(libName)) {
            return true;
        }
        String onLoadName = JNILibraryInitializer.getOnLoadName(libName, true);
        PointerBase onLoad = PlatformNativeLibrarySupport.singleton().findBuiltinSymbol(onLoadName);
        return onLoad.isNonNull();
    }

    @CFunction(value="JNI_OnLoad_net")
    private static native int nativeJNIOnLoadNet(JNIJavaVM var0, VoidPointer var1);

    @Override
    public void initialize(PlatformNativeLibrarySupport.NativeLibrary lib) {
        String name = JNILibraryInitializer.getOnLoadName(lib.getCanonicalIdentifier(), lib.isBuiltin());
        if (name.equals("JNI_OnLoad_net")) {
            int expected = JNILibraryInitializer.nativeJNIOnLoadNet(JNIFunctionTables.singleton().getGlobalJavaVM(), (VoidPointer)WordFactory.nullPointer());
            JNILibraryInitializer.checkSupportedJNIVersion(lib, expected);
        } else {
            PointerBase symbol = lib.findSymbol(name);
            if (symbol.isNonNull()) {
                JNIOnLoadFunctionPointer onLoad = (JNIOnLoadFunctionPointer)symbol;
                int expected = onLoad.invoke(JNIFunctionTables.singleton().getGlobalJavaVM(), (VoidPointer)WordFactory.nullPointer());
                JNILibraryInitializer.checkSupportedJNIVersion(lib, expected);
            }
        }
    }

    private static void checkSupportedJNIVersion(PlatformNativeLibrarySupport.NativeLibrary lib, int expected) {
        if (expected != JNIVersion.JNI_VERSION_1_8() && expected != JNIVersion.JNI_VERSION_1_6() && expected != JNIVersion.JNI_VERSION_1_4() && expected != JNIVersion.JNI_VERSION_1_2() && expected != JNIVersion.JNI_VERSION_1_1()) {
            String message = "Unsupported JNI version 0x" + Integer.toHexString(expected) + ", required by " + lib.getCanonicalIdentifier();
            throw new UnsatisfiedLinkError(message);
        }
    }
}

